// Función para solicitar el fichero JSON de los datos del Informe
// Parámetros: "Nombre de informe y ID, key del dato a obtener

function pedirJsonInforme(informe,id) { 

    // 1. Hacemos petición AJAX al servidor (ej: API REST)
    $.ajax({
        type: 'POST',                                   //  SEND with POST method
        url: './MyCode/ajax_php/'+informe+'.php',           // Destination file (the PHP that manages the data)
        async: false,                                   // We do a synchronous operation
        data: { ID: id },                               // Data that are sent
        
        success: function(data) {
            Swal.fire({
            	 // icon: 'info',
            	 title: 'El Informe se ha descargado',
            	 text: '',
            	 imageUrl: "MyCode/images/download.gif",
            	 imageHeight: 200,
                 imageAlt: "Estamos trabajando",
            	 timer: 4000,
            	 timerProgressBar: true,
            	 toast: true,
            	 showConfirmButton: false,
            	 position:  'center', // "top-start",
            	 footer: ''
            	});
            // 2. Si la petición es exitosa, generamos el PDF con los datos
            // console.log("Datos Recibidos: ",resp);
            // console.log("Identificador: ",id);
            generarPDFConDatos(data,id);                   // Generando el PDF
        },
        
        error: function(error) {
            console.error("Error al obtener datos:", error);
            alert("¡Error al crear JSON de los datos!");
        }
    });
}