// Función que genera el PDF con los datos obtenidos
function generarPDFConDatos(datos,id) {

// console.log("datos recibidos 'todos': ",datos);
// console.log("datos recibidos 'invoice': ",datos.invoice);
// console.log("datos recibidos 'lines': ",datos.lines);
// console.log("Identificador id: ",id);

// Configuration partition of URL of access to images
const url = new URL(window.location.href);
// console.log("URL de ejecución:", url);
if ( url.hostname == "localhost") {
    var config_url = 'http://localhost/invoice_pdfmake/';
} else {
    var config_url = 'https://fhumanes.com/invoice_pdfmake/';
}


// playground requires you to assign document definition to a variable called dd
let decimal = new Intl.NumberFormat('es-ES', {
    style: 'decimal',
    // currency: 'EUR',
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
	useGrouping: true // Esto fuerza el separador de miles
});

// Formateador de fechas para valores MySQL
let fechaFormato = new Intl.DateTimeFormat('es-ES', {
    year: 'numeric',
    month: '2-digit',
    day: '2-digit',
    // hour: '2-digit',    // descomenta si necesitas hora
    // minute: '2-digit', // descomenta si necesitas hora
    // second: '2-digit',  // descomenta si necesitas hora
    // hour12: false       // usa formato 24h si necesitas hora
});

// Función para formatear fechas desde MySQL
function formatearFechaMySQL(fechaMySQL) {
    // Convertir la fecha MySQL a objeto Date
    const fecha = new Date(fechaMySQL);
    // Verificar si la conversión fue válida
    if (isNaN(fecha.getTime())) {
        console.error('Fecha inválida:', fechaMySQL);
        return 'Fecha inválida';
    }
    return fechaFormato.format(fecha);
}

// Definición del Informe 
var dd =  
{
    // a string or { width: number, height: number }
    pageSize: 'A5',
    // by default we use portrait, you can change it to landscape if you wish
    pageOrientation: 'landscape',
    // [left, top, right, bottom] or [horizontal, vertical] or just a number for equal margins
    pageMargins: [ 50, 30, 20, 40 ],
    
    footer: function(currentPage, pageCount) 
    { 
        return [
            {text: 'Página: '+currentPage.toString() + ' de ' + pageCount ,margin: [30,10,10,0],alignment: 'right' }
            ]
    },
    header: function(currentPage, pageCount, pageSize) 
    {
        // you can apply any logic and return any valid pdfmake element
        return [
        { text: ' ',margin: [30,10,30,10], alignment: (currentPage % 2) ? 'left' : 'right' },
        { canvas: [ { type: 'rect', x: 170, y: 32, w: pageSize.width - 170, h: 40 } ] }
        ]
    },
        
    content: 
    [
      {
          layout: 'noBorders', // optional
          table: {
            widths: ['auto', '*', 'auto'],
            body: 
            [ 
                [ 
                  { image: 'logo' ,
                      width: 75 },
                  { text: '\nFACTURA/INVOICE', style: 'header' },
                  { text: `\nNúmero: ${datos.invoice.idfactura}`, margin: [0, 10], color: 'blue'},
                ]
            ]
          },
      }, 
      { text: '\n\n' },
      { text: `Fecha: ${formatearFechaMySQL(datos.invoice.FechaFactura)}` },
      { text: `Cliente: ${datos.invoice.NombreRazonSocial}` },
      { text: `NIF: ${datos.invoice.Nif}`, margin: [0, 0, 0, 20] },
      
      {
        layout: 'lightHorizontalLines', // optional
        table: {
          headerRows: 1,
          widths: ['*', 'auto', 'auto', 'auto'],
          body: [
              [
                  { text: 'Descripción', style: 'tableHeader' },
                  { text: 'Cantidad', style: 'tableHeader', alignment: 'center' },
                  { text: 'Precio', style: 'tableHeader', alignment: 'right' },
                  { text: 'Total', style: 'tableHeader', alignment: 'right' }
              ],
            ...datos.lines.map(item => 
              [
                  item.Nombre,
                  { text: item.Cantidad ,alignment: 'center'},
                  { text: decimal.format(item.Precio),alignment: 'right'} ,
                  { text: decimal.format(item.Valor),alignment: 'right'} ,
              ]), 
                // Asegúrate de que cada fila tenga exactamente 4 elementos:
              // [{ text: 'Subtotal:', alignment: 'right', colSpan: 3 },'', '',  { text: decimal.format(subtotal),alignment: 'right'}],
              // [{ text: 'IVA (16%):', alignment: 'right', colSpan: 3 },'', '',  { text: decimal.format(iva),alignment: 'right'}],
              [{ text: 'Total:', alignment: 'right', colSpan: 3, bold: true },'', '',  { text: decimal.format(datos.invoice.TotalFactura),alignment: 'right', bold: true}],
      
          ],
        },
      }, 
    ],
    images: 
    {
        logo: config_url+'MyCode/images/logo_oficinas.png',
    },
    styles: {
        header: { 
            fontSize: 18, 
            font: 'Roboto', 
            bold: true,
            alignment: 'center' },
        tableHeader: {
            font: 'Roboto', 
            bold: true,
            fontSize: 13,
            fillColor: '#dddddd'
        } 
    },

};
pdfMake.createPdf(dd).download('factura_'+id+'.pdf'); // Descarga directa
};
