<?php
// Configuración CORS para desarrollo
$allowedOrigins = [
    "http://localhost:3000",
    "http://127.0.0.1:3000"
];

$origin = $_SERVER['HTTP_ORIGIN'] ?? '';

if (in_array($origin, $allowedOrigins)) {
    header("Access-Control-Allow-Origin: {$origin}");
} else {
    // Opcional: header("Access-Control-Allow-Origin: *");
    // Pero si usas credenciales, no puedes usar *
}

header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, token-user");
header("Access-Control-Max-Age: 3600");

// Solo UN Content-Type (ajusta según lo que devuelvas)
header('Content-Type: application/json'); // O application/pdf si es el caso

// Para solicitudes OPTIONS (preflight)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'vendor/autoload.php'; // Requerir Composer autoload

// Generar PDF con TCPDF (debes instalar TCPDF via Composer)
function generarPDF() {
    $pdf = new TCPDF();
    $pdf->AddPage();
    $pdf->SetFont('helvetica', 'B', 16);
    $pdf->Cell(0, 10, 'Ejemplo de PDF generado desde PHP', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 12);
    $pdf->Cell(0, 10, 'Fecha de generación: ' . date('Y-m-d H:i:s'), 0, 1);
    
    // Guardar en variable
    return $pdf->Output('documento.pdf', 'S');
}

// Manejar la solicitud
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdfContent = generarPDF();
        
        // Configurar headers para descarga
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="documento_generado.pdf"');
        header('Content-Length: ' . strlen($pdfContent));
        
        echo $pdfContent;
        exit;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}