import React, { useState } from 'react';
import axios from 'axios';
import useDownload from './useDownload';

const DescargaPDF = () => {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const download = useDownload();

  const handleDownload = async () => {
    setLoading(true);
    setError(null);
    
    try {
      const response = await axios.post('http://localhost/download_B/generar_pdf.php', {}, {
        responseType: 'blob',
      });
      download(response.data, 'documento_generado.pdf');
    } catch (err) {
      setError('Error al generar el PDF. Por favor, inténtalo de nuevo.');
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };

  return (
    <div style={{ padding: '20px', maxWidth: '600px', margin: '0 auto' }}>
      <h2>Generador de PDF</h2>
      <p>Haz clic en el botón para generar y descargar un PDF desde el servidor.</p>
      
      <button 
        onClick={handleDownload} 
        disabled={loading}
        style={{
          padding: '10px 15px',
          backgroundColor: '#4CAF50',
          color: 'white',
          border: 'none',
          borderRadius: '4px',
          cursor: 'pointer',
          fontSize: '16px'
        }}
      >
        {loading ? 'Generando...' : 'Generar y Descargar PDF'}
      </button>
      
      {error && <p style={{ color: 'red', marginTop: '10px' }}>{error}</p>}
    </div>
  );
};

export default DescargaPDF;