import React, { useState } from 'react';
import axios from 'axios';

// Configuration partition of URL of access to SERVER
const url = new URL(window.location.href);
// console.log("URL de ejecución:", url);
if ( url.hostname == "localhost") {
    var config_url = 'http://localhost/download_B/';
} else {
    var config_url = 'https://fhumanes.com/download_B/';
}



const DescargaPDF = () => {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  const generarYDescargarPDF = async () => {
    setLoading(true);
    setError(null);
    
    try {
      // Cambia esta URL por la de tu backend
      const response = await axios.post(config_url+'generar_pdf.php', {}, {
        responseType: 'blob', // Importante para manejar archivos binarios
      });

      // Crear un enlace temporal para descargar el PDF
      const url = window.URL.createObjectURL(new Blob([response.data]));
      console.log("Contenido de URL: ",url);
      console.log("Contenido de RESPONSE: ",response);
      console.log("contenido de DATA: ", response.data);
      const link = document.createElement('a');
      link.href = url;
      link.setAttribute('download', 'documento_generado.pdf');
      console.log("Contenido de LINK: ",link);
      document.body.appendChild(link);
      link.click();
      
      // Limpiar
      link.parentNode.removeChild(link);
      window.URL.revokeObjectURL(url);
    } catch (err) {
      setError('Error al generar el PDF. Por favor, inténtalo de nuevo.');
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };

  return (
    <div style={{ padding: '20px', maxWidth: '600px', margin: '0 auto' }}>
      <h2>Generador de PDF</h2>
      <p>Haz clic en el botón para generar y descargar un PDF desde el servidor.</p>
      
      <button 
        onClick={generarYDescargarPDF} 
        disabled={loading}
        style={{
          padding: '10px 15px',
          backgroundColor: '#4CAF50',
          color: 'white',
          border: 'none',
          borderRadius: '4px',
          cursor: 'pointer',
          fontSize: '16px'
        }}
      >
        {loading ? 'Generando...' : 'Generar y Descargar PDF'}
      </button>
      
      {error && <p style={{ color: 'red', marginTop: '10px' }}>{error}</p>}
    </div>
  );
};

export default DescargaPDF;