import React, { useState } from 'react';
import axios from 'axios';
import DownloadLink from 'react-download-link';

const DescargaPDF = () => {
  const [pdfData, setPdfData] = useState(null);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  const generarPDF = async () => {
    setLoading(true);
    setError(null);
    
    try {
      const response = await axios.post('http://localhost/download_B/generar_pdf.php', {}, {
        responseType: 'blob',
      });
      setPdfData(response.data);
      return response.data;
    } catch (err) {
      setError('Error al generar el PDF');
      console.error('Error:', err);
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return (
    <div style={{ padding: '20px', maxWidth: '600px', margin: '0 auto' }}>
      <h2>Generador de PDF</h2>
      <p>Haz clic en el botón para generar y descargar un PDF desde el servidor.</p>
      
      <DownloadLink
        label={loading ? "Generando PDF..." : "Descargar PDF"}
        filename="documento_generado.pdf"
        exportFile={() => pdfData || generarPDF()}
        style={{
          padding: '10px 15px',
          backgroundColor: '#4CAF50',
          color: 'white',
          border: 'none',
          borderRadius: '4px',
          cursor: 'pointer',
          fontSize: '16px',
          textDecoration: 'none',
          display: 'inline-block'
        }}
        disabled={loading}
      />
      
      {error && <p style={{ color: 'red', marginTop: '10px' }}>{error}</p>}
    </div>
  );
};

export default DescargaPDF;