import React from 'react';
import { useTranslation } from 'react-i18next';

// utils/language.js  //Para obtener el idiona actual
import i18n from '../i18n/config';

const UserDashboard = ({ user }) => {
  const { t, i18n } = useTranslation();
  
  const changeLanguage = (lng) => {
    i18n.changeLanguage(lng);
  };
  
  const lastLogin = new Date(user.lastLogin);
  const balance = 1250.5;
  const messageCount = 3;

  // Obtener el idioma actual de la aplicación
  const currentLanguage = i18n.language;
  console.log('El idioma actual es:', currentLanguage);
  const idiomas = Object.keys(i18n.services.resourceStore.data);
  console.log('Los idiomas son: ', idiomas);
  const languageReal = i18n.resolvedLanguage;
  console.log('El idioma real es: ', languageReal);


  
  return (
    <div className="dashboard">
      <h2>{t('dashboard.welcome', { name: user.name })}</h2>
      
      <p>{t('dashboard.messages', { count: messageCount })}</p>
      <p>{t('dashboard.lastLogin', { date: lastLogin })}</p>
      <p>{t('dashboard.balance', { value: balance })}</p>
      
      <div className="notifications">
        <h3>{t('dashboard.notifications.title')}</h3>
        <p>{t('dashboard.notifications.empty')}</p>
      </div>
      
      <div className="language-selector">
        <button onClick={() => changeLanguage('en')}>English</button>
        <button onClick={() => changeLanguage('es')}>Español</button>
      </div>
      
      <button>{t('buttons.logout')}</button>
    </div>
  );
};

export default UserDashboard;