import React from 'react';
import './i18n/config';
import { useTranslation } from 'react-i18next';
import Header from './components/Header';
import UserDashboard from './components/UserDashboard';

const App = () => {
  const { t } = useTranslation();
  
  const user = {
    name: 'Carlos',
    lastLogin: new Date('2023-05-15')
  };
  
  return (
    <div className="app">
      <Header />
      <main>
        <UserDashboard user={user} />
        
        {/* Ejemplo de validación */}
        <div className="form-error">
          <p>{t('errors.required')}</p>
          <p>{t('errors.email')}</p>
        </div>
      </main>
    </div>
  );
};

export default App;