
//  Importa todos los componentes estáticamente 
import Counter from '../ejercicios/01-basico/Counter.svelte';
import NestedComponents from '../ejercicios/01-basico/nested-components/index.svelte';
import HTMLTags from '../ejercicios/01-basico/html-tags.svelte';
import DerivedState from '../ejercicios/01-basico/derived-state.svelte';
import InspectingState from '../ejercicios/01-basico/Inspecting-state.svelte';
import Effects from '../ejercicios/01-basico/Effects.svelte';
import TheStyleDirective from '../ejercicios/01-basico/the-style-directive/index.svelte';
import DeclaringProps from '..//ejercicios/01-basico/Declaring-props/index.svelte';
import EachBlocks from '../ejercicios/01-basico/EachBlocks.svelte';
import KeyedEachBlocks from '../ejercicios/01-basico/KeyedEachBlocks/index.svelte';
import AwaitBlocks from '../ejercicios/01-basico/AwaitBlocks/index.svelte';
import InlineHandlers from '../ejercicios/01-basico/InlineHandlers.svelte';
import EventsCapturing from '../ejercicios/01-basico/EventsCapturing.svelte';
import DataTableSpecial from '../ejercicios/03-especial/DataTableSpecial.svelte';
import VideosBootstrapChatGPT from '../ejercicios/03-especial/VideosBootstrapChatGPT/index.svelte';
import VideosBootstrapDeepSeek from '../ejercicios/03-especial/VideosBootstrapDeepSeek/index.svelte';
//  Añade más imports aquí para cada componente 

// Mapeo de componentes por ID
const components = {
  'Counter': Counter,
  'NestedComponents': NestedComponents,
  'HTMLTags': HTMLTags,
  'DerivedState': DerivedState,
  'InspectingState': InspectingState,
  'Effects': Effects,
  'TheStyleDirective': TheStyleDirective,
  'DeclaringProps': DeclaringProps,
  'EachBlocks': EachBlocks,
  'KeyedEachBlocks': KeyedEachBlocks,
  'AwaitBlocks': AwaitBlocks,
  'InlineHandlers': InlineHandlers,
  'EventsCapturing':  EventsCapturing,
  // Agregar más componentes aquí

  'DataTableSpecial': DataTableSpecial,
  "VideosBootstrapChatGPT": VideosBootstrapChatGPT,
  'VideosBootstrapDeepSeek': VideosBootstrapDeepSeek
};

export async function loadExercise(exerciseId,exerciseFileTxt ) {
  const component = components[exerciseId];
  
  if (!component) {
    return {
      component: null,
      code: `// Error: Componente ${exerciseId} no encontrado`
    };
  }

  try {
    // Cargar código fuente (ruta relativa al base URL)
    const base = import.meta.env.BASE_URL || '/';
    const response = await fetch(`${base}src/ejercicios-copia/${exerciseFileTxt}`);
    const code = await response.text();
    
    return { component, code };
  } catch (error) {
    return {
      component,
      code: `// Error cargando código: ${error.message}`
    };
  }
}
