import Prism from 'prismjs';
import 'prismjs/themes/prism-okaidia.css';

// Mejorar JavaScript
Prism.languages.javascript = Prism.languages.extend('clike', {
  'keyword': /\b(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|export|extends|finally|for|from|function|get|if|import|in|instanceof|let|new|of|return|set|static|super|switch|this|throw|try|typeof|var|void|while|with|yield)\b/,
  'number': /\b(?:0[xX][\dA-Fa-f]+|0[bB][01]+|0[oO][0-7]+|\d*\.?\d+(?:[Ee][+-]?\d+)?)\b/,
  'operator': /[+-]|\*=?|\/=?|%=?|\^=?|[!=]==?|<<=?|>>=?|&=?|\|=?|\?\?=?|\?\.?|~|:/
});

// Gramática manual completa para Svelte (HTML + JS)
Prism.languages.svelte = {

  'comment': /<!--[\s\S]*?-->/,
  'tag': {
    pattern: /<\/?[^\s>\/]+(?:\s+[^\s>\/=]+(?:=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">=]+))?)*\s*\/?>/,
    inside: {
      'tag': /^<\/?[^\s>\/]+/,
      'attr-value': {
        pattern: /=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">=]+)/,
        inside: {
          'punctuation': /^=|["']/
        }
      },
      'punctuation': /^<\/?|\/?>|=/,
      'attr-name': /[^\s>\/]+/
    }
  },
  'script': {
    pattern: /<script[\s\S]*?>[\s\S]*?<\/script>/i,
    inside: {
      'rest': {
        pattern: /[\s\S]+/,
        alias: 'language-javascript',
        inside: Prism.languages.javascript || {}
      }
    }
  },
  'mustache': {
    pattern: /\{[^}]+\}/,
    inside: {
      'expression': {
        pattern: /[\s\S]+/,
        inside: Prism.languages.javascript || {}
      }
    }
  },

  'keyword': /\b(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|export|extends|finally|for|from|function|get|if|import|in|instanceof|let|new|of|return|set|static|super|switch|this|throw|try|typeof|var|void|while|with|yield)\b/,
  'number': /\b(?:0[xX][\dA-Fa-f]+|0[bB][01]+|0[oO][0-7]+|\d*\.?\d+(?:[Ee][+-]?\d+)?)\b/,
  'operator': /[+-]|\*=?|\/=?|%=?|\^=?|[!=]==?|<<=?|>>=?|&=?|\|=?|\?\?=?|\?\.?|~|:/,

};

// Función de resaltado
export const highlightAll = () => {
  if (typeof Prism !== 'undefined') {
    Prism.highlightAll();
  }
};