import { defineConfig } from 'vite';
import { svelte } from '@sveltejs/vite-plugin-svelte';

// Para excluir un directorio completo
// const filesToExclude = ['/src/ejercicios-copia/**'];

export default defineConfig({
  plugins: [svelte({
      // Puedes usar `exclude` para ignorar archivos de la compilación
      // Usa un patrón de glob para que sea más flexible
      // exclude: filesToExclude,
      // Opcionalmente, puedes usar `include` para ser más explícito
      // sobre qué archivos se deben compilar
      // include: ['src/**/*.svelte', '!src/ruta/al/archivo/a/excluir.svelte']
    })],
  base: '/my-svelte-demo/',
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
    assetsInlineLimit: 0 // Asegura que los assets no se conviertan en base64
  }
});