<?php
// public/index.php

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Server\RequestHandlerInterface as RequestHandler;
use Slim\Factory\AppFactory;
use DI\Container;
use Slim\Routing\RouteCollectorProxy;
use Slim\Middleware\BodyParsingMiddleware; // <-- ¡AÑADIR ESTA LÍNEA!

require __DIR__ . '/../vendor/autoload.php';

// --- Configuración de la base de datos ---
$host_con_puerto = $_SERVER['HTTP_HOST'];
$hostName = '';
$parts = $parts = explode(':', $host_con_puerto);
$hostName = $parts[0];

if ($hostName == 'localhost') {
    $dbSettings = [
        'host' => 'localhost',
        'dbname' => 'svelte-app1',
        'user' => 'root',
        'pass' => 'humanes'
    ];
    } else {
     $dbSettings = [
        'host' => 'localhost',
        'dbname' => 'linux-svelte-app1',
        'user' => 'root',
        'pass' => 'humanes'
    ];
 }

// --- Configuración de CORS ---
$corsSettings = [
    'allow_origins' => ['http://localhost:5173','https://fhumanes.com'],
    'allow_headers' => ['Content-Type', 'Authorization', 'Accept', 'Origin'],
    'allow_methods' => ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
    'allow_credentials' => true,
    'expose_headers' => [],
    'max_age' => 86400
];

// --- 1. Configuración del Contenedor de Dependencias (PHP-DI) ---
$container = new Container();

$container->set('dbSettings', function () use ($dbSettings) {
    return $dbSettings;
});

$container->set('db', function (Container $c) {
    $settings = $c->get('dbSettings');
    $dsn = "mysql:host={$settings['host']};dbname={$settings['dbname']};charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];
    try {
        $pdo = new PDO($dsn, $settings['user'], $settings['pass'], $options);
        return $pdo;
    } catch (PDOException $e) {
        throw new PDOException($e->getMessage(), (int)$e->getCode());
    }
});

$container->set('MovieController', function (Container $c) {
    return new App\MovieController($c->get('db'));
});

// --- 2. Crear la aplicación Slim ---
AppFactory::setContainer($container);
$app = AppFactory::create();

// --- Configurar el Base Path para subdirectorios ---
$scriptName = $_SERVER['SCRIPT_NAME'];
$basePath = dirname($scriptName);
$app->setBasePath($basePath);

// --- Middleware de CORS (Debe ir antes del BodyParsingMiddleware y del enrutamiento) ---
$app->options('/{routes:.+}', function (Request $request, Response $response) {
    return $response;
});

$app->add(function (Request $request, RequestHandler $next) use ($corsSettings): Response {
    $response = $next->handle($request);

    $origin = $request->getHeaderLine('Origin');
    if (in_array($origin, $corsSettings['allow_origins'])) {
        $response = $response
            ->withHeader('Access-Control-Allow-Origin', $origin)
            ->withHeader('Access-Control-Allow-Headers', implode(', ', $corsSettings['allow_headers']))
            ->withHeader('Access-Control-Allow-Methods', implode(', ', $corsSettings['allow_methods']))
            ->withHeader('Access-Control-Allow-Credentials', 'true')
            ->withHeader('Access-Control-Max-Age', (string)$corsSettings['max_age']);
    }

    if ($request->getMethod() === 'OPTIONS') {
        return $response->withStatus(200);
    }

    return $response;
});

// --- ¡AÑADIR ESTE MIDDLEWARE! ---
// Debe ir después de CORS y antes del addRoutingMiddleware
$app->addBodyParsingMiddleware(); // <-- ¡LÍNEA CLAVE AÑADIDA!

// --- Middleware de enrutamiento ---
$app->addRoutingMiddleware();

// --- Middleware de errores (Siempre al final) ---
$errorMiddleware = $app->addErrorMiddleware(true, true, true);
$errorMiddleware->setDefaultErrorHandler(function (
    Request $request,
    Throwable $exception,
    bool $displayErrorDetails,
    bool $logErrors,
    bool $logErrorDetails
) use ($app) {
    $statusCode = 500;
    if ($exception instanceof \Slim\Exception\HttpNotFoundException) {
        $statusCode = 404;
    } elseif ($exception instanceof \Slim\Exception\HttpMethodNotAllowedException) {
         $statusCode = 405;
    }

    $payload = [
        'error' => $exception->getMessage(),
        //'file' => $exception->getFile(), // Descomentar para depuración si es necesario
        //'line' => $exception->getLine()  // Descomentar para depuración si es necesario
    ];

    $response = $app->getResponseFactory()->createResponse();
    $response->getBody()->write(
        json_encode($payload, JSON_UNESCAPED_UNICODE)
    );
    return $response->withHeader('Content-Type', 'application/json')->withStatus($statusCode);
});


// --- Rutas de la API ---

// Grupo de Rutas para Películas
$app->group('/movies', function (RouteCollectorProxy $group) {
    $group->get('', 'MovieController:getAllMovies');
    $group->get('/{id}', 'MovieController:getMovieById');
    $group->post('', 'MovieController:createMovie');
    $group->put('/{id}', 'MovieController:updateMovie');
    $group->delete('/{id}', 'MovieController:deleteMovie');
});

// Grupo de Rutas para Temas
$app->group('/themes', function (RouteCollectorProxy $group) {
    // Ya tienes este:
    $group->get('', function (Request $request, Response $response, $args) {
        $db = $this->get('db');
        $stmt = $db->query("SELECT id_theme, theme FROM theme");
        $themes = $stmt->fetchAll();
        $response->getBody()->write(json_encode($themes, JSON_UNESCAPED_UNICODE));
        return $response->withHeader('Content-Type', 'application/json');
    });

    // --- ¡AÑADIR ESTAS RUTAS! ---
    $group->post('', 'MovieController:createTheme');
    $group->put('/{id}', 'MovieController:updateTheme');
    $group->delete('/{id}', 'MovieController:deleteTheme');
});

// Grupo de Rutas para Soportes
$app->group('/supports', function (RouteCollectorProxy $group) {
    // Ya tienes este:
    $group->get('', function (Request $request, Response $response, $args) {
        $db = $this->get('db');
        $stmt = $db->query("SELECT id_support, support FROM support");
        $supports = $stmt->fetchAll();
        $response->getBody()->write(json_encode($supports, JSON_UNESCAPED_UNICODE));
        return $response->withHeader('Content-Type', 'application/json');
    });

    // --- ¡AÑADIR ESTAS RUTAS! ---
    $group->post('', 'MovieController:createSupport');
    $group->put('/{id}', 'MovieController:updateSupport');
    $group->delete('/{id}', 'MovieController:deleteSupport');
});

// --- Ejecutar la aplicación ---
$app->run();