<?php declare(strict_types=1);
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PHPUnit\Runner\DeprecationCollector;

use PHPUnit\Event\Facade as EventFacade;
use PHPUnit\TestRunner\IssueFilter;
use PHPUnit\TextUI\Configuration\Registry as ConfigurationRegistry;

/**
 * @no-named-arguments Parameter names are not covered by the backward compatibility promise for PHPUnit
 *
 * @internal This class is not covered by the backward compatibility promise for PHPUnit
 */
final class Facade
{
    private static ?Collector $collector = null;

    public static function init(): void
    {
        self::collector();
    }

    /**
     * @return list<non-empty-string>
     */
    public static function deprecations(): array
    {
        return self::collector()->deprecations();
    }

    /**
     * @return list<non-empty-string>
     */
    public static function filteredDeprecations(): array
    {
        return self::collector()->filteredDeprecations();
    }

    private static function collector(): Collector
    {
        if (self::$collector === null) {
            self::$collector = new Collector(
                EventFacade::instance(),
                new IssueFilter(
                    ConfigurationRegistry::get()->source(),
                ),
            );
        }

        return self::$collector;
    }
}
