export function getData() {
	const allData = [
		{
			id: 1,
			city: "Amieshire",
			email: "Leora13@yahoo.com",
			firstName: "Ernest",
			lastName: "Schuppe",
			street: "Ratke Port",
			zipCode: "17026-3154",
			date: new Date("2016-09-23T07:57:40.195Z"),
			companyName: "Lebsack - Nicolas",
			stars: 820,
			followers: 70,
			checked: 1,
		},
		{
			id: 2,
			city: "Gust",
			email: "Mose_Gerhold51@yahoo.com",
			firstName: "Janis",
			lastName: "Vandervort",
			street: "Dickinson Keys",
			zipCode: "43767",
			date: new Date("2017-03-06T09:59:12.551Z"),
			companyName: "Glover - Hermiston",
			stars: 1200,
			followers: 170,
			checked: 1,
		},
		{
			id: 3,
			city: "Amieshire",
			email: "Frieda.Sauer61@gmail.com",
			firstName: "Makenzie",
			lastName: "Bode",
			street: "Legros Divide",
			zipCode: "54812",
			date: new Date("2016-12-08T13:44:26.557Z"),
			companyName: "Williamson - Kassulke",
			stars: 610,
			followers: 170,
			checked: 1,
		},
		{
			id: 4,
			city: "Amieshire",
			email: "Eloisa.OHara@hotmail.com",
			firstName: "Ciara",
			lastName: "Towne",
			street: "Schimmel Ramp",
			zipCode: "76315-2246",
			date: new Date("2016-07-19T12:54:30.994Z"),
			companyName: "Hilpert, Eichmann and Brown",
			stars: 5322,
			followers: 170,
			checked: 1,
		},
		{
			id: 5,
			city: "Amieshire",
			email: "Brisa46@hotmail.com",
			firstName: "Suzanne",
			lastName: "Wolff",
			street: "Lemuel Radial",
			zipCode: "88870-3897",
			date: new Date("2017-02-23T17:11:53.875Z"),
			companyName: "Mayer - Considine",
			stars: 852,
			followers: 770,
			checked: 1,
		},
		{
			id: 6,
			city: "Amieshire",
			email: "Cody.Schultz56@gmail.com",
			firstName: "Alessandra",
			lastName: "Feeney",
			street: "Mosciski Estate",
			zipCode: "81514",
			date: new Date("2016-06-30T05:23:18.734Z"),
			companyName: "Nikolaus and Sons",
			stars: 3209,
			followers: 2780,
		},
		{
			id: 7,
			city: "Dejuan",
			email: "Enrico_Beer@yahoo.com",
			firstName: "Margret",
			lastName: "Heller",
			street: "Gunner Drive",
			zipCode: "17423-9317",
			date: new Date("2017-03-13T21:09:47.253Z"),
			companyName: "Corwin, Maggio and Wintheiser",
			stars: 9920,
			followers: 570,
		},
		{
			id: 8,
			city: "Schumm",
			email: "Mitchel.Herman@yahoo.com",
			firstName: "Emiliano",
			lastName: "Moore",
			street: "Maria Junctions",
			zipCode: "33930-7081",
			date: new Date("2016-03-27T07:26:57.345Z"),
			companyName: "Gulgowski - Botsford",
			stars: 3820,
			followers: 880,
		},
		{
			id: 9,
			city: "Gihaven",
			email: "Gaylord_Reichel16@yahoo.com",
			firstName: "Alessandra",
			lastName: "Smith",
			street: "Kali Spurs",
			zipCode: "01370",
			date: new Date("2017-01-24T22:11:53.835Z"),
			companyName: "Maggio LLC",
			stars: 330,
			followers: 590,
		},
		{
			id: 10,
			city: "Fechester",
			email: "Eileen48@gmail.com",
			firstName: "Eldridge",
			lastName: "Bins",
			street: "Casper Squares",
			zipCode: "80025-1552",
			date: new Date("2016-07-20T05:59:45.630Z"),
			companyName: "Leffler, Cummerata and Price",
			stars: 923,
			followers: 704,
		},
		{
			id: 11,
			city: "Caleven",
			email: "Rico_Nolan@hotmail.com",
			firstName: "Claude",
			lastName: "Hermiston",
			street: "Bode Pine",
			zipCode: "76773",
			date: new Date("2017-03-13T08:02:41.211Z"),
			companyName: "Heller, Rosenbaum and Lockman",
			stars: 421,
			followers: 403,
		},
		{
			id: 12,
			city: "Herzogmouth",
			email: "Dawn_Metz@yahoo.com",
			firstName: "Clarabelle",
			lastName: "Ankunding",
			street: "Nolan Summit",
			zipCode: "04355",
			date: new Date("2016-07-09T09:07:34.744Z"),
			companyName: "Mante, Oberbrunner and Collins",
			stars: 8203,
			followers: 704,
		},
		{
			id: 13,
			city: "Eulaliabury",
			email: "Ron.Franecki@gmail.com",
			firstName: "Hubert",
			lastName: "Boehm",
			street: "Anastacio Springs",
			zipCode: "91444",
			date: new Date("2016-04-22T16:37:24.331Z"),
			companyName: "Greenholt, Homenick and Considine",
			stars: 8209,
			followers: 909,
		},
		{
			id: 14,
			city: "",
			email: "Hayley52@yahoo.com",
			firstName: "Vladimir",
			lastName: "Breitenberg",
			street: "Lula Port",
			zipCode: "04635",
			date: new Date("2016-09-26T01:25:23.057Z"),
			companyName: "Kshlerin - Pfeffer",
			stars: 8251,
			followers: 178,
		},
		{
			id: 15,
			city: "Eulaliabury",
			email: "Duane.Rempel@hotmail.com",
			firstName: "Haylee",
			lastName: "Purdy",
			street: "Dena Walk",
			zipCode: "94111-0802",
			date: new Date("2016-11-26T16:36:38.472Z"),
			companyName: "Lemke, Mitchell and Harber",
			stars: 3099,
			followers: 707,
		},
		{
			id: 16,
			city: "Eulaliabury",
			email: "Eddie_Bartell@hotmail.com",
			firstName: "Herminia",
			lastName: "Altenwerth",
			street: "Kshlerin Cape",
			zipCode: "86614-9727",
			date: new Date("2016-09-28T19:50:18.308Z"),
			companyName: "Gislason - Nicolas",
			stars: 8491,
			followers: 463,
		},
		{
			id: 17,
			city: "Eulaliabury",
			email: "Josephine_Legros@yahoo.com",
			firstName: "Erick",
			lastName: "Klein",
			street: "Megane Cliffs",
			zipCode: "42168",
			date: new Date("2016-04-02T05:03:42.377Z"),
			companyName: "Olson and Sons",
			stars: 9820,
			followers: 670,
		},
		{
			id: 18,
			city: "West Meda",
			email: "Jared.Hudson@hotmail.com",
			firstName: "Lisandro",
			lastName: "Barton",
			street: "Torrance Union",
			zipCode: "19477",
			date: new Date("2016-08-01T14:24:45.209Z"),
			companyName: "Volkman and Sons",
			stars: 1220,
			followers: 708,
		},
		{
			id: 19,
			city: "Darrenport",
			email: "Delpha.Tromp9@yahoo.com",
			firstName: "Ashton",
			lastName: "Daugherty",
			street: "Hermann Port",
			zipCode: "25133-9181",
			date: new Date("2016-07-29T09:49:39.424Z"),
			companyName: "Grady LLC",
			stars: 420,
			followers: 30,
		},
		{
			id: 20,
			city: "Janiyahaven",
			email: "Ariel.Maggio9@yahoo.com",
			firstName: "Cassandra",
			lastName: "Schmitt",
			street: "Windler Lodge",
			zipCode: "87582-2944",
			date: new Date("2017-01-21T12:35:27.741Z"),
			companyName: "Ankunding Group",
			stars: 20,
			followers: 188,
		},
	];

	const treeData = [
		{
			id: 1,
			city: "Amieshire",
			country: 6,
			email: "Leora13@yahoo.com",
			firstName: "Ernest",
			lastName: "Schuppe",
			street: "Ratke Port",
			zipCode: "17026-3154",
			date: new Date("2016-09-23T07:57:40.195Z"),
			companyName: "Lebsack - Nicolas",
			stars: 820,
			followers: 70,
			newsletter: true,
			checked: 1,
			open: true,
			data: [
				{
					id: "1.1",
					city: "Gust",
					country: 4,
					email: "Mose_Gerhold51@yahoo.com",
					firstName: "Janis",
					lastName: "Vandervort",
					street: "Dickinson Keys",
					zipCode: "43767",
					date: new Date("2017-03-06T09:59:12.551Z"),
					companyName: "Glover - Hermiston",
					stars: 1200,
					followers: 170,
					checked: 1,
				},
				{
					id: "1.2",
					city: "Amieshire",
					country: 3,
					email: "Frieda.Sauer61@gmail.com",
					firstName: "Makenzie",
					lastName: "Bode",
					street: "Legros Divide",
					zipCode: "54812",
					date: new Date("2016-12-08T13:44:26.557Z"),
					companyName: "Williamson - Kassulke",
					stars: 610,
					followers: 170,
					checked: 1,
				},
			],
		},
		{
			id: 2,
			city: "Amieshire",
			country: 2,
			email: "Eloisa.OHara@hotmail.com",
			firstName: "Ciara",
			lastName: "Towne",
			street: "Schimmel Ramp",
			zipCode: "76315-2246",
			date: new Date("2016-07-19T12:54:30.994Z"),
			companyName: "Hilpert, Eichmann and Brown",
			stars: 5322,
			followers: 170,
			checked: 1,
			open: true,
			data: [
				{
					id: "2.1",
					city: "Amieshire",
					country: 2,
					email: "Brisa46@hotmail.com",
					firstName: "Suzanne",
					lastName: "Wolff",
					street: "Lemuel Radial",
					zipCode: "88870-3897",
					date: new Date("2017-02-23T17:11:53.875Z"),
					companyName: "Mayer - Considine",
					stars: 852,
					followers: 770,
					newsletter: true,
					checked: 1,
				},
				{
					id: "2.2",
					city: "Amieshire",
					country: 2,
					email: "Cody.Schultz56@gmail.com",
					firstName: "Alessandra",
					lastName: "Feeney",
					street: "Mosciski Estate",
					zipCode: "81514",
					date: new Date("2016-06-30T05:23:18.734Z"),
					companyName: "Nikolaus and Sons",
					stars: 3209,
					followers: 2780,
				},
				{
					id: "2.3",
					city: "Dejuan",
					country: 2,
					email: "Enrico_Beer@yahoo.com",
					firstName: "Margret",
					lastName: "Heller",
					street: "Gunner Drive",
					zipCode: "17423-9317",
					date: new Date("2017-03-13T21:09:47.253Z"),
					companyName: "Corwin, Maggio and Wintheiser",
					stars: 9920,
					newsletter: true,
					followers: 570,
				},
			],
		},
		{
			id: 3,
			city: "Schumm",
			country: 2,
			email: "Mitchel.Herman@yahoo.com",
			firstName: "Emiliano",
			lastName: "Moore",
			street: "Maria Junctions",
			zipCode: "33930-7081",
			date: new Date("2016-03-27T07:26:57.345Z"),
			companyName: "Gulgowski - Botsford",
			stars: 3820,
			followers: 880,
			open: true,
			data: [
				{
					id: "3.1",
					city: "Gihaven",
					country: 2,
					email: "Gaylord_Reichel16@yahoo.com",
					firstName: "Alessandra",
					lastName: "Smith",
					street: "Kali Spurs",
					zipCode: "01370",
					date: new Date("2017-01-24T22:11:53.835Z"),
					companyName: "Maggio LLC",
					stars: 330,
					followers: 590,
				},
				{
					id: "3.2",
					city: "Fechester",
					country: 2,
					email: "Eileen48@gmail.com",
					firstName: "Eldridge",
					lastName: "Bins",
					street: "Casper Squares",
					zipCode: "80025-1552",
					date: new Date("2016-07-20T05:59:45.630Z"),
					companyName: "Leffler, Cummerata and Price",
					stars: 923,
					followers: 704,
				},
				{
					id: "3.3",
					city: "Caleven",
					country: 6,
					email: "Rico_Nolan@hotmail.com",
					firstName: "Claude",
					lastName: "Hermiston",
					street: "Bode Pine",
					zipCode: "76773",
					date: new Date("2017-03-13T08:02:41.211Z"),
					companyName: "Heller, Rosenbaum and Lockman",
					stars: 421,
					followers: 403,
					checked: true,
					newsletter: true,
					assigned: [2],
				},
				{
					id: "3.4",
					city: "Herzogmouth",
					country: 2,
					email: "Dawn_Metz@yahoo.com",
					firstName: "Clarabelle",
					lastName: "Ankunding",
					street: "Nolan Summit",
					zipCode: "04355",
					date: new Date("2016-07-09T09:07:34.744Z"),
					companyName: "Mante, Oberbrunner and Collins",
					stars: 8203,
					followers: 704,
					checked: true,
					newsletter: true,
				},
			],
		},
		{
			id: 4,
			city: "Eulaliabury",
			country: 4,
			email: "Ron.Franecki@gmail.com",
			firstName: "Hubert",
			lastName: "Boehm",
			street: "Anastacio Springs",
			zipCode: "91444",
			date: new Date("2016-04-22T16:37:24.331Z"),
			companyName: "Greenholt, Homenick and Considine",
			stars: 8209,
			followers: 909,
			open: true,
			data: [
				{
					id: "4.1",
					city: "",
					country: 2,
					email: "Hayley52@yahoo.com",
					firstName: "Vladimir",
					lastName: "Breitenberg",
					street: "Lula Port",
					zipCode: "04635",
					date: new Date("2016-09-26T01:25:23.057Z"),
					companyName: "Kshlerin - Pfeffer",
					stars: 8251,
					followers: 178,
				},
				{
					id: "4.2",
					city: "Eulaliabury",
					country: 2,
					email: "Duane.Rempel@hotmail.com",
					firstName: "Haylee",
					lastName: "Purdy",
					street: "Dena Walk",
					zipCode: "94111-0802",
					date: new Date("2016-11-26T16:36:38.472Z"),
					companyName: "Lemke, Mitchell and Harber",
					stars: 3099,
					followers: 707,
					open: true,
					data: [
						{
							id: "4.2.1",
							city: "Eulaliabury",
							country: 2,
							email: "Eddie_Bartell@hotmail.com",
							firstName: "Herminia",
							lastName: "Altenwerth",
							street: "Kshlerin Cape",
							zipCode: "86614-9727",
							date: new Date("2016-09-28T19:50:18.308Z"),
							companyName: "Gislason - Nicolas",
							stars: 8491,
							followers: 463,
						},
						{
							id: "4.2.2",
							city: "Eulaliabury",
							country: 2,
							email: "Josephine_Legros@yahoo.com",
							firstName: "Erick",
							lastName: "Klein",
							street: "Megane Cliffs",
							zipCode: "42168",
							date: new Date("2016-04-02T05:03:42.377Z"),
							companyName: "Olson and Sons",
							stars: 9820,
							followers: 670,
							open: true,
							data: [
								{
									id: "4.2.2.1",
									city: "West Meda",
									country: 2,
									email: "Jared.Hudson@hotmail.com",
									firstName: "Lisandro",
									lastName: "Barton",
									street: "Torrance Union",
									zipCode: "19477",
									date: new Date("2016-08-01T14:24:45.209Z"),
									companyName: "Volkman and Sons",
									stars: 1220,
									followers: 708,
									open: true,
									data: [
										{
											id: "4.2.2.1.1",
											city: "Darrenport",
											country: 2,
											email: "Delpha.Tromp9@yahoo.com",
											firstName: "Ashton",
											lastName: "Daugherty",
											street: "Hermann Port",
											zipCode: "25133-9181",
											date: new Date(
												"2016-07-29T09:49:39.424Z"
											),
											companyName: "Grady LLC",
											stars: 420,
											followers: 30,
										},
									],
								},
							],
						},
					],
				},
				{
					id: "4.3",
					city: "Janiyahaven",
					country: 2,
					email: "Ariel.Maggio9@yahoo.com",
					firstName: "Cassandra",
					lastName: "Schmitt",
					street: "Windler Lodge",
					zipCode: "87582-2944",
					date: new Date("2017-01-21T12:35:27.741Z"),
					companyName: "Ankunding Group",
					stars: 20,
					followers: 188,
				},
			],
		},
	];

	const treeColumns = [
		{ id: "id", width: 80 },
		{
			id: "lastName",
			header: "Last Name",
			footer: "Last Name",
			flexgrow: 1,
			treetoggle: true,
		},
		{
			id: "firstName",
			header: "First Name",
			footer: "First Name",
			width: 150,
		},
		{
			id: "city",
			width: 100,
			header: "City",
			footer: "City",
		},
	];

	const allColumns = [
		{ id: "id", width: 50 },
		{
			id: "city",
			width: 100,
			header: "City",
			footer: "City",
		},
		{
			id: "firstName",
			header: "First Name",
			footer: "First Name",
			width: 150,
		},
		{
			id: "lastName",
			header: "Last Name",
			footer: "Last Name",
			width: 150,
		},
		{ id: "email", header: "Email", footer: "Email" },
		{ id: "companyName", header: "Company", footer: "Company" },
		{ id: "stars" },
		{ id: "date" },
	];

	const columns = allColumns.slice(0, 5);
	const data = allData.slice(10);

	const collapsibleColumns = mode => {
		if (typeof mode !== "string") mode = true;

		return [
			{ id: "id", width: 50, footer: { text: "All users", colspan: 7 } },
			{
				id: "firstName",
				header: [
					{
						text: "Main client info",
						colspan: 5,
						collapsible: mode,
						open: true,
					},
					{ text: "User", colspan: 2, collapsible: mode },
					{ text: "First Name" },
				],
				width: 150,
			},
			{
				id: "lastName",
				header: ["", "", "Last Name"],
				width: 150,
			},
			{
				collapsible: mode,
				id: "email",
				header: ["", { text: "Email", rowspan: 2, css: "center" }],
			},
			{
				id: "companyName",
				header: [
					"",
					{
						text: "Company",
						colspan: 2,
						collapsible: mode,
						collapsed: true,
					},
					{ text: "Name" },
				],
			},
			{
				id: "city",
				width: 100,
				header: ["", "", "City"],
			},
			{ id: "stars", header: "Stars", width: 80 },
			{
				id: "date",
				template: obj => obj.toDateString(),
				header: "Joined",
				footer: { text: data.length, css: "right" },
			},
		];
	};

	const columnsVertical = allColumns.slice(0, 6).map(col => ({
		...col,
		editor: "text",
		header: { text: col.header, vertical: true },
		footer: { text: col.footer, vertical: true },
	}));

	const columnsSpansVertical = [
		{ id: "id", width: 50, footer: { text: "All users", colspan: 7 } },
		{
			id: "firstName",
			header: [
				{ text: "Main client info", colspan: 5 },
				{ text: "User", colspan: 2 },
				{ text: "First Name", vertical: true },
			],
			width: 150,
			editor: "text",
		},
		{
			id: "lastName",
			header: ["", "", { text: "Last Name", vertical: true }],
			width: 150,
			editor: "text",
		},
		{
			id: "email",
			header: ["", { text: "Email", rowspan: 2 }],
			editor: "text",
		},
		{
			id: "companyName",
			header: ["", { text: "Company", colspan: 2 }, { text: "Name" }],
			editor: "text",
		},
		{
			id: "city",
			width: 100,
			header: ["", "", "City"],
			editor: "text",
		},
		{
			id: "stars",
			header: { text: "Stars with long text", vertical: true },
			width: 50,
			editor: "text",
		},
		{
			id: "date",
			template: obj => obj.toDateString(),
			header: "Joined",
			footer: { text: data.length, css: "right" },
			editor: "text",
		},
	];

	return {
		data,
		allData,
		columns,
		allColumns,
		treeData,
		treeColumns,
		collapsibleColumns,
		columnsVertical,
		columnsSpansVertical,
	};
}

export function repeatData(n) {
	var out = [];
	while (out.length < n) out = out.concat(getData().allData);

	out = out.map((x, i) => ({ ...x, id: i + 1 }));
	return out.slice(0, n);
}

export function repeatColumns(n) {
	var out = [];
	while (out.length < n) out = out.concat(getData().allColumns);

	out[0].width = 100;
	return out.slice(0, n);
}
