import { writable } from 'svelte/store';

// Leer desde localStorage al iniciar
const stored = localStorage.getItem('auth');
const initial = stored
  ? JSON.parse(stored)
  : { isAuthenticated: false, user: null }; // guardamos todos los datos en un solo objeto en formato JSON
                                            // Lo guardamos en "localStorage" porque está en el navegador y no se pierde al recargar la página
export const auth = writable(initial);

// Suscribirse para guardar cambios automáticamente
auth.subscribe(value => {
  localStorage.setItem('auth', JSON.stringify(value));
});

// Función para iniciar sesión
export function login(username, password) {
  const users = [
    { username: 'fernando', password: '1234' },
    { username: 'admin', password: 'admin' }
  ];

  const user = users.find(u => u.username === username && u.password === password);
  if (user) {
    auth.set({ isAuthenticated: true, user: user.username });
    return true;
  }
  return false;
}

// Función para cerrar sesión
export function logout() {
  auth.set({ isAuthenticated: false, user: null });
}
