// Type definitions for AnyChart JavaScript Charting Library, v8.6.0
// Project: https://www.anychart.com/
// Definitions by: AnyChart <https://www.anychart.com>
declare namespace anychart {
    const DEFAULT_THEME: string;
    const DEVELOP: boolean;
    const PERFORMANCE_MONITORING: boolean;
    const VERSION: string;
    function appendTheme(value: string | Object): void;
    function area(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function area3d(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian3d;
    function bar(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function bar3d(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian3d;
    function barmekko(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Mekko;
    function box(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function bubble(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Scatter;
    function bubbleMap(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Map;
    function bullet(data?: anychart.data.View | anychart.data.Set | Array<any> | string): anychart.charts.Bullet;
    function candlestick(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function cartesian(): anychart.charts.Cartesian;
    function cartesian3d(): anychart.charts.Cartesian3d;
    function choropleth(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Map;
    function circularGauge(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.CircularGauge;
    function column(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function column3d(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian3d;
    function connector(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Map;
    function editor(): anychart.editor.Editor;
    function financial(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function fromJson(jsonConfig: Object | string): any;
    function fromJsonFile(url: string, onSuccessOrContainer?: string | (() => void), onError?: (() => void), method?: string, content?: ArrayBuffer | ArrayBufferView | Blob | Document | FormData | string, headers?: Object, timeoutInterval?: number, withCredentials?: boolean, context?: any): void;
    function fromXml(xmlConfig: string | Node): any;
    function fromXmlFile(url: string, onSuccessOrContainer?: string | (() => void), onError?: (() => void), method?: string, content?: ArrayBuffer | ArrayBufferView | Blob | Document | FormData | string, headers?: Object, timeoutInterval?: number, withCredentials?: boolean, context?: any): void;
    function funnel(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Funnel;
    function ganttProject(): anychart.charts.Gantt;
    function ganttResource(): anychart.charts.Gantt;
    function ganttToolbar(): anychart.ui.GanttToolbar;
    function getChartById(id: string): anychart.core.Chart;
    function graph(data?: Object): anychart.charts.Graph;
    function heatMap(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.HeatMap;
    function hilo(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function jumpLine(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function licenseKey(key?: string): string;
    function line(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function line3d(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian3d;
    function map(): anychart.charts.Map;
    function marker(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Scatter;
    function markerMap(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Map;
    function mekko(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Mekko;
    function mosaic(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Mekko;
    function ohlc(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function onDocumentLoad(func: (() => void), scope?: any): void;
    function onDocumentReady(func: (() => void), scope?: any): void;
    function pareto(data?: anychart.data.View | anychart.data.Set | Array<any>): anychart.charts.Pareto;
    function pert(): anychart.charts.Pert;
    function pie(data?: anychart.data.View | anychart.data.Set | Array<any> | string): anychart.charts.Pie;
    function pie3d(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Pie;
    function polar(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Polar;
    function pyramid(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Pyramid;
    function quadrant(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Scatter;
    function radar(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Radar;
    function resource(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Resource;
    function sankey(): anychart.charts.Sankey;
    function scatter(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Scatter;
    function seatMap(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Map;
    function server(): string;
    function server(address?: string): void;
    function sparkline(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Sparkline;
    function stepLine(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function stick(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function stock(allowPointSettings?: boolean): anychart.charts.Stock;
    function sunburst(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string): anychart.charts.Sunburst;
    function surface(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Surface;
    function tagCloud(data?: anychart.data.View | anychart.data.Set | Array<any> | string, settings?: string | anychart.data.TextParsingSettings): anychart.charts.TagCloud;
    function theme(settings?: string | Object | Array<string|Object>): string | Object | Array<string|Object>;
    function timeline(data?: anychart.data.View | anychart.data.Set | Array<any>): anychart.charts.Timeline;
    function treeMap(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string): anychart.charts.TreeMap;
    function venn(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: {[prop:string]:string|boolean}): anychart.charts.Venn;
    function vertical(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function verticalArea(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function verticalLine(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Cartesian;
    function waterfall(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): anychart.charts.Waterfall;
    function wordtree(data?: anychart.data.Tree | string | Array<Object> | Array<Array<string>> | Array<string>, fillMethod?: string): anychart.charts.Wordtree;
    interface SignalEvent {
        targetBoundsChanged(): boolean;
        targetDataChanged(): boolean;
        targetMetaChanged(): boolean;
        targetNeedsReapplication(): boolean;
        targetNeedsRecalculation(): boolean;
        targetNeedsRedraw(): boolean;
    }
}

declare namespace anychart.charts {
    interface Sunburst extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Sunburst;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Sunburst;
        animation(enabled: boolean, duration: number): anychart.charts.Sunburst;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Sunburst;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Sunburst;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Sunburst;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Sunburst;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Sunburst;
        calculationMode(): string;
        calculationMode(mode?: string): anychart.charts.Sunburst;
        cancelMarquee(): anychart.charts.Sunburst;
        center(): anychart.core.ui.Center;
        center(centerSettings?: Object): anychart.charts.Sunburst;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Sunburst;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Sunburst;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Sunburst;
        data(): anychart.data.Tree | anychart.data.TreeView;
        data(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string): anychart.charts.Sunburst;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Sunburst;
        drillTo(target: anychart.data.Tree.DataItem | Array<any> | string): void;
        drillUp(): void;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Sunburst;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Sunburst;
        fill(): anychart.graphics.vector.Fill | (() => void);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sunburst;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Sunburst;
        fill(color: string, opacity?: number): anychart.charts.Sunburst;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sunburst;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sunburst;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sunburst;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Sunburst;
        getDrilldownPath(): Array<any>;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (()=>anychart.graphics.vector.HatchFill);
        hatchFill(enabled?: boolean): anychart.charts.Sunburst;
        hatchFill(hatchFillFunction?: (()=>anychart.graphics.vector.HatchFill)): anychart.charts.Sunburst;
        hatchFill(patternHatchFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sunburst;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sunburst;
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sunburst;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Sunburst;
        height(): number | string;
        height(height?: number | string): anychart.charts.Sunburst;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Sunburst;
        id(): string;
        id(id?: string): anychart.charts.Sunburst;
        inMarquee(): boolean;
        innerRadius(): string | number | (() => void);
        innerRadius(innerRadius?: string | number | ((outerRadius:number)=>number)): anychart.charts.Sunburst;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Sunburst;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Sunburst;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Sunburst;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Sunburst;
        leaves(): anychart.core.sunburst.Level;
        leaves(settings?: Object | boolean): anychart.charts.Sunburst;
        left(): number | string;
        left(value?: number | string): anychart.charts.Sunburst;
        level(index: number): anychart.core.sunburst.Level;
        level(index: number, settings?: Object | boolean): anychart.charts.Sunburst;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Sunburst;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Sunburst;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Sunburst;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Sunburst;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Sunburst;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Sunburst;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Sunburst;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Sunburst;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Sunburst;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Sunburst;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Sunburst;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        radius(): string | number;
        radius(radius?: string | number): anychart.charts.Sunburst;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Sunburst;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sunburst;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Sunburst;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sunburst;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sunburst;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sunburst;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Sunburst;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Sunburst;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        sort(): string | ((dataItem_1:anychart.data.Tree.DataItem|anychart.data.TreeView.DataItem,dataItem_2:anychart.data.Tree.DataItem|anychart.data.TreeView.DataItem)=>number);
        sort(mode?: string): anychart.charts.Sunburst;
        sort(sortFunction?: ((dataItem_1:anychart.data.Tree.DataItem|anychart.data.TreeView.DataItem,dataItem_2:anychart.data.Tree.DataItem|anychart.data.TreeView.DataItem)=>number)): anychart.charts.Sunburst;
        startAngle(): string | number;
        startAngle(startAngle?: string | number): anychart.charts.Sunburst;
        startSelectMarquee(repeat?: boolean): anychart.charts.Sunburst;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Sunburst;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Sunburst;
        stroke(settings?: Object): anychart.charts.Sunburst;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Sunburst;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Sunburst;
        top(): number | string;
        top(top?: number | string): anychart.charts.Sunburst;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Sunburst;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Sunburst;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Sunburst;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Sunburst;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Sunburst;
    }
    namespace Sunburst {
    type StatsFieldsName = {
        depth: number;
        level: {sum:number,nodesCount:number,leavesCount:number,branchesCount:number,display:boolean,attendingRoots:Array<number>,statsByRoot:{[prop:string]:{sum:number,nodesCount:number,leavesSum:number,leavesCount:number,branchesCount:number,childSum:number,nodes:Array<anychart.core.TreeChartPoint>}}};
    }
    }
    interface Surface extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Surface;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Surface;
        animation(enabled: boolean, duration: number): anychart.charts.Surface;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Surface;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Surface;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Surface;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Surface;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Surface;
        box(): anychart.graphics.vector.Stroke;
        box(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Surface;
        box(settings?: Object): anychart.charts.Surface;
        cancelMarquee(): anychart.charts.Surface;
        colorRange(): anychart.core.ui.ColorRange;
        colorRange(settings?: Object): anychart.charts.Surface;
        colorScale(): anychart.scales.LinearColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.charts.Surface;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Surface;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Surface;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Surface;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | Array<Array<number>> | string): anychart.charts.Surface;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Surface;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Surface;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Surface;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Surface;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Surface;
        id(): string;
        id(id?: string): anychart.charts.Surface;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Surface;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Surface;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Surface;
        left(): number | string;
        left(value?: number | string): anychart.charts.Surface;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Surface;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Surface;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Surface;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Surface;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Surface;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Surface;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Surface;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Surface;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Surface;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Surface;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Surface;
        rotationY(): number;
        rotationY(angle?: number): anychart.charts.Surface;
        rotationZ(): number;
        rotationZ(angle?: number): anychart.charts.Surface;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Surface;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Surface;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Surface;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Surface;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Surface;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Surface;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Surface;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Surface;
        stroke(settings?: Object): anychart.charts.Surface;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Surface;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Surface;
        top(): number | string;
        top(top?: number | string): anychart.charts.Surface;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Surface;
        xAxis(): anychart.core.axes.Surface;
        xAxis(settings?: Object | boolean): anychart.charts.Surface;
        xGrid(): anychart.core.grids.Surface;
        xGrid(settings?: Object | boolean): anychart.charts.Surface;
        xScale(): anychart.scales.Base;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.charts.Surface;
        yAxis(): anychart.core.axes.Surface;
        yAxis(settings?: Object | boolean): anychart.charts.Surface;
        yGrid(): anychart.core.grids.Surface;
        yGrid(settings?: Object | boolean): anychart.charts.Surface;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.charts.Surface;
        zAxis(): anychart.core.axes.Surface;
        zAxis(settings?: Object | boolean): anychart.charts.Surface;
        zGrid(): anychart.core.grids.Surface;
        zGrid(settings?: Object | boolean): anychart.charts.Surface;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Surface;
        zScale(): anychart.scales.Base;
        zScale(settings?: anychart.scales.Base | Object | string): anychart.charts.Surface;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Surface;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Surface;
    }
    interface TreeMap extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.TreeMap;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.TreeMap;
        animation(enabled: boolean, duration: number): anychart.charts.TreeMap;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.TreeMap;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.TreeMap;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.TreeMap;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.TreeMap;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.TreeMap;
        cancelMarquee(): anychart.charts.TreeMap;
        colorRange(): anychart.core.ui.ColorRange;
        colorRange(settings?: Object): anychart.charts.TreeMap;
        colorScale(): anychart.scales.OrdinalColor | anychart.scales.LinearColor;
        colorScale(settings?: anychart.scales.OrdinalColor | anychart.scales.LinearColor | Object | string): anychart.scales.LinearColor;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.TreeMap;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.TreeMap;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.TreeMap;
        data(): anychart.data.Tree | anychart.data.TreeView;
        data(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string): anychart.charts.TreeMap;
        dispose(): void;
        draw(async?: boolean): anychart.charts.TreeMap;
        drillTo(target: anychart.data.Tree.DataItem | Array<any> | string): void;
        drillUp(): void;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.TreeMap;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.TreeMap;
        fill(): anychart.graphics.vector.Fill | (() => void);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.TreeMap;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.TreeMap;
        fill(color: string, opacity?: number): anychart.charts.TreeMap;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.TreeMap;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.TreeMap;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.TreeMap;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.TreeMap;
        getDrilldownPath(): Array<any>;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.TreeMap;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.TreeMap;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.TreeMap;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.TreeMap;
        hatchFill(enabled?: boolean): anychart.charts.TreeMap;
        headers(): anychart.core.ui.LabelsFactory;
        headers(settings?: Object | boolean): anychart.charts.TreeMap;
        headersDisplayMode(): string;
        headersDisplayMode(mode?: string): anychart.charts.TreeMap;
        height(): number | string;
        height(height?: number | string): anychart.charts.TreeMap;
        hintDepth(): number;
        hintDepth(hintDepth?: number): anychart.charts.TreeMap;
        hintOpacity(): number;
        hintOpacity(hintOpacity?: number): anychart.charts.TreeMap;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.TreeMap;
        id(): string;
        id(id?: string): anychart.charts.TreeMap;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.TreeMap;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.TreeMap;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.TreeMap;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.TreeMap;
        labelsDisplayMode(): string;
        labelsDisplayMode(mode?: string): anychart.charts.TreeMap;
        left(): number | string;
        left(value?: number | string): anychart.charts.TreeMap;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.TreeMap;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.TreeMap;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.TreeMap;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.charts.TreeMap;
        maxDepth(): number;
        maxDepth(maxDepth?: number): anychart.charts.TreeMap;
        maxHeadersHeight(): number | string;
        maxHeadersHeight(height?: number | string): anychart.charts.TreeMap;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.TreeMap;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.TreeMap;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.TreeMap;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.TreeMap;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.TreeMap;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.TreeMap;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.TreeMap;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.TreeMap;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.TreeMap;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.TreeMap;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.TreeMap;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.TreeMap;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.TreeMap;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.TreeMap;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.TreeMap;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.TreeMap;
        selectionMode(): string;
        selectionMode(value?: string): anychart.charts.TreeMap;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        sort(): string;
        sort(type?: string): anychart.charts.TreeMap;
        startSelectMarquee(repeat?: boolean): anychart.charts.TreeMap;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.TreeMap;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.TreeMap;
        stroke(settings?: Object): anychart.charts.TreeMap;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.TreeMap;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.TreeMap;
        top(): number | string;
        top(top?: number | string): anychart.charts.TreeMap;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.TreeMap;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.TreeMap;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.TreeMap;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.TreeMap;
    }
    interface Timeline extends anychart.core.SeparateChart {
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.timeline.series.Base>;
        axis(): anychart.core.axes.Timeline;
        axis(value?: Object): anychart.charts.Timeline;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Mapping | anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Timeline;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Timeline;
        fit(): anychart.charts.Timeline;
        getSeries(id: number | string): anychart.core.timeline.series.Base;
        getSeriesAt(index: number): anychart.core.timeline.series.Base;
        getSeriesCount(): number;
        getType(): string;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(value: Object): anychart.charts.Timeline;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(value?: Object | boolean): anychart.charts.Timeline;
        lineMarker(index?: number, value?: Object | boolean): anychart.charts.Timeline;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        moment(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.timeline.series.Moment;
        range(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.timeline.series.Range;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(value?: Object | boolean): anychart.charts.Timeline;
        rangeMarker(index?: number, value?: Object | boolean): anychart.charts.Timeline;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Timeline;
        removeSeries(id: number | string): anychart.charts.Timeline;
        removeSeriesAt(index: number): anychart.charts.Timeline;
        scale(): anychart.scales.GanttDateTime;
        scale(value?: Object): anychart.charts.Timeline;
        scroll(): number;
        scroll(value?: number): anychart.charts.Timeline;
        scroller(): anychart.core.ui.ChartScroller;
        scroller(value?: Object | boolean): anychart.charts.Timeline;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(value?: Object | boolean): anychart.charts.Timeline;
        textMarker(index?: number, value?: Object | boolean): anychart.charts.Timeline;
        todayMarker(): anychart.core.axisMarkers.Line;
        todayMarker(value?: Object | boolean): anychart.charts.Timeline;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        zoomTo(startDate: string | number | Date, endDate: string | number | Date): anychart.charts.Timeline;
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Timeline;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Timeline;
        animation(enabled: boolean, duration: number): anychart.charts.Timeline;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Timeline;
        background(): anychart.core.ui.Background;
        background(settings?: Object): anychart.charts.Timeline;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Timeline;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Timeline;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Timeline;
        cancelMarquee(): anychart.charts.Timeline;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Timeline;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Timeline;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.charts.Timeline;
        draw(async?: boolean): anychart.charts.Timeline;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Timeline;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Timeline;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Timeline;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Timeline;
        id(): string;
        id(id?: string): anychart.charts.Timeline;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Timeline;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Timeline;
        left(): number | string;
        left(left?: number | string): anychart.charts.Timeline;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Timeline;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Timeline;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Timeline;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.charts.Timeline;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.charts.Timeline;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.charts.Timeline;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.charts.Timeline;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Timeline;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Timeline;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Timeline;
        right(): number | string;
        right(right?: number | string): anychart.charts.Timeline;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number | Object, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSizeOrWidthOrOptions?: number | string | Object, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number | Object, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string | Object, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Timeline;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Timeline;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Timeline;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Timeline;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Timeline;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Timeline;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Timeline;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string | Object, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Timeline;
        top(): number | string;
        top(top?: number | string): anychart.charts.Timeline;
        width(): number | string;
        width(width?: number | string): anychart.charts.Timeline;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Timeline;
        dispose(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Timeline;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Timeline;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Timeline;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
    }
    interface Cartesian extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Cartesian;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.cartesian.series.Base>;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Cartesian;
        animation(enabled: boolean, duration: number): anychart.charts.Cartesian;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.Cartesian;
        area(data?: anychart.data.View | anychart.data.Set | Array<any>, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Area;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Cartesian;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Cartesian;
        bar(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bar;
        barGroupsPadding(): number;
        barGroupsPadding(padding?: number): anychart.charts.Cartesian;
        barsPadding(): number;
        barsPadding(padding?: number): anychart.charts.Cartesian;
        baseline(): number;
        baseline(value?: number): anychart.charts.Cartesian;
        bottom(): number | string;
        bottom(value?: number | string): anychart.charts.Cartesian;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Cartesian;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Cartesian;
        box(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Box;
        bubble(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bubble;
        cancelMarquee(): anychart.charts.Cartesian;
        candlestick(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Candlestick;
        categorizedBySeries(): boolean;
        categorizedBySeries(enabled?: boolean): anychart.charts.Cartesian;
        column(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Column;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Cartesian;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Cartesian;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Cartesian;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Cartesian;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Cartesian;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.Cartesian;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Cartesian;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Cartesian;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Cartesian;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Cartesian;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Cartesian;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSeries(id: number | string): anychart.core.cartesian.series.Base;
        getSeriesAt(index: number): anychart.core.cartesian.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXAxesCount(): number;
        getXScales(): Array<any>;
        getYAxesCount(): number;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Cartesian;
        height(): number | string;
        height(value?: number | string): anychart.charts.Cartesian;
        hilo(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Hilo;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Cartesian;
        id(): string;
        id(id?: string): anychart.charts.Cartesian;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Cartesian;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.charts.Cartesian;
        jumpLine(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.JumpLine;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Cartesian;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Cartesian;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Cartesian;
        left(): number | string;
        left(value?: number | string): anychart.charts.Cartesian;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Cartesian;
        line(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Line;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Cartesian;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Cartesian;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Cartesian;
        marker(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Cartesian;
        maxBubbleSize(): number | string;
        maxBubbleSize(size?: number | string): anychart.charts.Cartesian;
        maxHeight(): number | string;
        maxHeight(value?: number | string): anychart.charts.Cartesian;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Cartesian;
        maxPointWidth(): string | number;
        maxPointWidth(maxWidth?: number | string): anychart.charts.Cartesian;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Cartesian;
        minBubbleSize(): number | string;
        minBubbleSize(size?: number | string): anychart.charts.Cartesian;
        minHeight(): number | string;
        minHeight(value?: number | string): anychart.charts.Cartesian;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Cartesian;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.charts.Cartesian;
        minWidth(): number | string;
        minWidth(value?: number | string): anychart.charts.Cartesian;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Cartesian;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Cartesian;
        ohlc(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.OHLC;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Cartesian;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Cartesian;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Cartesian;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.charts.Cartesian;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeArea(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeArea;
        rangeBar(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeBar;
        rangeColumn(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeColumn;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Cartesian;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        rangeSplineArea(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeSplineArea;
        rangeStepArea(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeStepArea;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Cartesian;
        removeSeries(id: number | string): anychart.charts.Cartesian;
        removeSeriesAt(index: number): anychart.charts.Cartesian;
        right(): number | string;
        right(value?: number | string): anychart.charts.Cartesian;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Cartesian;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Cartesian;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Cartesian;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Cartesian;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Cartesian;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Cartesian;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Cartesian;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        spline(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Spline;
        splineArea(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.SplineArea;
        startSelectMarquee(repeat?: boolean): anychart.charts.Cartesian;
        stepArea(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.StepArea;
        stepLine(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.StepLine;
        stick(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Stick;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Cartesian;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Cartesian;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Cartesian;
        top(): number | string;
        top(value?: number | string): anychart.charts.Cartesian;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(value?: number | string): anychart.charts.Cartesian;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Cartesian;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.Cartesian;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        xMinorGrid(index?: number): anychart.core.grids.Linear;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Cartesian;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        xScale(): anychart.scales.Base;
        xScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Cartesian;
        xScroller(): anychart.core.ui.ChartScroller;
        xScroller(settings?: Object | boolean): anychart.charts.Cartesian;
        xZoom(): anychart.core.utils.OrdinalZoom;
        xZoom(settings?: number | boolean | Object): anychart.charts.Cartesian;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Cartesian;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.Cartesian;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        yMinorGrid(index?: number): anychart.core.grids.Linear;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Cartesian;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian;
        yScale(): anychart.scales.Linear;
        yScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Cartesian;
        yScroller(): anychart.core.ui.ChartScroller;
        yScroller(settings?: Object | boolean): anychart.charts.Cartesian;
        yZoom(): anychart.core.utils.OrdinalZoom;
        yZoom(settings?: number | boolean | Object): anychart.charts.Cartesian;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Cartesian;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Cartesian;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Cartesian;
    }
    interface Bullet extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Bullet;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Bullet;
        axis(): anychart.core.axes.Linear;
        axis(settings?: Object | boolean): anychart.charts.Bullet;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Bullet;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Bullet;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Bullet;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Bullet;
        cancelMarquee(): anychart.charts.Bullet;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Bullet;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Bullet;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.charts.Bullet;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Bullet;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Bullet;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Bullet;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Bullet;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Bullet;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Bullet;
        id(): string;
        id(id?: string): anychart.charts.Bullet;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        isHorizontal(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Bullet;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Bullet;
        layout(): string;
        layout(layout?: string): anychart.charts.Bullet;
        left(): number | string;
        left(left?: number | string): anychart.charts.Bullet;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Bullet;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Bullet;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: Array<string|string> | Object | anychart.palettes.Markers): anychart.charts.Bullet;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Bullet;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Bullet;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Bullet;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Bullet;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Bullet;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Bullet;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Bullet;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        range(index?: number): anychart.core.axisMarkers.Range;
        range(settings?: Object | boolean): anychart.charts.Bullet;
        range(index?: number, settings?: Object | boolean): anychart.charts.Bullet;
        rangePalette(): anychart.palettes.DistinctColors;
        rangePalette(settings?: anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Bullet;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Bullet;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.charts.Bullet;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Bullet;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Bullet;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Bullet;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Bullet;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Bullet;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Bullet;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Bullet;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Bullet;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Bullet;
        top(): number | string;
        top(top?: number | string): anychart.charts.Bullet;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Bullet;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Bullet;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Bullet;
        animation(enabled: boolean, duration: number): anychart.charts.Bullet;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Bullet;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Bullet;
    }
    interface Polar extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Polar;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.polar.series.Base>;
        area(data: anychart.data.View | anychart.data.Set | Array<any>, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Area;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Polar;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Polar;
        barGroupsPadding(): number;
        barGroupsPadding(padding?: number): anychart.charts.Polar;
        barsPadding(): number;
        barsPadding(padding?: number): anychart.charts.Polar;
        baseline(): number;
        baseline(value?: number): anychart.charts.Polar;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Polar;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Polar;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Polar;
        cancelMarquee(): anychart.charts.Polar;
        column(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Column;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Polar;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Polar;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Polar;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Polar;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Polar;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Polar;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Polar;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Polar;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Polar;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSeries(id: number | string): anychart.core.polar.series.Base;
        getSeriesAt(index: number): anychart.core.polar.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXScales(): Array<any>;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Polar;
        height(): number | string;
        height(height?: number | string): anychart.charts.Polar;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Polar;
        id(): string;
        id(id?: string): anychart.charts.Polar;
        inMarquee(): boolean;
        innerRadius(): number | string;
        innerRadius(radius?: number | string): anychart.charts.Polar;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Polar;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Polar;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Polar;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Polar;
        left(): number | string;
        left(value?: number | string): anychart.charts.Polar;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Polar;
        line(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Line;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Polar;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Polar;
        marker(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Polar;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Polar;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Polar;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.charts.Polar;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Polar;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Polar;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Polar;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.charts.Polar;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Polar;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Polar;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Polar;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Polar;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Polar;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Polar;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.charts.Polar;
        polygon(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Polygon;
        polyline(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.Polyline;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeColumn(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.polar.series.RangeColumn;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Polar;
        removeSeries(id: number | string): anychart.charts.Polar;
        removeSeriesAt(index: number): anychart.charts.Polar;
        right(): number | string;
        right(right?: number | string): anychart.charts.Polar;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Polar;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Polar;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Polar;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Polar;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Polar;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Polar;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Polar;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        sortPointsByX(): boolean;
        sortPointsByX(enabled?: boolean): anychart.charts.Polar;
        startAngle(): string | number;
        startAngle(angle?: string | number): anychart.charts.Polar;
        startSelectMarquee(repeat?: boolean): anychart.charts.Polar;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Polar;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Polar;
        top(): number | string;
        top(top?: number | string): anychart.charts.Polar;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Polar;
        xAxis(): anychart.core.axes.Polar;
        xAxis(settings?: Object | boolean): anychart.charts.Polar;
        xGrid(index?: number): anychart.core.grids.Polar;
        xGrid(settings?: Object | boolean): anychart.charts.Polar;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Polar;
        xMinorGrid(index?: number): anychart.core.grids.Polar;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Polar;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Polar;
        xScale(): anychart.scales.ScatterBase;
        xScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Polar;
        yAxis(): anychart.core.axes.Radial;
        yAxis(settings?: Object | boolean): anychart.charts.Polar;
        yGrid(index?: number): anychart.core.grids.Polar;
        yGrid(settings?: Object | boolean): anychart.charts.Polar;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Polar;
        yMinorGrid(index?: number): anychart.core.grids.Polar;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Polar;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Polar;
        yScale(): anychart.scales.ScatterBase;
        yScale(value?: Object | string | anychart.scales.ScatterBase): anychart.charts.Polar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Polar;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Polar;
        animation(enabled: boolean, duration: number): anychart.charts.Polar;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Polar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Polar;
    }
    interface Pert extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Pert;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Pert;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Pert;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Pert;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Pert;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Pert;
        cancelMarquee(): anychart.charts.Pert;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Pert;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Pert;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Pert;
        criticalPath(): anychart.core.pert.CriticalPath;
        criticalPath(settings?: Object): anychart.charts.Pert;
        data(): anychart.data.Tree | anychart.data.TreeView;
        data(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string, deps?: Array<anychart.data.Tree.Dependency>): anychart.charts.Pert;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Pert;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Pert;
        expectedTimeCalculator(): (()=>number);
        expectedTimeCalculator(durationFunction?: (()=>number)): anychart.charts.Pert;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Pert;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Pert;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Pert;
        horizontalSpacing(): string | number;
        horizontalSpacing(spacing?: number | string): anychart.charts.Pert;
        id(): string;
        id(id?: string): anychart.charts.Pert;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Pert;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Pert;
        left(): number | string;
        left(value?: number | string): anychart.charts.Pert;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Pert;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pert;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Pert;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Pert;
        milestones(): anychart.core.pert.Milestones;
        milestones(settings?: Object): anychart.charts.Pert;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Pert;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Pert;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Pert;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Pert;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pert;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Pert;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pert;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Pert;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pert;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pert;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pert;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pert;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Pert;
        tasks(): anychart.core.pert.Tasks;
        tasks(settings?: Object): anychart.charts.Pert;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Pert;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        top(): number | string;
        top(top?: number | string): anychart.charts.Pert;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        verticalSpacing(): string | number;
        verticalSpacing(settings?: number | string): anychart.charts.Pert;
        width(): number | string;
        width(width?: number | string): anychart.charts.Pert;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Pert;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Pert;
        animation(enabled: boolean, duration: number): anychart.charts.Pert;
        getSelectedPoints(): Array<anychart.core.Point>;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Pert;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Pert;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Pert;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Pert;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Pert;
    }
    interface Scatter extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Scatter;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.scatter.series.Base>;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Scatter;
        animation(enabled: boolean, duration: number): anychart.charts.Scatter;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.Scatter;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Scatter;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Scatter;
        baseline(): number;
        baseline(value?: number): anychart.charts.Scatter;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Scatter;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Scatter;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Scatter;
        bubble(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.scatter.series.Bubble;
        cancelMarquee(): anychart.charts.Scatter;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Scatter;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Scatter;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Scatter;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Scatter;
        crossing(): anychart.core.utils.Crossing;
        crossing(settings?: Object): anychart.charts.Scatter;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.Scatter;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Scatter;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Scatter;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Scatter;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Scatter;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Scatter;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSeries(id: number | string): anychart.core.scatter.series.Base;
        getSeriesAt(index: number): anychart.core.scatter.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXScales(): Array<any>;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Scatter;
        height(): number | string;
        height(height?: number | string): anychart.charts.Scatter;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Scatter;
        id(): string;
        id(id?: string): anychart.charts.Scatter;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Scatter;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.charts.Scatter;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Scatter;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Scatter;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Scatter;
        left(): number | string;
        left(value?: number | string): anychart.charts.Scatter;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Scatter;
        line(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.scatter.series.Line;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Scatter;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Scatter;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Scatter;
        marker(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.scatter.series.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(value?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Scatter;
        maxBubbleSize(): number | string;
        maxBubbleSize(size?: number | string): anychart.charts.Scatter;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Scatter;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Scatter;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Scatter;
        minBubbleSize(): number | string;
        minBubbleSize(value?: number | string): anychart.charts.Scatter;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Scatter;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Scatter;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Scatter;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Scatter;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Scatter;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Scatter;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Scatter;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Scatter;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        quarters(): anychart.core.utils.QuarterSettings;
        quarters(settings?: Object): anychart.charts.Scatter;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Scatter;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Scatter;
        removeSeries(id: number | string): anychart.charts.Scatter;
        removeSeriesAt(index: number): anychart.charts.Scatter;
        right(): number | string;
        right(value?: number | string): anychart.charts.Scatter;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Scatter;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Scatter;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Scatter;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Scatter;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Scatter;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Scatter;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Scatter;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Scatter;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Scatter;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Scatter;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Scatter;
        top(): number | string;
        top(top?: number | string): anychart.charts.Scatter;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Scatter;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Scatter;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.Scatter;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        xMinorGrid(index?: number): anychart.core.grids.Linear;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Scatter;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        xScale(): anychart.scales.ScatterBase;
        xScale(settings?: Object | string | anychart.scales.ScatterBase): anychart.charts.Scatter;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Scatter;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.Scatter;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        yMinorGrid(index?: number): anychart.core.grids.Linear;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Scatter;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Scatter;
        yScale(): anychart.scales.ScatterBase;
        yScale(settings?: Object | string | anychart.scales.ScatterBase): anychart.charts.Scatter;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Scatter;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Scatter;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Scatter;
    }
    interface Pareto extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Pareto;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.cartesian.series.Base>;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.Pareto;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Pareto;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Pareto;
        barGroupsPadding(): number;
        barGroupsPadding(padding?: number): anychart.charts.Pareto;
        barsPadding(): number;
        barsPadding(padding?: number): anychart.charts.Pareto;
        baseline(): number;
        baseline(value?: number): anychart.charts.Pareto;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Pareto;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Pareto;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Pareto;
        cancelMarquee(): anychart.charts.Pareto;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Pareto;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Pareto;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Pareto;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | anychart.data.DataSettings | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Pareto;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.Pareto;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Pareto;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Pareto;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Pareto;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Pareto;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Pareto;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSeries(id: number | string): anychart.core.cartesian.series.Base;
        getSeriesAt(index: number): anychart.core.cartesian.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXAxesCount(): number;
        getXScales(): Array<any>;
        getYAxesCount(): number;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Pareto;
        height(): number | string;
        height(height?: number | string): anychart.charts.Pareto;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Pareto;
        id(): string;
        id(id?: string): anychart.charts.Pareto;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.charts.Pareto;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Pareto;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Pareto;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Pareto;
        left(): number | string;
        left(value?: number | string): anychart.charts.Pareto;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Pareto;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Pareto;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Pareto;
        maxBubbleSize(): number | string;
        maxBubbleSize(size?: number | string): anychart.charts.Pareto;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Pareto;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.charts.Pareto;
        minBubbleSize(): number | string;
        minBubbleSize(size?: number | string): anychart.charts.Pareto;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Pareto;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.charts.Pareto;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Pareto;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Pareto;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Pareto;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.charts.Pareto;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Pareto;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        removeAllSeries(): anychart.charts.Pareto;
        removeSeries(id: number | string): anychart.charts.Pareto;
        removeSeriesAt(index: number): anychart.charts.Pareto;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pareto;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Pareto;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pareto;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pareto;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pareto;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pareto;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Pareto;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Pareto;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Pareto;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Pareto;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Pareto;
        top(): number | string;
        top(top?: number | string): anychart.charts.Pareto;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Pareto;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Pareto;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.Pareto;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        xMinorGrid(index?: number): anychart.core.grids.Linear;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Pareto;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        xScale(): anychart.scales.Base;
        xScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Pareto;
        xScroller(): anychart.core.ui.ChartScroller;
        xScroller(settings?: Object | boolean): anychart.charts.Pareto;
        xZoom(): anychart.core.utils.OrdinalZoom;
        xZoom(settings?: number | boolean | Object): anychart.charts.Pareto;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Pareto;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.Pareto;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        yMinorGrid(index?: number): anychart.core.grids.Linear;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Pareto;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Pareto;
        yScale(): anychart.scales.Base;
        yScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Pareto;
        yScroller(): anychart.core.ui.ChartScroller;
        yScroller(settings?: Object | boolean): anychart.charts.Pareto;
        yZoom(): anychart.core.utils.OrdinalZoom;
        yZoom(settings?: number | boolean | Object): anychart.charts.Pareto;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Pareto;
        animation(enabled: boolean, duration: number): anychart.charts.Pareto;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Pareto;
        getSelectedPoints(): Array<anychart.core.Point>;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Pareto;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Pareto;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pareto;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.charts.Pareto;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.charts.Pareto;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.charts.Pareto;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.charts.Pareto;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Pareto;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pareto;
        right(): number | string;
        right(right?: number | string): anychart.charts.Pareto;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Pareto;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Pareto;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Pareto;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
    }
    interface Venn extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Venn;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Venn;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Venn;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Venn;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Venn;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Venn;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Venn;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Venn;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Venn;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Mapping | anychart.data.Set | Array<any> | string | anychart.data.DataSettings, csvSettings?: {[prop:string]:string|boolean}): anychart.charts.Venn;
        dataSeparator(): string;
        dataSeparator(separator?: string): anychart.charts.Venn;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Venn;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Venn;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Venn;
        fill(): anychart.graphics.vector.Fill | (() => void);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Venn;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Venn;
        fill(color: string, opacity?: number): anychart.charts.Venn;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Venn;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Venn;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Venn;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Venn;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Venn;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.Venn;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Venn;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Venn;
        hatchFill(enabled?: boolean): anychart.charts.Venn;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Venn;
        height(): number | string;
        height(height?: number | string): anychart.charts.Venn;
        hover(): anychart.charts.Venn;
        hover(index?: number): anychart.charts.Venn;
        hover(indexes?: Array<number>): anychart.charts.Venn;
        hovered(): anychart.core.StateSettings;
        hovered(value?: Object): anychart.charts.Venn;
        id(): string;
        id(id?: string): anychart.charts.Venn;
        intersections(): anychart.core.venn.Intersections;
        intersections(settings?: Object): anychart.charts.Venn;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Venn;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Venn;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Venn;
        left(): number | string;
        left(value?: number | string): anychart.charts.Venn;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Venn;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Venn;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Venn;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Venn;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.charts.Venn;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Venn;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Venn;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Venn;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Venn;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Venn;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Venn;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Venn;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Venn;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Venn;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Venn;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(index?: number): anychart.charts.Venn;
        select(indexes?: number | Array<number>): anychart.charts.Venn;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Venn;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Venn;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Venn;
        stroke(settings?: Object): anychart.charts.Venn;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Venn;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Venn;
        top(): number | string;
        top(top?: number | string): anychart.charts.Venn;
        unhover(indexOrIndexes?: number | Array<number>): anychart.charts.Venn;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(): anychart.charts.Venn;
        unselect(index?: number): anychart.charts.Venn;
        unselect(indexes?: Array<number>): anychart.charts.Venn;
        width(): number | string;
        width(width?: number | string): anychart.charts.Venn;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Venn;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Venn;
        animation(enabled: boolean, duration: number): anychart.charts.Venn;
        cancelMarquee(): anychart.charts.Venn;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Venn;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Venn;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Venn;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Venn;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Venn;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Venn;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Venn;
        startSelectMarquee(repeat?: boolean): anychart.charts.Venn;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Venn;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Venn;
    }
    interface Waterfall extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Waterfall;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.cartesian.series.Base>;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.Waterfall;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Waterfall;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Waterfall;
        barGroupsPadding(): number;
        barGroupsPadding(padding?: number): anychart.charts.Waterfall;
        baseline(): number;
        baseline(value?: number): anychart.charts.Waterfall;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Waterfall;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Waterfall;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Waterfall;
        cancelMarquee(): anychart.charts.Waterfall;
        connectorStroke(): anychart.graphics.vector.Stroke;
        connectorStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: anychart.graphics.vector.StrokeLineJoin, lineCap?: anychart.graphics.vector.StrokeLineCap): anychart.charts.Waterfall;
        connectorStroke(settings?: Object): anychart.charts.Waterfall;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Waterfall;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Waterfall;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Waterfall;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Waterfall;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Waterfall;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.Waterfall;
        dataMode(): string;
        dataMode(mode?: string): anychart.charts.Waterfall;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Waterfall;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Waterfall;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Waterfall;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Waterfall;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSeries(id: number | string): anychart.core.waterfall.series.Waterfall;
        getSeriesAt(index: number): anychart.core.cartesian.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXAxesCount(): number;
        getXScales(): Array<any>;
        getYAxesCount(): number;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Waterfall;
        height(): number | string;
        height(height?: number | string): anychart.charts.Waterfall;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Waterfall;
        id(): string;
        id(id?: string): anychart.charts.Waterfall;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Waterfall;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.charts.Waterfall;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Waterfall;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Waterfall;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Waterfall;
        left(): number | string;
        left(value?: number | string): anychart.charts.Waterfall;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Waterfall;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Waterfall;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Waterfall;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Waterfall;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Waterfall;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Waterfall;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Waterfall;
        maxPointWidth(): string | number;
        maxPointWidth(settings?: number | string): anychart.charts.Waterfall;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Waterfall;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Waterfall;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Waterfall;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.charts.Waterfall;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Waterfall;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Waterfall;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Waterfall;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Waterfall;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Waterfall;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Waterfall;
        pointWidth(): string | number;
        pointWidth(settings?: number | string): anychart.charts.Waterfall;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Waterfall;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Waterfall;
        removeSeries(id: number | string): anychart.charts.Waterfall;
        removeSeriesAt(index: number): anychart.charts.Waterfall;
        right(): number | string;
        right(right?: number | string): anychart.charts.Waterfall;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Waterfall;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Waterfall;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Waterfall;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Waterfall;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Waterfall;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Waterfall;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Waterfall;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Waterfall;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Waterfall;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Waterfall;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Waterfall;
        top(): number | string;
        top(top?: number | string): anychart.charts.Waterfall;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        waterfall(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.waterfall.series.Waterfall;
        width(): number | string;
        width(width?: number | string): anychart.charts.Waterfall;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Waterfall;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.Waterfall;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        xMinorGrid(index?: number): anychart.core.grids.Linear;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Waterfall;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Waterfall;
        xScroller(): anychart.core.ui.ChartScroller;
        xScroller(settings?: Object | boolean): anychart.charts.Waterfall;
        xZoom(): anychart.core.utils.OrdinalZoom;
        xZoom(settings?: number | boolean | Object): anychart.charts.Waterfall;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Waterfall;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.Waterfall;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        yMinorGrid(index?: number): anychart.core.grids.Linear;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Waterfall;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Waterfall;
        yScale(): anychart.scales.Linear;
        yScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Waterfall;
        yScroller(): anychart.core.ui.ChartScroller;
        yScroller(settings?: Object | boolean): anychart.charts.Waterfall;
        yZoom(): anychart.core.utils.OrdinalZoom;
        yZoom(settings?: number | boolean | Object): anychart.charts.Waterfall;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Waterfall;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Waterfall;
        animation(enabled: boolean, duration: number): anychart.charts.Waterfall;
        getSelectedPoints(): Array<anychart.core.Point>;
        inMarquee(): boolean;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Waterfall;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Waterfall;
    }
    interface TagCloud extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.TagCloud;
        angles(): Array<number>;
        angles(anglesList?: Array<number>): anychart.charts.TagCloud;
        anglesCount(): number;
        anglesCount(count?: number): anychart.charts.TagCloud;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.TagCloud;
        animation(enabled: boolean, duration: number): anychart.charts.TagCloud;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.TagCloud;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.TagCloud;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.TagCloud;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.TagCloud;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.TagCloud;
        colorRange(): anychart.core.ui.ColorRange;
        colorRange(settings?: Object | boolean): anychart.charts.TagCloud;
        colorScale(): anychart.scales.OrdinalColor | anychart.scales.LinearColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.charts.TagCloud;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.TagCloud;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.TagCloud;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.TagCloud;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | anychart.data.DataSettings | string, settings?: string | anychart.data.TextParsingSettings): anychart.charts.TagCloud;
        dispose(): void;
        draw(async?: boolean): anychart.charts.TagCloud;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.TagCloud;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.TagCloud;
        fromAngle(): number;
        fromAngle(angle?: number): anychart.charts.TagCloud;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.TagCloud;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPoint(index: number): anychart.core.Point;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.TagCloud;
        hover(index: number | Array<number>): anychart.charts.TagCloud;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.TagCloud;
        id(): string;
        id(id?: string): anychart.charts.TagCloud;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.TagCloud;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.TagCloud;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.TagCloud;
        left(): number | string;
        left(value?: number | string): anychart.charts.TagCloud;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.TagCloud;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.TagCloud;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.TagCloud;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.TagCloud;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.TagCloud;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.TagCloud;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.TagCloud;
        mode(): string;
        mode(mode?: string): anychart.charts.TagCloud;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.TagCloud;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.TagCloud;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.TagCloud;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.TagCloud;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.TagCloud;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.TagCloud;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scale(): anychart.scales.Base;
        scale(settings?: string | anychart.scales.Base | Object): anychart.charts.TagCloud;
        select(index?: number): anychart.charts.TagCloud;
        select(indexes?: Array<number>): anychart.charts.TagCloud;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.TagCloud;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        textSpacing(): number;
        textSpacing(spacing?: number): anychart.charts.TagCloud;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.TagCloud;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toAngle(): number;
        toAngle(angle?: number): anychart.charts.TagCloud;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.TagCloud;
        top(): number | string;
        top(top?: number | string): anychart.charts.TagCloud;
        unhover(): anychart.charts.TagCloud;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(indexOrIndexes?: number | Array<number>): void;
        width(): number | string;
        width(width?: number | string): anychart.charts.TagCloud;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.TagCloud;
        cancelMarquee(): anychart.charts.TagCloud;
        inMarquee(): boolean;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.TagCloud;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.TagCloud;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.TagCloud;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.TagCloud;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.TagCloud;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.TagCloud;
        startSelectMarquee(repeat?: boolean): anychart.charts.TagCloud;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.TagCloud;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.TagCloud;
    }
    interface Cartesian3d extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Cartesian3d;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.cartesian.series.Base>;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Cartesian3d;
        animation(enabled: boolean, duration: number): anychart.charts.Cartesian3d;
        area(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Area3d;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Cartesian3d;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Cartesian3d;
        bar(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bar3d;
        barGroupsPadding(): number;
        barGroupsPadding(padding?: number): anychart.charts.Cartesian3d;
        barsPadding(): number;
        barsPadding(padding?: number): anychart.charts.Cartesian3d;
        baseline(): number;
        baseline(value?: number): anychart.charts.Cartesian3d;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Cartesian3d;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Cartesian3d;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Cartesian3d;
        cancelMarquee(): anychart.charts.Cartesian3d;
        column(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Column3d;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Cartesian3d;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Cartesian3d;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Cartesian3d;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Cartesian3d;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | Array<any> | anychart.data.DataSettings | Object): anychart.charts.Cartesian3d;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Cartesian3d;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Cartesian3d;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Cartesian3d;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Cartesian3d;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Cartesian3d;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSeries(id: number | string): anychart.core.cartesian.series.Base;
        getSeriesAt(index: number): anychart.core.cartesian.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXAxesCount(): number;
        getXScales(): Array<any>;
        getYAxesCount(): number;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Cartesian3d;
        height(): number | string;
        height(height?: number | string): anychart.charts.Cartesian3d;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Cartesian3d;
        id(): string;
        id(id?: string): anychart.charts.Cartesian3d;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Cartesian3d;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Cartesian3d;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Cartesian3d;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Cartesian3d;
        left(): number | string;
        left(value?: number | string): anychart.charts.Cartesian3d;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Cartesian3d;
        line(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Line3d;
        line2d(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Line;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Cartesian3d;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Cartesian3d;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Cartesian3d;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Cartesian3d;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Cartesian3d;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.charts.Cartesian3d;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Cartesian3d;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Cartesian3d;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Cartesian3d;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.charts.Cartesian3d;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Cartesian3d;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Cartesian3d;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Cartesian3d;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Cartesian3d;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Cartesian3d;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Cartesian3d;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.charts.Cartesian3d;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Cartesian3d;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Cartesian3d;
        removeSeries(id: number | string): anychart.charts.Cartesian3d;
        removeSeriesAt(index: number): anychart.charts.Cartesian3d;
        right(): number | string;
        right(right?: number | string): anychart.charts.Cartesian3d;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Cartesian3d;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Cartesian3d;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Cartesian3d;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Cartesian3d;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Cartesian3d;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Cartesian3d;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Cartesian3d;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Cartesian3d;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Cartesian3d;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Cartesian3d;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Cartesian3d;
        top(): number | string;
        top(top?: number | string): anychart.charts.Cartesian3d;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Cartesian3d;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Cartesian3d;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.Cartesian3d;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        xMinorGrid(index?: number): anychart.core.grids.Linear;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Cartesian3d;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Cartesian3d;
        xScroller(): anychart.core.ui.ChartScroller;
        xScroller(settings?: Object | boolean): anychart.charts.Cartesian3d;
        xZoom(): anychart.core.utils.OrdinalZoom;
        xZoom(settings?: number | boolean | Object): anychart.charts.Cartesian3d;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Cartesian3d;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.Cartesian3d;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        yMinorGrid(index?: number): anychart.core.grids.Linear;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Cartesian3d;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Cartesian3d;
        yScale(): anychart.scales.Linear;
        yScale(value?: Object | string | anychart.scales.Base): anychart.charts.Cartesian3d;
        yScroller(): anychart.core.ui.ChartScroller;
        yScroller(settings?: Object | boolean): anychart.charts.Cartesian3d;
        yZoom(): anychart.core.utils.OrdinalZoom;
        yZoom(settings?: number | boolean | Object): anychart.charts.Cartesian3d;
        zAngle(): number;
        zAngle(angle?: number): anychart.charts.Cartesian3d;
        zAspect(): number | string;
        zAspect(value?: number | string): anychart.charts.Cartesian3d;
        zDepth(): number;
        zDepth(value?: number): anychart.charts.Cartesian3d;
        zDistribution(): boolean;
        zDistribution(enabled?: boolean): anychart.charts.Cartesian3d;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Cartesian3d;
        zPadding(): number;
        zPadding(padding?: number): anychart.charts.Cartesian3d;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Cartesian3d;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Cartesian3d;
    }
    interface Stock extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Stock;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Stock;
        animation(enabled: boolean, duration: number): anychart.charts.Stock;
        annotations(): anychart.core.annotations.ChartController;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Stock;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Stock;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Stock;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Stock;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Stock;
        cancelMarquee(): anychart.charts.Stock;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Stock;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Stock;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Stock;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Stock;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Stock;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Stock;
        eventMarkers(): anychart.core.stock.eventMarkers.Controller;
        eventMarkers(settings?: Object | boolean): anychart.charts.Stock;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Stock;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Stock;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotsCount(): number;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSelectedRange(): anychart.charts.Stock.SelectedRange;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        grouping(): anychart.core.stock.Grouping;
        grouping(settings?: boolean | Array<string|anychart.core.stock.Grouping.Level> | Object): anychart.charts.Stock;
        height(): number | string;
        height(height?: number | string): anychart.charts.Stock;
        id(): string;
        id(id?: string): anychart.charts.Stock;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.StockInteractivity;
        interactivity(settings?: Object | string): anychart.core.SeparateChart;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Stock;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Stock;
        left(): number | string;
        left(value?: number | string): anychart.charts.Stock;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Stock;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Stock;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Stock;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Stock;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Stock;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Stock;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Stock;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Stock;
        plot(index?: number): anychart.core.stock.Plot;
        plot(settings?: Object | boolean): anychart.charts.Stock;
        plot(index?: number, settings?: Object | boolean): anychart.charts.Stock;
        preserveSelectedRangeOnDataUpdate(): boolean;
        preserveSelectedRangeOnDataUpdate(enabled?: boolean): anychart.charts.Stock;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(value?: number | string): anychart.charts.Stock;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scroller(): anychart.core.stock.Scroller;
        scroller(settings?: Object | boolean): anychart.charts.Stock;
        scrollerGrouping(): anychart.core.stock.Grouping;
        scrollerGrouping(value?: boolean | Array<string|anychart.core.stock.Grouping.Level> | Object): anychart.charts.Stock;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Stock;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Stock;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Stock;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Stock;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Stock;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Stock;
        selectRange(start: number | string | Date, end?: number | string | Date): anychart.charts.Stock;
        selectRange(start: number | string | Date, end?: number | string | Date, dispatchEvent?: boolean): anychart.charts.Stock;
        selectRange(type: string, count?: number, dispatchEvent?: boolean): anychart.charts.Stock;
        selectRange(unit: string, count?: number, anchor?: string, dispatchEvent?: boolean): anychart.charts.Stock;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Stock;
        startZoomMarquee(repeat?: boolean, asRect?: boolean): anychart.charts.Stock;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Stock;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Stock;
        top(): number | string;
        top(top?: number | string): anychart.charts.Stock;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Stock;
        xScale(): anychart.scales.StockScatterDateTime;
        xScale(settings?: string | Object): anychart.charts.Stock;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Stock;
        zoomMarqueeFill(): anychart.graphics.vector.Fill;
        zoomMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Stock;
        zoomMarqueeFill(color: string, opacity?: number): anychart.charts.Stock;
        zoomMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Stock;
        zoomMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Stock;
        zoomMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Stock;
        zoomMarqueeStroke(): anychart.graphics.vector.Stroke;
        zoomMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Stock;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Stock;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Stock;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Stock;
    }
    namespace Stock {
    type SelectedRange = {
        firstSelected: number;
        firstVisible: number;
        lastSelected: number;
        lastVisible: number;
    }
    }
    interface Resource extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Resource;
        activities(): anychart.core.resource.Activities;
        activities(settings?: Object): anychart.charts.Resource;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Resource;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Resource;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Resource;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Resource;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Resource;
        calendar(): anychart.scales.Calendar;
        calendar(settings?: Object): anychart.charts.Resource;
        cancelMarquee(): anychart.charts.Resource;
        cellPadding(): anychart.core.utils.Padding;
        cellPadding(padding?: Array<number|string> | Object): anychart.charts.Resource;
        cellPadding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Resource;
        conflicts(): anychart.core.resource.Conflicts;
        conflicts(settings?: Object): anychart.charts.Resource;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Resource;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Resource;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Resource;
        currentStartDate(): Date | number | string;
        currentStartDate(date: Date | number | string): anychart.charts.Resource;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Resource;
        defaultMinutesPerDay(): number;
        defaultMinutesPerDay(minutes?: number): anychart.charts.Resource;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Resource;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Resource;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Resource;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Resource;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        grid(): anychart.core.resource.Grid;
        grid(settings?: Object | boolean): anychart.charts.Resource;
        height(): number | string;
        height(height?: number | string): anychart.charts.Resource;
        horizontalScrollBar(): anychart.core.ui.Scroller;
        horizontalScrollBar(settings?: Object | boolean): anychart.charts.Resource;
        hover(resourceIndex: number, activityIndex: number): anychart.charts.Resource;
        hoverPoint(globalIndex: number): anychart.charts.Resource;
        id(): string;
        id(id?: string): anychart.charts.Resource;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Resource;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Resource;
        left(): number | string;
        left(value?: number | string): anychart.charts.Resource;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        logo(): anychart.core.resource.Logo;
        logo(settings?: Object): anychart.charts.Resource;
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Resource;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): void;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Resource;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Resource;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Resource;
        minRowHeight(): number;
        minRowHeight(height?: number): anychart.charts.Resource;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Resource;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Resource;
        overlay(): anychart.core.gantt.Overlay;
        overlay(settings?: Object | boolean): anychart.charts.Resource;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Resource;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Resource;
        pixPerHour(): number;
        pixPerHour(height?: number): anychart.charts.Resource;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        resourceList(): anychart.core.resource.ResourceList;
        resourceList(settings?: Object | boolean): anychart.charts.Resource;
        resourceListWidth(): number | string;
        resourceListWidth(width?: number | string): anychart.charts.Resource;
        right(): number | string;
        right(right?: number | string): anychart.charts.Resource;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(resourceIndex: number, activityIndex: number): anychart.charts.Resource;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Resource;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Resource;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Resource;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Resource;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Resource;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Resource;
        selectPoint(globalIndex: number, event?: anychart.core.MouseEvent): anychart.charts.Resource;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        splitterStroke(): anychart.graphics.vector.Stroke;
        splitterStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Resource;
        startSelectMarquee(repeat?: boolean): anychart.charts.Resource;
        timeLine(): anychart.core.gantt.TimeLineHeader;
        timeLine(settings?: Object | boolean): anychart.charts.Resource;
        timeLineHeight(): number | string;
        timeLineHeight(height?: number | string): anychart.charts.Resource;
        timeTrackingMode(): string;
        timeTrackingMode(mode?: string): anychart.charts.Resource;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Resource;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Resource;
        top(): number | string;
        top(top?: number | string): anychart.charts.Resource;
        unhover(resourceIndex?: number | Array<number>, activityIndex?: number): anychart.charts.Resource;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(resourceIndex?: number | Array<number>, activityIndex?: number): void;
        verticalScrollBar(): anychart.core.ui.Scroller;
        verticalScrollBar(settings?: Object | boolean): anychart.charts.Resource;
        width(): number | string;
        width(width?: number | string): anychart.charts.Resource;
        xScale(): anychart.scales.DateTimeWithCalendar;
        xScale(settings?: Object): anychart.charts.Resource;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Resource;
        zoomLevel(): number | string;
        zoomLevel(indexOrId?: number | string): anychart.charts.Resource;
        zoomLevels(): Array<anychart.charts.Resource.ZoomLevel>;
        zoomLevels(levelsSettings?: Array<anychart.charts.Resource.ZoomLevel>): anychart.charts.Resource;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Resource;
        animation(enabled: boolean, duration: number): anychart.charts.Resource;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Resource;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Resource;
    }
    namespace Resource {
    type ZoomLevel = {
        count: number;
        id: string;
        levels: Array<anychart.core.gantt.TimeLineHeader.LevelWrapper>;
        unit: string;
        unitPixSize: number;
    }
    }
    interface Wordtree extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Wordtree;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Wordtree;
        animation(enabled: boolean, duration: number): anychart.charts.Wordtree;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Wordtree;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Wordtree;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Wordtree;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Wordtree;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Wordtree;
        cancelMarquee(): anychart.charts.Wordtree;
        connectors(): anychart.core.wordtree.Connectors;
        connectors(settings?: Object): anychart.charts.Wordtree;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Wordtree;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Wordtree;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Wordtree;
        data(): anychart.data.Tree;
        data(data?: string | Array<Array<string>|string|anychart.data.Tree>): anychart.charts.Wordtree;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Wordtree;
        drillTo(Target: anychart.data.Tree.DataItem | string): void;
        drillUp(): anychart.charts.Wordtree;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Wordtree;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Wordtree;
        fontColor(): string;
        fontColor(color?: string): anychart.charts.Wordtree;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(type?: anychart.graphics.vector.Text.Decoration | string): anychart.charts.Wordtree;
        fontFamily(): string;
        fontFamily(fontFamily?: string): anychart.charts.Wordtree;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.charts.Wordtree;
        fontStyle(): anychart.graphics.vector.Text.FontStyle;
        fontStyle(style?: string | anychart.graphics.vector.Text.FontStyle): anychart.charts.Wordtree;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.charts.Wordtree;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Wordtree;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Wordtree;
        id(): string;
        id(id?: string): anychart.charts.Wordtree;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Wordtree;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Wordtree;
        left(): number | string;
        left(value?: number | string): anychart.charts.Wordtree;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Wordtree;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Wordtree;
        maxFontSize(): number;
        maxFontSize(size?: number | string): anychart.charts.Wordtree;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Wordtree;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Wordtree;
        minFontSize(): number;
        minFontSize(size?: number | string): anychart.charts.Wordtree;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Wordtree;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Wordtree;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Wordtree;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Wordtree;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Wordtree;
        postfix(): string;
        postfix(text?: string): anychart.charts.Wordtree;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Wordtree;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Wordtree;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Wordtree;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Wordtree;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Wordtree;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Wordtree;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Wordtree;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Wordtree;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Wordtree;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Wordtree;
        top(): number | string;
        top(top?: number | string): anychart.charts.Wordtree;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Wordtree;
        word(): string;
        word(word?: string): anychart.charts.Wordtree;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Wordtree;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Wordtree;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Wordtree;
    }
    interface Sparkline extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Sparkline;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Sparkline;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Sparkline;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Sparkline;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Sparkline;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Sparkline;
        clip(): boolean | anychart.math.Rect;
        clip(value?: anychart.math.Rect): anychart.charts.Sparkline;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.charts.Sparkline;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Sparkline;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Sparkline;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Sparkline;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Sparkline;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Sparkline;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Sparkline;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Sparkline;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        fill(color: string, opacity?: number): anychart.charts.Sparkline;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        firstFill(): anychart.graphics.vector.Fill;
        firstFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        firstFill(color: string, opacity?: number): anychart.charts.Sparkline;
        firstFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        firstFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        firstFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        firstHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        firstHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        firstHatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        firstHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        firstHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        firstHatchFill(enabled?: boolean): anychart.charts.Sparkline;
        firstLabels(): anychart.core.ui.LabelsFactory.Label;
        firstLabels(settings?: Object | boolean): anychart.charts.Sparkline;
        firstMarkers(): anychart.core.ui.MarkersFactory.Marker;
        firstMarkers(settings?: Object | boolean): anychart.charts.Sparkline;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Sparkline;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        hatchFill(enabled?: boolean): anychart.charts.Sparkline;
        height(): number | string;
        height(height?: number | string): anychart.charts.Sparkline;
        id(): string;
        id(id?: string): anychart.charts.Sparkline;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Sparkline;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Sparkline;
        labels(): anychart.core.ui.LabelsFactory.Label;
        labels(settings?: Object | boolean): anychart.charts.Sparkline;
        lastFill(): anychart.graphics.vector.Fill;
        lastFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        lastFill(color: string, opacity?: number): anychart.charts.Sparkline;
        lastFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        lastFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        lastFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        lastHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        lastHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        lastHatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        lastHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        lastHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        lastHatchFill(enabled?: boolean): anychart.charts.Sparkline;
        lastLabels(): anychart.core.ui.LabelsFactory.Label;
        lastLabels(settings?: Object | boolean): anychart.charts.Sparkline;
        lastMarkers(): anychart.core.ui.MarkersFactory.Marker;
        lastMarkers(settings?: Object | boolean): anychart.charts.Sparkline;
        left(): number | string;
        left(value?: number | string): anychart.charts.Sparkline;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Sparkline;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Sparkline;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Sparkline;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Sparkline;
        markers(): anychart.core.ui.MarkersFactory.Marker;
        markers(settings?: Object | boolean): anychart.charts.Sparkline;
        maxFill(): anychart.graphics.vector.Fill;
        maxFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        maxFill(color: string, opacity?: number): anychart.charts.Sparkline;
        maxFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        maxFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        maxFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        maxHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        maxHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        maxHatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        maxHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        maxHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        maxHatchFill(enabled?: boolean): anychart.charts.Sparkline;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Sparkline;
        maxLabels(): anychart.core.ui.LabelsFactory.Label;
        maxLabels(settings?: Object | boolean): anychart.charts.Sparkline;
        maxMarkers(): anychart.core.ui.MarkersFactory.Marker;
        maxMarkers(settings?: Object | boolean): anychart.charts.Sparkline;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Sparkline;
        minFill(): anychart.graphics.vector.Fill;
        minFill(color: anychart.graphics.vector.Fill | string | Array<any>): anychart.charts.Sparkline;
        minFill(color: string, opacity?: number): anychart.charts.Sparkline;
        minFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        minFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        minFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        minHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        minHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        minHatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        minHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        minHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        minHatchFill(enabled?: boolean): anychart.charts.Sparkline;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Sparkline;
        minLabels(): anychart.core.ui.LabelsFactory.Label;
        minLabels(settings?: Object | boolean): anychart.charts.Sparkline;
        minMarkers(): anychart.core.ui.MarkersFactory.Marker;
        minMarkers(settings?: Object | boolean): anychart.charts.Sparkline;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Sparkline;
        negativeFill(): anychart.graphics.vector.Fill;
        negativeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        negativeFill(color: string, opacity?: number): anychart.charts.Sparkline;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        negativeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        negativeHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        negativeHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Sparkline;
        negativeHatchFill(hatchFillFunction?: (() => void)): anychart.charts.Sparkline;
        negativeHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Sparkline;
        negativeHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Sparkline;
        negativeHatchFill(enabled?: boolean): anychart.charts.Sparkline;
        negativeLabels(): anychart.core.ui.LabelsFactory.Label;
        negativeLabels(settings?: Object | boolean): anychart.charts.Sparkline;
        negativeMarkers(): anychart.core.ui.MarkersFactory.Marker;
        negativeMarkers(settings?: Object | boolean): anychart.charts.Sparkline;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Sparkline;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Sparkline;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Sparkline;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.charts.Sparkline;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Sparkline;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Sparkline;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(value?: number | string): anychart.charts.Sparkline;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        seriesType(): string;
        seriesType(type?: string): anychart.charts.Sparkline;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Sparkline;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Sparkline;
        stroke(settings?: Object): anychart.charts.Sparkline;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Sparkline;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Sparkline;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Sparkline;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Sparkline;
        top(): number | string;
        top(top?: number | string): anychart.charts.Sparkline;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Sparkline;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: string | anychart.scales.Base | Object): anychart.charts.Sparkline;
        yScale(): anychart.scales.Base;
        yScale(settings?: string | anychart.scales.Base | Object): anychart.charts.Sparkline;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Sparkline;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Sparkline;
        animation(enabled: boolean, duration: number): anychart.charts.Sparkline;
        cancelMarquee(): anychart.charts.Sparkline;
        getSelectedPoints(): Array<anychart.core.Point>;
        inMarquee(): boolean;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sparkline;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Sparkline;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sparkline;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sparkline;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sparkline;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Sparkline;
        startSelectMarquee(repeat?: boolean): anychart.charts.Sparkline;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Sparkline;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Sparkline;
    }
    interface Radar extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Radar;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.radar.series.Base>;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Radar;
        animation(enabled: boolean, duration: number): anychart.charts.Radar;
        area(data: anychart.data.View | anychart.data.Set | Array<any>, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.radar.series.Area;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Radar;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Radar;
        baseline(): number;
        baseline(value?: number): anychart.charts.Radar;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Radar;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Radar;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Radar;
        cancelMarquee(): anychart.charts.Radar;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Radar;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Radar;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Radar;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Radar;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Radar;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Radar;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Radar;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Radar;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Radar;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSeries(id: number | string): anychart.core.radar.series.Base;
        getSeriesAt(index: number): anychart.core.radar.series.Base;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXScales(): Array<any>;
        getYScales(): Array<any>;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Radar;
        height(): number | string;
        height(height?: number | string): anychart.charts.Radar;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Radar;
        id(): string;
        id(id?: string): anychart.charts.Radar;
        inMarquee(): boolean;
        innerRadius(): number | string;
        innerRadius(radius?: number | string): anychart.charts.Radar;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Radar;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Radar;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Radar;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Radar;
        left(): number | string;
        left(value?: number | string): anychart.charts.Radar;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Radar;
        line(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.radar.series.Line;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Radar;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): void;
        marker(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.radar.series.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Radar;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Radar;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Radar;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Radar;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Radar;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Radar;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Radar;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Radar;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Radar;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Radar;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Radar;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Radar;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Radar;
        removeSeries(id: number | string): anychart.charts.Radar;
        removeSeriesAt(index: number): anychart.charts.Radar;
        right(): number | string;
        right(right?: number | string): anychart.charts.Radar;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Radar;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Radar;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Radar;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Radar;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Radar;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Radar;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Radar;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startAngle(): string | number;
        startAngle(angle?: string | number): anychart.charts.Radar;
        startSelectMarquee(repeat?: boolean): anychart.charts.Radar;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Radar;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Radar;
        top(): number | string;
        top(top?: number | string): anychart.charts.Radar;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Radar;
        xAxis(): anychart.core.axes.Radar;
        xAxis(settings?: Object | boolean): anychart.charts.Radar;
        xGrid(index?: number): anychart.core.grids.Radar;
        xGrid(settings?: Object | boolean): anychart.charts.Radar;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.Radar;
        xMinorGrid(index?: number): anychart.core.grids.Radar;
        xMinorGrid(settings?: Object | boolean): anychart.charts.Radar;
        xMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Radar;
        xScale(): anychart.scales.Ordinal;
        xScale(scale?: anychart.scales.Ordinal): anychart.charts.Radar;
        yAxis(): anychart.core.axes.Radar;
        yAxis(settings?: Object | boolean): anychart.charts.Radar;
        yGrid(index?: number): anychart.core.grids.Radar;
        yGrid(settings?: Object | boolean): anychart.charts.Radar;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.Radar;
        yMinorGrid(index?: number): anychart.core.grids.Radar;
        yMinorGrid(settings?: Object | boolean): anychart.charts.Radar;
        yMinorGrid(index?: number, settings?: Object | boolean): anychart.charts.Radar;
        yScale(): anychart.scales.Linear;
        yScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Radar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Radar;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Radar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Radar;
    }
    interface LinearGauge extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.LinearGauge;
        addPointer(...var_args: (number | Array<any> | anychart.data.Set | anychart.data.View)[]): Array<anychart.core.linearGauge.pointers.Base>;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.LinearGauge;
        axis(index?: number): anychart.core.axes.LinearGauge;
        axis(settings?: Object | boolean): anychart.charts.LinearGauge;
        axis(index?: number, settings?: Object | boolean): anychart.charts.LinearGauge;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.LinearGauge;
        bar(dataIndex: number): anychart.core.linearGauge.pointers.Bar;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.LinearGauge;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.LinearGauge;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.LinearGauge;
        cancelMarquee(): anychart.charts.LinearGauge;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.LinearGauge;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.LinearGauge;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.LinearGauge;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.LinearGauge;
        defaultPointerType(): string;
        defaultPointerType(type?: string): anychart.charts.LinearGauge;
        dispose(): void;
        draw(async?: boolean): anychart.charts.LinearGauge;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.LinearGauge;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.LinearGauge;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.LinearGauge;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPointer(id: number | string): anychart.core.linearGauge.pointers.Base;
        getPointerAt(index: number): anychart.core.linearGauge.pointers.Base;
        getPointersCount(): number;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalOffset(): string | number;
        globalOffset(offset?: string | number): anychart.charts.LinearGauge;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.LinearGauge;
        height(): number | string;
        height(height?: number | string): anychart.charts.LinearGauge;
        id(): string;
        id(id?: string): anychart.charts.LinearGauge;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(value?: boolean): anychart.charts.LinearGauge;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.LinearGauge;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.LinearGauge;
        layout(): string;
        layout(layout?: string): anychart.charts.LinearGauge;
        led(dataIndex: number): anychart.core.linearGauge.pointers.Led;
        left(): number | string;
        left(value?: number | string): anychart.charts.LinearGauge;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.LinearGauge;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.LinearGauge;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.LinearGauge;
        marker(dataIndex: number): anychart.core.linearGauge.pointers.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.LinearGauge;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.LinearGauge;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.LinearGauge;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.LinearGauge;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.LinearGauge;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.LinearGauge;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.LinearGauge;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.LinearGauge;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.LinearGauge;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeBar(dataIndex: number): anychart.core.linearGauge.pointers.RangeBar;
        removeAllListeners(type?: string): number;
        removeAllPointers(): anychart.charts.LinearGauge;
        removePointer(id: number | string): anychart.charts.LinearGauge;
        removePointerAt(index: number): anychart.charts.LinearGauge;
        right(): number | string;
        right(right?: number | string): anychart.charts.LinearGauge;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scale(): anychart.scales.ScatterBase;
        scale(settings?: string | anychart.scales.ScatterBase | Object): anychart.charts.LinearGauge;
        scaleBar(index?: number): anychart.core.linearGauge.ScaleBar;
        scaleBar(settings?: Object | boolean): anychart.charts.LinearGauge;
        scaleBar(index?: number, settings?: Object | boolean): anychart.charts.LinearGauge;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.LinearGauge;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.LinearGauge;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.LinearGauge;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.LinearGauge;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.LinearGauge;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.LinearGauge;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.LinearGauge;
        tank(dataIndex: number): anychart.core.linearGauge.pointers.Tank;
        thermometer(dataIndex: number): anychart.core.linearGauge.pointers.Thermometer;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.LinearGauge;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.LinearGauge;
        top(): number | string;
        top(top?: number | string): anychart.charts.LinearGauge;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.LinearGauge;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.LinearGauge;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.LinearGauge;
        animation(enabled: boolean, duration: number): anychart.charts.LinearGauge;
        getStat(key?: string): any;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.LinearGauge;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.LinearGauge;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.LinearGauge;
    }
    interface HeatMap extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.HeatMap;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.HeatMap;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.HeatMap;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.HeatMap;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.HeatMap;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.HeatMap;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.HeatMap;
        cancelMarquee(): anychart.charts.HeatMap;
        colorScale(): anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.OrdinalColor | Object | string): anychart.charts.HeatMap;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.HeatMap;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.HeatMap;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.HeatMap;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string | anychart.data.DataSettings, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.HeatMap;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.HeatMap;
        dispose(): void;
        draw(async?: boolean): anychart.charts.HeatMap;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.HeatMap;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.HeatMap;
        fill(): anychart.graphics.vector.Fill | (() => void);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.HeatMap;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.HeatMap;
        fill(color: string, opacity?: number): anychart.charts.HeatMap;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.HeatMap;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.HeatMap;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.HeatMap;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.HeatMap;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.HeatMap;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.HeatMap;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.HeatMap;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.HeatMap;
        hatchFill(enabled?: boolean): anychart.charts.HeatMap;
        height(): number | string;
        height(height?: number | string): anychart.charts.HeatMap;
        hover(indexOrIndexes?: number | Array<number>): anychart.charts.HeatMap;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.HeatMap;
        id(): string;
        id(id?: string): anychart.charts.HeatMap;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.HeatMap;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.HeatMap;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.HeatMap;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.HeatMap;
        labelsDisplayMode(): string;
        labelsDisplayMode(mode?: string): anychart.charts.HeatMap;
        left(): number | string;
        left(value?: number | string): anychart.charts.HeatMap;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.HeatMap;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.HeatMap;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.HeatMap;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.charts.HeatMap;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.HeatMap;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.HeatMap;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.HeatMap;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.HeatMap;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.HeatMap;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.HeatMap;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.HeatMap;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.HeatMap;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.HeatMap;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(index?: number): anychart.charts.HeatMap;
        select(indexes?: Array<number>): anychart.charts.Funnel;
        select(): anychart.charts.Funnel;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.HeatMap;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.HeatMap;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.HeatMap;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.HeatMap;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.HeatMap;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.HeatMap;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.HeatMap;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.HeatMap;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(value?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.HeatMap;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.HeatMap;
        stroke(settings?: Object): anychart.charts.HeatMap;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.HeatMap;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.HeatMap;
        top(): number | string;
        top(top?: number | string): anychart.charts.HeatMap;
        unhover(): anychart.charts.HeatMap;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(indexOrIndexes?: number | Array<number>): void;
        width(): number | string;
        width(width?: number | string): anychart.charts.HeatMap;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.HeatMap;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.HeatMap;
        xGrid(index?: number): anychart.core.grids.Linear;
        xGrid(settings?: Object | boolean): anychart.charts.HeatMap;
        xGrid(index?: number, settings?: Object | boolean): anychart.charts.HeatMap;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: string | anychart.scales.Ordinal): anychart.charts.HeatMap;
        xScroller(): anychart.core.ui.ChartScroller;
        xScroller(settings?: Object | boolean): anychart.charts.HeatMap;
        xZoom(): anychart.core.utils.OrdinalZoom;
        xZoom(settings?: number | boolean | Object): anychart.charts.HeatMap;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.HeatMap;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.HeatMap;
        yGrid(index?: number): anychart.core.grids.Linear;
        yGrid(settings?: Object | boolean): anychart.charts.HeatMap;
        yGrid(index?: number, settings?: Object | boolean): anychart.charts.HeatMap;
        yScale(): anychart.scales.Ordinal;
        yScale(settings?: string | anychart.scales.Ordinal): anychart.charts.HeatMap;
        yScroller(): anychart.core.ui.ChartScroller;
        yScroller(settings?: Object | boolean): anychart.charts.HeatMap;
        yZoom(): anychart.core.utils.OrdinalZoom;
        yZoom(settings?: number | boolean | Object): anychart.charts.HeatMap;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.HeatMap;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.HeatMap;
        animation(enabled: boolean, duration: number): anychart.charts.HeatMap;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.HeatMap;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.HeatMap;
    }
    interface Gantt extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Gantt;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Gantt;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Gantt;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Gantt;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Gantt;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Gantt;
        collapseAll(): anychart.charts.Gantt;
        collapseTask(taskId: string): anychart.charts.Gantt;
        columnStroke(): string | anychart.graphics.vector.Stroke;
        columnStroke(color?: anychart.graphics.vector.Stroke | string): anychart.charts.Gantt;
        columnStroke(settings?: Object): anychart.charts.Gantt;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Gantt;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Gantt;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.charts.Gantt;
        data(): anychart.data.Tree | anychart.data.TreeView;
        data(data?: anychart.data.Tree | anychart.data.TreeView | Array<Object>, fillMethod?: string): anychart.charts.Gantt;
        dataGrid(): anychart.core.ui.DataGrid;
        dataGrid(enabled?: boolean): anychart.charts.Gantt;
        defaultRowHeight(): number;
        defaultRowHeight(height?: number): anychart.charts.Gantt;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Gantt;
        edit(): anychart.core.gantt.edit.StructureEdit;
        edit(settings?: Object | boolean): anychart.charts.Gantt;
        editing(): boolean;
        editing(value?: boolean): anychart.charts.Gantt;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Gantt;
        expandAll(): anychart.charts.Gantt;
        expandTask(taskId: string): anychart.charts.Gantt;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Gantt;
        fitAll(): anychart.charts.Gantt;
        fitToTask(taskId: string): anychart.charts.Gantt;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Gantt;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getTimeline(): anychart.core.ui.Timeline;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        headerHeight(): number | string;
        headerHeight(height?: number | string): anychart.charts.Gantt;
        height(): number | string;
        height(height?: number | string): anychart.charts.Gantt;
        id(): string;
        id(id?: string): anychart.charts.Gantt;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Gantt;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Gantt;
        left(): number | string;
        left(left?: number | string): anychart.charts.Gantt;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Gantt;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Gantt;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Gantt;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Gantt;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Gantt;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Gantt;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Gantt;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Gantt;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Gantt;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(paletteSettings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Gantt;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Gantt;
        rowHoverFill(): anychart.graphics.vector.Fill | string;
        rowHoverFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Gantt;
        rowHoverFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Gantt;
        rowHoverFill(color: string, opacity?: number): anychart.charts.Gantt;
        rowHoverFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Gantt;
        rowHoverFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Gantt;
        rowSelectedFill(): anychart.graphics.vector.Fill | string;
        rowSelectedFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Gantt;
        rowSelectedFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Gantt;
        rowSelectedFill(color: string, opacity?: number): anychart.charts.Gantt;
        rowSelectedFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Gantt;
        rowSelectedFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Gantt;
        rowStroke(): string | anychart.graphics.vector.Stroke;
        rowStroke(color?: anychart.graphics.vector.Stroke | string): anychart.charts.Gantt;
        rowStroke(settings?: Object): anychart.charts.Gantt;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scrollTo(): number;
        scrollTo(pxValue: number): anychart.charts.Gantt;
        scrollToEnd(index?: number): anychart.charts.Gantt;
        scrollToRow(rowIndex: number): anychart.charts.Gantt;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        splitterPosition(): number | string;
        splitterPosition(position?: string | number): anychart.charts.Gantt;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Gantt;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        top(): number | string;
        top(top?: number | string): anychart.charts.Gantt;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Gantt;
        xScale(): anychart.scales.GanttDateTime;
        xScale(settings?: Object): anychart.charts.Gantt;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Gantt;
        zoomIn(zoomFactor?: number): anychart.charts.Gantt;
        zoomOut(zoomFactor?: number): anychart.charts.Gantt;
        zoomTo(startDate: number, endDate?: number): anychart.charts.Gantt;
        zoomTo(unit: string, count?: number, anchor?: string): anychart.charts.Gantt;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Gantt;
        animation(enabled: boolean, duration: number): anychart.charts.Gantt;
        cancelMarquee(): anychart.charts.Gantt;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Gantt;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Gantt;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Gantt;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Gantt;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Gantt;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Gantt;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Gantt;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Gantt;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Gantt;
        startSelectMarquee(repeat?: boolean): anychart.charts.Gantt;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Gantt;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Gantt;
    }
    interface Graph extends anychart.core.Chart {
        data(): Object;
        data(data?: Object): anychart.charts.Graph;
        edges(): anychart.core.graph.elements.Edge;
        edges(value?: Object): anychart.charts.Graph;
        fit(): anychart.charts.Graph;
        group(id: string): anychart.core.graph.elements.Group;
        group(id: string, value: Object): anychart.charts.Graph;
        interactivity(): anychart.core.graph.elements.Interactivity;
        interactivity(value: Object): anychart.charts.Graph;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value: Object | string): anychart.charts.Graph;
        layout(): anychart.core.graph.elements.Layout;
        layout(value: Object | string): anychart.charts.Graph;
        move(): Array<number>;
        move(dx?: number, dy?: number): anychart.charts.Graph;
        nodes(): anychart.core.graph.elements.Node;
        nodes(value?: Object): anychart.charts.Graph;
        rotation(): number;
        rotation(degree: number): anychart.charts.Graph;
        zoom(): number;
        zoom(value: number, cx?: number, cy?: number): anychart.charts.Graph;
        zoomIn(): anychart.charts.Graph;
        zoomOut(): anychart.charts.Graph;
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Graph;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Graph;
        animation(enabled: boolean, duration: number): anychart.charts.Graph;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Graph;
        background(): anychart.core.ui.Background;
        background(settings?: Object): anychart.charts.Graph;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Graph;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Graph;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Graph;
        cancelMarquee(): anychart.charts.Graph;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Graph;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Graph;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.charts.Graph;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Graph;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Graph;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Graph;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Graph;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Graph;
        id(): string;
        id(id?: string): anychart.charts.Graph;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Graph;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Graph;
        left(): number | string;
        left(left?: number | string): anychart.charts.Graph;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Graph;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Graph;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.charts.Graph;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.charts.Graph;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.charts.Graph;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.charts.Graph;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Graph;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Graph;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Graph;
        right(): number | string;
        right(right?: number | string): anychart.charts.Graph;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number | Object, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSizeOrWidthOrOptions?: number | string | Object, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number | Object, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string | Object, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Graph;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Graph;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Graph;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Graph;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Graph;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Graph;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Graph;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Graph;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string | Object, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Graph;
        top(): number | string;
        top(top?: number | string): anychart.charts.Graph;
        width(): number | string;
        width(width?: number | string): anychart.charts.Graph;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Graph;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Graph;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Graph;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Sankey extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Sankey;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Sankey;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Sankey;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Sankey;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Sankey;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Sankey;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Sankey;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Sankey;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Sankey;
        curveFactor(): number;
        curveFactor(padding?: number): anychart.charts.Sankey;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any>): anychart.charts.Sankey;
        data(csvString?: string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Sankey;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Sankey;
        dropoff(): anychart.core.sankey.elements.Dropoff;
        dropoff(settings?: Object): anychart.charts.Sankey;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Sankey;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Sankey;
        flow(): anychart.core.sankey.elements.Flow;
        flow(settings?: Object): anychart.charts.Sankey;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Sankey;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.charts.Sankey;
        id(): string;
        id(id?: string): anychart.charts.Sankey;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Sankey;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Sankey;
        left(): number | string;
        left(value?: number | string): anychart.charts.Sankey;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Sankey;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): void;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Sankey;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Sankey;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Sankey;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Sankey;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Sankey;
        node(): anychart.core.sankey.elements.Node;
        node(settings?: Object): anychart.charts.Sankey;
        nodePadding(): number;
        nodePadding(padding?: number): anychart.charts.Sankey;
        nodeWidth(): number;
        nodeWidth(width?: number | string): anychart.charts.Sankey;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Sankey;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Sankey;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Sankey;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Sankey;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Sankey;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Sankey;
        top(): number | string;
        top(top?: number | string): anychart.charts.Sankey;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Sankey;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Sankey;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Sankey;
        animation(enabled: boolean, duration: number): anychart.charts.Sankey;
        cancelMarquee(): anychart.charts.Sankey;
        getStat(key?: string): any;
        inMarquee(): boolean;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Sankey;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Sankey;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Sankey;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Sankey;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Sankey;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Sankey;
        startSelectMarquee(repeat?: boolean): anychart.charts.Sankey;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Sankey;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Sankey;
    }
    interface CircularGauge extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.CircularGauge;
        addPointer(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.gauge.pointers.Base>;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.CircularGauge;
        animation(enabled: boolean, duration: number): anychart.charts.CircularGauge;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.CircularGauge;
        axis(index?: number): anychart.core.axes.Circular;
        axis(settings?: Object | boolean): anychart.charts.CircularGauge;
        axis(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.CircularGauge;
        bar(index?: number): anychart.core.gauge.pointers.Bar;
        bar(settings?: Object | boolean): anychart.charts.CircularGauge;
        bar(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.CircularGauge;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.CircularGauge;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.CircularGauge;
        cancelMarquee(): anychart.charts.CircularGauge;
        cap(): anychart.core.gauge.Cap;
        cap(value?: Object | boolean): anychart.charts.CircularGauge;
        circularPadding(): string;
        circularPadding(padding?: number | string): anychart.charts.CircularGauge;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.CircularGauge;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.CircularGauge;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.CircularGauge;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.CircularGauge;
        defaultPointerType(): string;
        defaultPointerType(type?: string): anychart.charts.CircularGauge;
        dispose(): void;
        draw(async?: boolean): anychart.charts.CircularGauge;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.CircularGauge;
        encloseWithStraightLine(): boolean;
        encloseWithStraightLine(enabled?: boolean): anychart.charts.CircularGauge;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.CircularGauge;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.CircularGauge;
        fill(color: string, opacity?: number): anychart.charts.CircularGauge;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.CircularGauge;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.CircularGauge;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.CircularGauge;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.CircularGauge;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPointer(id: number | string): anychart.core.gauge.pointers.Base;
        getPointerAt(index: number): anychart.core.gauge.pointers.Base;
        getPointersCount(): number;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(value?: number | string): anychart.charts.CircularGauge;
        id(): string;
        id(id?: string): anychart.charts.CircularGauge;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        knob(index?: number): anychart.core.gauge.pointers.Knob;
        knob(settings?: Object | boolean): anychart.charts.CircularGauge;
        knob(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.CircularGauge;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.CircularGauge;
        left(): number | string;
        left(left?: number | string): anychart.charts.CircularGauge;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.CircularGauge;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.CircularGauge;
        marker(index?: number): anychart.core.gauge.pointers.Marker;
        marker(settings?: Object | boolean): anychart.charts.CircularGauge;
        marker(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        maxHeight(): number | string;
        maxHeight(value?: number | string): anychart.charts.CircularGauge;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.CircularGauge;
        minHeight(): number | string;
        minHeight(value?: number | string): anychart.charts.CircularGauge;
        minWidth(): number | string;
        minWidth(value?: number | string): anychart.charts.CircularGauge;
        needle(index?: number): anychart.core.gauge.pointers.Needle;
        needle(settings?: Object | boolean): anychart.charts.CircularGauge;
        needle(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.CircularGauge;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.CircularGauge;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.CircularGauge;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        range(index?: number): anychart.core.axisMarkers.CircularRange;
        range(settings?: Object | boolean): anychart.charts.CircularGauge;
        range(index?: number, settings?: Object | boolean): anychart.charts.CircularGauge;
        removeAllListeners(type?: string): number;
        removeAllPointers(): anychart.charts.CircularGauge;
        removePointer(id: number | string): anychart.charts.CircularGauge;
        removePointerAt(index: number): anychart.charts.CircularGauge;
        right(): number | string;
        right(right?: number | string): anychart.charts.CircularGauge;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.CircularGauge;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.CircularGauge;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.CircularGauge;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.CircularGauge;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.CircularGauge;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.CircularGauge;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startAngle(): number;
        startAngle(angle?: string | number): anychart.charts.CircularGauge;
        startSelectMarquee(repeat?: boolean): anychart.charts.CircularGauge;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.CircularGauge;
        stroke(settings?: Object): anychart.charts.CircularGauge;
        sweepAngle(): number;
        sweepAngle(angle?: string | number): anychart.charts.CircularGauge;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.CircularGauge;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.CircularGauge;
        top(): number | string;
        top(top?: number | string): anychart.charts.CircularGauge;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(value?: number | string): anychart.charts.CircularGauge;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.CircularGauge;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.CircularGauge;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.CircularGauge;
    }
    interface Mekko extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Mekko;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.mekko.series.Mekko>;
        annotations(): anychart.core.annotations.PlotController;
        annotations(annotationsList?: Array<any>): anychart.charts.Mekko;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Mekko;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Mekko;
        baseline(): number;
        baseline(value?: number): anychart.charts.Mekko;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Mekko;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Mekko;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Mekko;
        cancelMarquee(): anychart.charts.Mekko;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Mekko;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Mekko;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Mekko;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Mekko;
        data(): anychart.data.View;
        data(data?: anychart.data.Set | anychart.data.DataSettings | Array<any>): anychart.charts.Mekko;
        dataArea(): anychart.core.ui.DataArea;
        dataArea(settings?: Object | boolean): anychart.charts.Mekko;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Mekko;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Mekko;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Mekko;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Mekko;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Mekko;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSeries(id: number | string): anychart.core.mekko.series.Mekko;
        getSeriesAt(index: number): anychart.core.mekko.series.Mekko;
        getSeriesCount(): number;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getXAxesCount(): number;
        getYAxesCount(): number;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Mekko;
        height(): number | string;
        height(height?: number | string): anychart.charts.Mekko;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Mekko;
        id(): string;
        id(id?: string): anychart.charts.Mekko;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string): anychart.charts.Mekko;
        isFullScreenAvailable(): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.charts.Mekko;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Mekko;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Mekko;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Mekko;
        left(): number | string;
        left(value?: number | string): anychart.charts.Mekko;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Mekko;
        lineMarker(index?: number): anychart.core.axisMarkers.Line;
        lineMarker(settings?: Object | boolean): anychart.charts.Mekko;
        lineMarker(index?: number, settings?: Object | boolean): anychart.charts.Mekko;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Mekko;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Mekko;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Mekko;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.charts.Mekko;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Mekko;
        mekko(data: anychart.data.View | anychart.data.Set | Array<any>, csvSettings?: {[prop:string]:string|boolean}): anychart.core.mekko.series.Mekko;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Mekko;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.charts.Mekko;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Mekko;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Mekko;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Mekko;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Mekko;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Mekko;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Mekko;
        pointsPadding(): number;
        pointsPadding(padding?: number): anychart.charts.Mekko;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        rangeMarker(index?: number): anychart.core.axisMarkers.Range;
        rangeMarker(settings?: Object | boolean): anychart.charts.Mekko;
        rangeMarker(index?: number, settings?: Object | boolean): anychart.charts.Mekko;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Mekko;
        removeSeries(id: number | string): anychart.charts.Mekko;
        removeSeriesAt(index: number): anychart.charts.Mekko;
        right(): number | string;
        right(right?: number | string): anychart.charts.Mekko;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Mekko;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Mekko;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Mekko;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Mekko;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Mekko;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Mekko;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Mekko;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Mekko;
        textMarker(index?: number): anychart.core.axisMarkers.Text;
        textMarker(settings?: Object | boolean): anychart.charts.Mekko;
        textMarker(index?: number, settings?: Object | boolean): anychart.charts.Mekko;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Mekko;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Mekko;
        top(): number | string;
        top(top?: number | string): anychart.charts.Mekko;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Mekko;
        xAxis(index?: number): anychart.core.axes.Linear;
        xAxis(settings?: Object | boolean): anychart.charts.Mekko;
        xAxis(index?: number, settings?: Object | boolean): anychart.charts.Mekko;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: Object | string | anychart.scales.Ordinal): anychart.charts.Mekko;
        yAxis(index?: number): anychart.core.axes.Linear;
        yAxis(settings?: Object | boolean): anychart.charts.Mekko;
        yAxis(index?: number, settings?: Object | boolean): anychart.charts.Mekko;
        yScale(): anychart.scales.Base;
        yScale(settings?: Object | string | anychart.scales.Base): anychart.charts.Mekko;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Mekko;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Mekko;
        animation(enabled: boolean, duration: number): anychart.charts.Mekko;
        getSelectedPoints(): Array<anychart.core.Point>;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Mekko;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Mekko;
    }
    interface Pie extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Pie;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Pie;
        animation(enabled: boolean, duration: number): anychart.charts.Pie;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Pie;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Pie;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Pie;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Pie;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Pie;
        cancelMarquee(): anychart.charts.Pie;
        center(): anychart.core.ui.Center;
        center(centerSettings?: Object): anychart.charts.Pie;
        connectorLength(): number | string;
        connectorLength(length?: number | string): anychart.charts.Pie;
        connectorStroke(): anychart.graphics.vector.Stroke;
        connectorStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pie;
        connectorStroke(settings?: Object): anychart.charts.Pie;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Pie;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Pie;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Pie;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Mapping | anychart.data.Set | anychart.data.DataSettings | Array<any>, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Pie;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Pie;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Pie;
        explodeSlice(index: number, explode?: boolean): anychart.charts.Pie;
        explodeSlices(value: boolean): anychart.charts.Pie;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Pie;
        fill(): anychart.graphics.vector.Fill | (()=>anychart.graphics.vector.Fill);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pie;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Pie;
        fill(color: string, opacity?: number): anychart.charts.Pie;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pie;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pie;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pie;
        forceHoverLabels(): boolean;
        forceHoverLabels(enabled?: boolean): anychart.charts.Pie;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Pie;
        getCenterPoint(): anychart.math.CoordinateObject;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPixelExplode(): number;
        getPixelInnerRadius(): number;
        getPixelRadius(): number;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPoint(index: number): anychart.core.PiePoint;
        getSelectedPoints(): Array<anychart.core.PiePoint>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        group(): ((value:any)=>boolean);
        group(settings?: string | ((value:any)=>boolean), name?: string): anychart.charts.Pie;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Pie;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.Pie;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Pie;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Pie;
        hatchFill(enabled?: boolean): anychart.charts.Pie;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Pie;
        height(): number | string;
        height(height?: number | string): anychart.charts.Pie;
        hover(index?: number): anychart.charts.Pie;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Pie;
        id(): string;
        id(id?: string): anychart.charts.Pie;
        inMarquee(): boolean;
        innerRadius(): string | number | ((outerRadius:number)=>number);
        innerRadius(radius?: string | number | ((outerRadius:number)=>number)): anychart.charts.Pie;
        insideLabelsOffset(): number | string;
        insideLabelsOffset(offset?: number | string): anychart.charts.Pie;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Pie;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Pie;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Pie;
        left(): number | string;
        left(value?: number | string): anychart.charts.Pie;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Pie;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Pie;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pie;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Pie;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Pie;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Pie;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Pie;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Pie;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Pie;
        outline(): anychart.core.ui.Outline;
        outline(settings?: Object | boolean | string): anychart.charts.Pie;
        outsideLabelsCriticalAngle(): number | string;
        outsideLabelsCriticalAngle(angle?: number | string): anychart.charts.Pie;
        outsideLabelsSpace(): number | string;
        outsideLabelsSpace(value?: number | string): anychart.charts.Pie;
        overlapMode(): string;
        overlapMode(value?: string | boolean): anychart.charts.Pie;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Pie;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pie;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Pie;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        radius(): string | number;
        radius(radius?: string | number): anychart.charts.Pie;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Pie;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(): anychart.charts.Pie;
        select(index?: number): anychart.charts.Pie;
        select(indexes?: Array<number>): anychart.charts.Pie;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pie;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Pie;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pie;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pie;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pie;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pie;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Pie;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        sort(): string;
        sort(value?: string): anychart.charts.Pie;
        startAngle(): string | number;
        startAngle(angle?: string | number): anychart.charts.Pie;
        startSelectMarquee(repeat?: boolean): anychart.charts.Pie;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(fillFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Pie;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pie;
        stroke(settings?: Object): anychart.charts.Pie;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Pie;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Pie;
        top(): number | string;
        top(top?: number | string): anychart.charts.Pie;
        unhover(): anychart.charts.Pie;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(): anychart.charts.Pie;
        width(): number | string;
        width(width?: number | string): anychart.charts.Pie;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Pie;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Pie;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Pie;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Pie;
    }
    interface Funnel extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Funnel;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Funnel;
        animation(enabled: boolean, duration: number): anychart.charts.Funnel;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Funnel;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Funnel;
        baseWidth(): string | number;
        baseWidth(width?: string | number): anychart.charts.Funnel;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Funnel;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Funnel;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Funnel;
        cancelMarquee(): anychart.charts.Funnel;
        connectorLength(): number | string;
        connectorLength(length?: number | string): anychart.charts.Funnel;
        connectorStroke(): anychart.graphics.vector.Stroke | (() => void);
        connectorStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Funnel;
        connectorStroke(settings?: Object): anychart.charts.Funnel;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Funnel;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Funnel;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Funnel;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Mapping | anychart.data.Set | Array<any> | string | anychart.data.DataSettings, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Funnel;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Funnel;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Funnel;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Funnel;
        fill(): anychart.graphics.vector.Fill | (()=>anychart.graphics.vector.Fill);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Funnel;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.charts.Funnel;
        fill(color: string, opacity?: number): anychart.charts.Funnel;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Funnel;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Funnel;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Funnel;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Funnel;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPoint(index: number): anychart.core.Point;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Funnel;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.Funnel;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Funnel;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Funnel;
        hatchFill(enabled?: boolean): anychart.charts.Funnel;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Funnel;
        height(): number | string;
        height(height?: number | string): anychart.charts.Funnel;
        hover(index?: number): anychart.charts.Funnel;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Funnel;
        id(): string;
        id(id?: string): anychart.charts.Funnel;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Funnel;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Funnel;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Funnel;
        left(): number | string;
        left(value?: number | string): anychart.charts.Funnel;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Funnel;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Funnel;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Funnel;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Funnel;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.charts.Funnel;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Funnel;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Funnel;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Funnel;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Funnel;
        neckHeight(): string | number;
        neckHeight(height?: string | number): anychart.charts.Funnel;
        neckWidth(): string | number;
        neckWidth(width?: string | number): anychart.charts.Funnel;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Funnel;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Funnel;
        overlapMode(): string;
        overlapMode(settings?: string | boolean): anychart.charts.Funnel;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Funnel;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Funnel;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Funnel;
        pointsPadding(): string | number;
        pointsPadding(padding?: string | number): anychart.charts.Funnel;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        right(): number | string;
        right(right?: number | string): anychart.charts.Funnel;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(index?: number): anychart.charts.Funnel;
        select(indexes?: Array<number>): anychart.charts.Funnel;
        select(): anychart.charts.Funnel;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Funnel;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Funnel;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Funnel;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Funnel;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Funnel;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Funnel;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Funnel;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Funnel;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Funnel;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Funnel;
        stroke(settings?: Object): anychart.charts.Funnel;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Funnel;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Funnel;
        top(): number | string;
        top(top?: number | string): anychart.charts.Funnel;
        unhover(): anychart.charts.Funnel;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(): anychart.charts.Funnel;
        width(): number | string;
        width(width?: number | string): anychart.charts.Funnel;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Funnel;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Funnel;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Funnel;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Funnel;
    }
    interface Map extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Map;
        addSeries(...var_args: (anychart.data.View | anychart.data.Set | Array<any>)[]): Array<anychart.core.map.series.Base>;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Map;
        axes(): anychart.core.axes.MapSettings;
        axes(settings?: Object | boolean): anychart.charts.Map;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Map;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Map;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Map;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Map;
        bubble(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.map.series.Bubble;
        callout(index?: number): anychart.core.ui.Callout;
        callout(settings?: Object | boolean): anychart.charts.Map;
        callout(index?: number, settings?: Object | boolean): anychart.charts.Map;
        cancelMarquee(): anychart.charts.Map;
        choropleth(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.map.series.Choropleth;
        colorRange(): anychart.core.ui.ColorRange;
        colorRange(settings?: Object): anychart.charts.Map;
        connector(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.map.series.Connector;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Map;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Map;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Map;
        crosshair(): anychart.core.ui.Crosshair;
        crosshair(settings?: Object | boolean): anychart.charts.Map;
        crs(): Object | (() => void) | string;
        crs(settings: Object | (() => void) | string): anychart.charts.Map;
        crsAnimation(): anychart.core.utils.Animation;
        crsAnimation(settings?: boolean | Object, duration?: number): anychart.charts.Map;
        defaultSeriesType(): string;
        defaultSeriesType(type?: string): anychart.charts.Map;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Map;
        drillDownMap(value?: {[prop:string]:Object|anychart.charts.Map}): Object;
        drillTo(id: string, map?: anychart.charts.Map): anychart.charts.Map;
        drillUp(): anychart.charts.Map;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Map;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Map;
        featureCrs(id: string): string;
        featureCrs(id: string, crs?: string): anychart.charts.Map;
        featureScaleFactor(id: string): number;
        featureScaleFactor(id: string, ratio?: number): anychart.charts.Map;
        featureTranslation(id: string): Array<number>;
        featureTranslation(id: string, dx?: number, dy?: number): anychart.charts.Map;
        fitAll(): anychart.charts.Map;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Map;
        geoData(): Node | string | Object;
        geoData(data?: Node | string | Object): anychart.charts.Map;
        geoIdField(): string;
        geoIdField(id?: string): anychart.charts.Map;
        getCurrentScene(): anychart.charts.Map;
        getDrilldownPath(): Array<anychart.core.MapPoint>;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPlotBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.MapPoint>;
        getSeries(id: number | string): anychart.core.map.series.Base;
        getSeriesAt(index: number): anychart.core.map.series.Base;
        getSeriesCount(): number;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        getZoomLevel(): number;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        grids(): anychart.core.grids.MapSettings;
        grids(settings?: Object | boolean): anychart.charts.Map;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Map;
        height(): number | string;
        height(height?: number | string): anychart.charts.Map;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Map;
        id(): string;
        id(id?: string): anychart.charts.Map;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.MapInteractivity;
        interactivity(settings?: Object | string): anychart.charts.Map;
        inverseTransform(x: number, y: number): {[prop:string]:number};
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Map;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Map;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Map;
        left(): number | string;
        left(value?: number | string): anychart.charts.Map;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Map;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Map;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Map;
        marker(data: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.map.series.Marker;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Map;
        maxBubbleSize(): number | string;
        maxBubbleSize(size?: number | string): anychart.charts.Map;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Map;
        maxWidth(): number | string;
        maxWidth(maxWidth?: number | string): anychart.charts.Map;
        maxZoomLevel(): number;
        maxZoomLevel(value?: number): anychart.charts.Map;
        minBubbleSize(): number | string;
        minBubbleSize(size?: number | string): anychart.charts.Map;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Map;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Map;
        move(dx: number, dy: number): anychart.charts.Map;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Map;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Map;
        overlapMode(): string;
        overlapMode(value?: string | boolean): anychart.charts.Map;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Map;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Map;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Map;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        removeAllSeries(): anychart.charts.Map;
        removeSeries(id: number | string): anychart.charts.Map;
        removeSeriesAt(index: number): anychart.charts.Map;
        right(): number | string;
        right(right?: number | string): anychart.charts.Map;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        scale(): anychart.scales.Geo;
        scale(settings?: anychart.scales.Geo | Object): anychart.scales.Geo;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Map;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Map;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Map;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Map;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Map;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Map;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Map;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Map;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Map;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toGeoJSON(): Object;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Map;
        top(): number | string;
        top(top?: number | string): anychart.charts.Map;
        transform(xLong: number, yLat: number): {[prop:string]:number};
        translateFeature(id: string, dx: number, dy: number): anychart.charts.Map;
        unboundRegions(): anychart.core.utils.UnboundRegionsSettings | string;
        unboundRegions(settings?: Object | string | boolean): anychart.charts.Map;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        width(): number | string;
        width(width?: number | string): anychart.charts.Map;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Map;
        zoom(value: number, cx?: number, cy?: number, duration?: number): anychart.charts.Map;
        zoomIn(duration?: number): anychart.charts.Map;
        zoomOut(duration?: number): anychart.charts.Map;
        zoomTo(value: number, cx?: number, cy?: number): anychart.charts.Map;
        zoomToFeature(id: string): void;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Map;
        animation(enabled: boolean, duration: number): anychart.charts.Map;
        getStat(key?: string): any;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Map;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Map;
    }
    interface Pyramid extends anychart.core.SeparateChart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.charts.Pyramid;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.charts.Pyramid;
        animation(enabled: boolean, duration: number): anychart.charts.Pyramid;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.charts.Pyramid;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.charts.Pyramid;
        baseWidth(): string | number;
        baseWidth(width?: string | number): anychart.charts.Pyramid;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.charts.Pyramid;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.charts.Pyramid;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.charts.Pyramid;
        cancelMarquee(): anychart.charts.Pyramid;
        connectorLength(): number | string;
        connectorLength(length?: number | string): anychart.charts.Pyramid;
        connectorStroke(): anychart.graphics.vector.Stroke | (() => void);
        connectorStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pyramid;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.charts.Pyramid;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.charts.Pyramid;
        credits(): anychart.core.ui.ChartCredits;
        credits(settings?: Object | boolean): anychart.charts.Pyramid;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Mapping | anychart.data.Set | Array<any> | string | anychart.data.DataSettings, csvSettings?: string | anychart.data.TextParsingSettings): anychart.charts.Pyramid;
        dispose(): void;
        draw(async?: boolean): anychart.charts.Pyramid;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.charts.Pyramid;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.charts.Pyramid;
        fill(): anychart.graphics.vector.Fill | (()=>anychart.graphics.vector.Fill);
        fill(fillFunction?: anychart.graphics.vector.Fill | (()=>anychart.graphics.vector.Fill)): anychart.charts.Pyramid;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pyramid;
        fill(color: string, opacity?: number): anychart.charts.Pyramid;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pyramid;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pyramid;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pyramid;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.charts.Pyramid;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getPoint(index: number): anychart.core.Point;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        getType(): string;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.charts.Pyramid;
        hatchFill(hatchFillFunction?: (() => void)): anychart.charts.Pyramid;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.charts.Pyramid;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.charts.Pyramid;
        hatchFill(enabled?: boolean): anychart.charts.Pyramid;
        hatchFillPalette(): anychart.palettes.HatchFills;
        hatchFillPalette(settings?: Array<anychart.graphics.vector.HatchFill.HatchFillType> | Object | anychart.palettes.HatchFills): anychart.charts.Pyramid;
        height(): number | string;
        height(height?: number | string): anychart.charts.Pyramid;
        hover(index?: number): anychart.charts.Pyramid;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.charts.Pyramid;
        id(): string;
        id(id?: string): anychart.charts.Pyramid;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.charts.Pyramid;
        label(index?: string | number, settings?: boolean | Object | string): anychart.charts.Pyramid;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.charts.Pyramid;
        left(): number | string;
        left(value?: number | string): anychart.charts.Pyramid;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.charts.Pyramid;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.charts.Pyramid;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pyramid;
        markerPalette(): anychart.palettes.Markers;
        markerPalette(settings?: anychart.palettes.Markers | Object | Array<string|string>): anychart.charts.Pyramid;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.charts.Pyramid;
        maxHeight(): number | string;
        maxHeight(maxHeight?: number | string): anychart.charts.Pyramid;
        maxWidth(): number | string;
        maxWidth(value?: number | string): anychart.charts.Pyramid;
        minHeight(): number | string;
        minHeight(minHeight?: number | string): anychart.charts.Pyramid;
        minWidth(): number | string;
        minWidth(minWidth?: number | string): anychart.charts.Pyramid;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.charts.Pyramid;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.charts.Pyramid;
        overlapMode(): string;
        overlapMode(settings?: string | boolean): anychart.charts.Pyramid;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.charts.Pyramid;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.charts.Pyramid;
        palette(): anychart.palettes.RangeColors | anychart.palettes.DistinctColors;
        palette(settings?: anychart.palettes.RangeColors | anychart.palettes.DistinctColors | Object | Array<string>): anychart.charts.Pyramid;
        pointsPadding(): string | number;
        pointsPadding(padding?: string | number): anychart.charts.Pyramid;
        print(paperSize?: anychart.graphics.vector.PaperSize, landscape?: boolean): void;
        removeAllListeners(type?: string): number;
        reversed(): boolean;
        reversed(value?: boolean): anychart.charts.Pyramid;
        right(): number | string;
        right(right?: number | string): anychart.charts.Pyramid;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSize?: string, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        select(): anychart.charts.Pyramid;
        select(index?: number): anychart.charts.Pyramid;
        select(indexes?: Array<number>): anychart.charts.Pyramid;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.charts.Pyramid;
        selectMarqueeFill(color: string, opacity?: number): anychart.charts.Pyramid;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.charts.Pyramid;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.charts.Pyramid;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.charts.Pyramid;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pyramid;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.charts.Pyramid;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.charts.Pyramid;
        stroke(): anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill);
        stroke(value?: anychart.graphics.vector.Stroke | (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.charts.Pyramid;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.charts.Pyramid;
        stroke(settings?: Object): anychart.charts.Pyramid;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.charts.Pyramid;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.charts.Pyramid;
        top(): number | string;
        top(top?: number | string): anychart.charts.Pyramid;
        unhover(): anychart.charts.Pyramid;
        unlisten(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
        unselect(): anychart.charts.Pyramid;
        width(): number | string;
        width(width?: number | string): anychart.charts.Pyramid;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.charts.Pyramid;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.charts.Pyramid;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.charts.Pyramid;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.charts.Pyramid;
    }
}

declare namespace anychart.color {
    function bipolarHueProgression(color1?: string, color2?: string, count?: number): Array<string>;
    function blend(rgb1: Array<number>, rgb2: Array<number>, factor: number): anychart.graphics.vector.SolidFill;
    function blendedHueProgression(color1?: string, color2?: string, count?: number): Array<string>;
    function darken(fillOrStroke: anychart.graphics.vector.Fill | anychart.graphics.vector.Stroke, factor?: number): string | anychart.graphics.vector.Fill | anychart.graphics.vector.Stroke;
    function lighten(fillOrStroke: anychart.graphics.vector.Fill | anychart.graphics.vector.Stroke, factor?: number): string | anychart.graphics.vector.Fill | anychart.graphics.vector.Stroke;
    function setOpacity(strokeOrFill: anychart.graphics.vector.Stroke | anychart.graphics.vector.Fill, value: number, isFill?: boolean): anychart.graphics.vector.Stroke | anychart.graphics.vector.Fill;
    function setThickness(stroke: anychart.graphics.vector.Stroke, thickness: number, opacity?: number): anychart.graphics.vector.Stroke;
    function singleHueProgression(color?: string, count?: number, startOrTargetLightness?: number, endLightness?: number): Array<string>;
}

declare namespace anychart.core {
    type MouseEvent = {
        altKey: boolean;
        button: number;
        charCode: number;
        clientX: number;
        clientY: number;
        ctrlKey: boolean;
        currentTarget: anychart.core.VisualBase | anychart.graphics.vector.Element | anychart.graphics.vector.Stage | Node;
        domTarget: anychart.graphics.vector.Element | anychart.graphics.vector.Stage | Node;
        keyCode: number;
        metaKey: boolean;
        offsetX: number;
        offsetY: number;
        platformModifierKey: boolean;
        relatedDomTarget: anychart.graphics.vector.Element | anychart.graphics.vector.Stage | Node;
        relatedTarget: anychart.core.VisualBase | anychart.graphics.vector.Element | anychart.graphics.vector.Stage | Node;
        screenX: number;
        screenY: number;
        shiftKey: boolean;
        target: anychart.core.VisualBase | anychart.graphics.vector.Element | anychart.graphics.vector.Stage | Node;
        type: anychart.graphics.events.EventType;
    }
    interface VisualBase extends anychart.core.Base {
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.VisualBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.VisualBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.VisualBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.VisualBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.VisualBase;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Point {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getIndex(): number;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.Point;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.Point;
        set(field: string, value: any): anychart.core.Point;
    }
    interface StateSettings extends anychart.core.Base {
        adjustFontSize(): number;
        adjustFontSize(adjustOrAdjustByWidth?: boolean | Array<boolean> | Object, adjustByHeight?: boolean): anychart.core.StateSettings;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.core.StateSettings;
        connector(): anychart.core.utils.Connector;
        connector(settings?: Object): anychart.core.StateSettings;
        content(): string | number;
        content(content?: string | number): anychart.core.StateSettings;
        content(func?: ((path:anychart.graphics.vector.Path)=>void)): anychart.core.StateSettings;
        disablePointerEvents(): boolean;
        disablePointerEvents(enabled?: boolean): anychart.core.StateSettings;
        dummyFill(): anychart.graphics.vector.Fill;
        dummyFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        dummyFill(color: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        dummyFill(color: string, opacity?: number): anychart.core.StateSettings;
        dummyFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.StateSettings;
        dummyFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        dummyFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        dummyStroke(): anychart.graphics.vector.Stroke;
        dummyStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        dummyStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        dummyStroke(settings?: Object): anychart.core.StateSettings;
        emptyFill(): anychart.graphics.vector.Fill | (() => void);
        emptyFill(color: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        emptyFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        emptyFill(color: string, opacity?: number): anychart.core.StateSettings;
        emptyHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | boolean;
        emptyHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.StateSettings;
        emptyHatchFill(hatchFillFunction?: (() => void)): anychart.core.StateSettings;
        emptyHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        emptyHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        emptyHatchFill(enabled?: boolean): anychart.core.StateSettings;
        explode(): number | string;
        explode(explode: number | string): anychart.core.StateSettings;
        fallingFill(): anychart.graphics.vector.Fill;
        fallingFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Base;
        fallingFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        fallingFill(color: string, opacity?: number): anychart.core.cartesian.series.Base;
        fallingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Base;
        fallingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Base;
        fallingFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Base;
        fallingHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        fallingHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Base;
        fallingHatchFill(hatchFillFunction?: (() => void)): anychart.core.StateSettings;
        fallingHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        fallingHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        fallingHatchFill(enabled?: boolean): anychart.core.StateSettings;
        fallingStroke(): anychart.graphics.vector.Stroke | (() => void);
        fallingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        fallingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        fallingStroke(settings?: Object): anychart.core.StateSettings;
        fill(): anychart.graphics.vector.Fill | (()=>anychart.graphics.vector.Fill);
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.StateSettings;
        fill(color: string, opacity?: number): anychart.core.StateSettings;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.StateSettings;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        fontColor(): string;
        fontColor(color?: string): anychart.core.StateSettings;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(value?: anychart.graphics.vector.Text.Decoration | string): anychart.core.StateSettings;
        fontFamily(): string;
        fontFamily(family?: string): anychart.core.StateSettings;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.core.StateSettings;
        fontPadding(): number | string;
        fontPadding(padding?: number | string): anychart.core.StateSettings;
        fontSize(): number;
        fontSize(size?: number | string): anychart.core.StateSettings;
        fontStyle(): anychart.graphics.vector.Text.FontStyle | string;
        fontStyle(style?: anychart.graphics.vector.Text.FontStyle | string): anychart.core.StateSettings;
        fontVariant(): anychart.graphics.vector.Text.FontVariant | string;
        fontVariant(value?: anychart.graphics.vector.Text.FontVariant | string): anychart.core.StateSettings;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.core.StateSettings;
        grid(): anychart.graphics.vector.Stroke;
        grid(gridFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        grid(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        hAlign(): anychart.graphics.vector.Text.HAlign | string;
        hAlign(align?: anychart.graphics.vector.Text.HAlign | string): anychart.core.StateSettings;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.StateSettings;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.StateSettings;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        hatchFill(enabled?: boolean): anychart.core.StateSettings;
        headers(): anychart.core.ui.LabelsFactory;
        headers(settings?: Object | boolean): anychart.core.StateSettings;
        height(): string | number;
        height(height?: string | number): anychart.core.StateSettings;
        highFill(): anychart.graphics.vector.Fill;
        highFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.stock.scrollerSeries.Base;
        highFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        highFill(color: string, opacity?: number): anychart.core.stock.scrollerSeries.Base;
        highFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.stock.scrollerSeries.Base;
        highFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        highFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        highHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        highHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.StateSettings;
        highHatchFill(func?: (() => void)): anychart.core.StateSettings;
        highHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        highHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        highHatchFill(enabled?: boolean): anychart.core.StateSettings;
        highStroke(): anychart.graphics.vector.Stroke | (() => void);
        highStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        highStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): Object;
        labels(): anychart.core.ui.LabelsFactory | anychart.core.ui.CircularLabelsFactory;
        labels(settings?: Object | boolean): anychart.core.StateSettings;
        letterSpacing(): string | number;
        letterSpacing(spacing?: string | number): anychart.core.StateSettings;
        lineHeight(): string | number;
        lineHeight(height?: string | number): anychart.core.StateSettings;
        lowFill(): anychart.graphics.vector.Fill;
        lowFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.stock.scrollerSeries.Base;
        lowFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        lowFill(color: string, opacity?: number): anychart.core.stock.scrollerSeries.Base;
        lowFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.stock.scrollerSeries.Base;
        lowFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        lowFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        lowHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        lowHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.StateSettings;
        lowHatchFill(func?: (() => void)): anychart.core.StateSettings;
        lowHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        lowHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        lowHatchFill(enabled?: boolean): anychart.core.StateSettings;
        lowStroke(): anychart.graphics.vector.Stroke | (() => void);
        lowStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        lowStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        lowStroke(settings?: Object): anychart.core.StateSettings;
        lowerLabels(): anychart.core.ui.LabelsFactory;
        lowerLabels(settings?: Object | boolean): anychart.core.StateSettings;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.StateSettings;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.StateSettings;
        medianStroke(): anychart.graphics.vector.Stroke | (() => void);
        medianStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        medianStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        medianStroke(settings?: Object): anychart.core.StateSettings;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.StateSettings;
        negativeFill(): anychart.graphics.vector.Fill;
        negativeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.StateSettings;
        negativeFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        negativeFill(color: string, opacity?: number): anychart.core.StateSettings;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.StateSettings;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        negativeFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        negativeHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        negativeHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.StateSettings;
        negativeHatchFill(hatchFillFunction?: (() => void)): anychart.core.StateSettings;
        negativeHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        negativeHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        negativeHatchFill(enabled?: boolean): anychart.core.StateSettings;
        negativeStroke(): anychart.graphics.vector.Stroke | (() => void);
        negativeStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        negativeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        negativeStroke(settings?: Object): anychart.core.StateSettings;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): Object;
        outlierMarkers(): anychart.core.ui.MarkersFactory;
        outlierMarkers(settings?: Object | boolean | string): anychart.core.StateSettings;
        outline(): anychart.core.ui.Outline;
        outline(settings?: Object): anychart.core.StateSettings;
        risingFill(): anychart.graphics.vector.Fill;
        risingFill(color: anychart.graphics.vector.Fill | string | Array<any>): anychart.core.StateSettings;
        risingFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.StateSettings;
        risingFill(color: string, opacity?: number): anychart.core.StateSettings;
        risingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.StateSettings;
        risingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.StateSettings;
        risingFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.StateSettings;
        risingHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        risingHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.stock.scrollerSeries.Base;
        risingHatchFill(hatchFillFunction?: (() => void)): anychart.core.StateSettings;
        risingHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.StateSettings;
        risingHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.StateSettings;
        risingHatchFill(enabled?: boolean): anychart.core.StateSettings;
        risingStroke(): anychart.graphics.vector.Stroke | (() => void);
        risingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        risingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        risingStroke(settings?: Object): anychart.core.StateSettings;
        selectable(): boolean;
        selectable(enabled?: boolean): anychart.core.StateSettings;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): Object;
        size(): number;
        size(size?: number): anychart.core.StateSettings;
        stemStroke(): anychart.graphics.vector.Stroke | (() => void);
        stemStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        stemStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        stemStroke(settings?: Object): anychart.core.StateSettings;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        stroke(settings?: Object): anychart.core.StateSettings;
        textDirection(): anychart.graphics.vector.Text.Direction | string;
        textDirection(direction?: anychart.graphics.vector.Text.Direction | string): anychart.core.StateSettings;
        textIndent(): number;
        textIndent(indent?: number): anychart.core.StateSettings;
        textOverflow(): anychart.graphics.vector.Text.TextOverflow | string;
        textOverflow(value?: anychart.graphics.vector.Text.TextOverflow | string): anychart.core.StateSettings;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        type(): string | (() => void);
        type(type?: string | (() => void)): anychart.core.StateSettings;
        upperLabels(): anychart.core.ui.LabelsFactory;
        upperLabels(settings?: Object | boolean): anychart.core.StateSettings;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.StateSettings;
        vAlign(): anychart.graphics.vector.Text.VAlign | string;
        vAlign(align?: anychart.graphics.vector.Text.VAlign | string): anychart.core.StateSettings;
        whiskerStroke(): anychart.graphics.vector.Stroke | (() => void);
        whiskerStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.StateSettings;
        whiskerStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.StateSettings;
        whiskerStroke(settings?: Object): anychart.core.StateSettings;
        whiskerWidth(): number | string;
        whiskerWidth(width?: number | string): anychart.core.StateSettings;
        width(): string | number;
        width(width?: string | number): anychart.core.StateSettings;
        wordBreak(): string;
        wordBreak(mode?: string): anychart.core.StateSettings;
        wordWrap(): string;
        wordWrap(mode?: string): anychart.core.StateSettings;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Base {
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface SeparateChart extends anychart.core.Chart {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.core.SeparateChart;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.core.SeparateChart;
        animation(enabled: boolean, duration: number): anychart.core.SeparateChart;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.core.SeparateChart;
        background(): anychart.core.ui.Background;
        background(settings?: Object): anychart.core.SeparateChart;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.SeparateChart;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.SeparateChart;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.SeparateChart;
        cancelMarquee(): anychart.core.SeparateChart;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.SeparateChart;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.core.SeparateChart;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.core.SeparateChart;
        draw(async?: boolean): anychart.core.SeparateChart;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.SeparateChart;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.core.SeparateChart;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.core.SeparateChart;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.core.SeparateChart;
        id(): string;
        id(id?: string): anychart.core.SeparateChart;
        inMarquee(): boolean;
        interactivity(): anychart.core.utils.Interactivity;
        interactivity(settings?: Object | string | boolean): anychart.core.SeparateChart;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.core.SeparateChart;
        label(index?: string | number, settings?: boolean | Object | string): anychart.core.SeparateChart;
        left(): number | string;
        left(left?: number | string): anychart.core.SeparateChart;
        legend(): anychart.core.ui.Legend;
        legend(settings?: Object | boolean): anychart.core.SeparateChart;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.core.SeparateChart;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.SeparateChart;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.SeparateChart;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.SeparateChart;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.SeparateChart;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.SeparateChart;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.core.SeparateChart;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.SeparateChart;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.SeparateChart;
        right(): number | string;
        right(right?: number | string): anychart.core.SeparateChart;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number | Object, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSizeOrWidthOrOptions?: number | string | Object, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number | Object, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string | Object, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.SeparateChart;
        selectMarqueeFill(color: string, opacity?: number): anychart.core.SeparateChart;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.SeparateChart;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.SeparateChart;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.SeparateChart;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.SeparateChart;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.SeparateChart;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string | Object, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.core.SeparateChart;
        top(): number | string;
        top(top?: number | string): anychart.core.SeparateChart;
        width(): number | string;
        width(width?: number | string): anychart.core.SeparateChart;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.SeparateChart;
        dispose(): void;
        startSelectMarquee(repeat?: boolean): anychart.core.SeparateChart;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.SeparateChart;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.SeparateChart;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Chart extends anychart.core.VisualBaseWithBounds {
        a11y(): anychart.core.utils.ChartA11y;
        a11y(settings?: boolean | Object): anychart.core.Chart;
        animation(): anychart.core.utils.Animation;
        animation(settings?: boolean | Object): anychart.core.Chart;
        animation(enabled: boolean, duration: number): anychart.core.Chart;
        autoRedraw(): boolean;
        autoRedraw(enabled?: boolean): anychart.core.Chart;
        background(): anychart.core.ui.Background;
        background(settings?: Object): anychart.core.Chart;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.Chart;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.Chart;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.Chart;
        cancelMarquee(): anychart.core.Chart;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.Chart;
        contextMenu(): anychart.ui.ContextMenu;
        contextMenu(settings?: Object | boolean): anychart.core.Chart;
        credits(): anychart.core.ui.ChartCredits;
        credits(value?: Object | boolean): anychart.core.Chart;
        dispose(): void;
        draw(async?: boolean): anychart.core.Chart;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.Chart;
        exports(): anychart.core.utils.Exports;
        exports(settings?: Object): anychart.core.Chart;
        fullScreen(): boolean;
        fullScreen(enabled?: boolean): anychart.core.Chart;
        getJpgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean): void;
        getPdfBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number): void;
        getPixelBounds(): anychart.math.Rect;
        getPngBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), width?: number, height?: number, quality?: number): void;
        getSelectedPoints(): Array<anychart.core.Point>;
        getStat(key?: string): any;
        getSvgBase64String(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string): void;
        globalToLocal(xCoord: number, yCoord: number): {[prop:string]:number};
        height(): number | string;
        height(height?: number | string): anychart.core.Chart;
        id(): string;
        id(id?: string): anychart.core.Chart;
        inMarquee(): boolean;
        isFullScreenAvailable(): boolean;
        label(index?: string | number): anychart.core.ui.Label;
        label(settings?: boolean | Object | string): anychart.core.Chart;
        label(index?: string | number, settings?: boolean | Object | string): anychart.core.Chart;
        left(): number | string;
        left(left?: number | string): anychart.core.Chart;
        localToGlobal(xCoord: number, yCoord: number): {[prop:string]:number};
        margin(): anychart.core.utils.Margin;
        margin(margin?: Array<number|string> | Object): anychart.core.Chart;
        margin(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.Chart;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.Chart;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.Chart;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.Chart;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.Chart;
        noData(): anychart.core.NoDataSettings;
        noData(settings?: Object): anychart.core.Chart;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.Chart;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.Chart;
        right(): number | string;
        right(right?: number | string): anychart.core.Chart;
        saveAsCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)}, filename?: string): void;
        saveAsJpg(width?: number | Object, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        saveAsJson(filename?: string): void;
        saveAsPdf(paperSizeOrWidthOrOptions?: number | string | Object, landscape?: boolean, x?: number, y?: number, filename?: string): void;
        saveAsPng(width?: number | Object, height?: number, quality?: number, filename?: string): void;
        saveAsSvg(paperSize?: string | Object, landscape?: boolean, filename?: string): void;
        saveAsSvg(width?: number, height?: number): void;
        saveAsXlsx(chartDataExportMode?: string, filename?: string): void;
        saveAsXml(filename?: string): void;
        selectMarqueeFill(): anychart.graphics.vector.Fill;
        selectMarqueeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.Chart;
        selectMarqueeFill(color: string, opacity?: number): anychart.core.Chart;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.Chart;
        selectMarqueeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.Chart;
        selectMarqueeFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.Chart;
        selectMarqueeStroke(): anychart.graphics.vector.Stroke;
        selectMarqueeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.Chart;
        shareAsJpg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, forceTransparentWhite?: boolean, filename?: string): void;
        shareAsPdf(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: number | string, landscapeOrWidth?: number | boolean, x?: number, y?: number, filename?: string): void;
        shareAsPng(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, width?: number, height?: number, quality?: number, filename?: string): void;
        shareAsSvg(onSuccessOrOptions: ((response:string)=>void) | Object, onError?: ((response:string)=>void), asBase64?: boolean, paperSizeOrWidth?: string | number, landscapeOrHeight?: boolean | string, filename?: string): void;
        shareWithFacebook(captionOrOptions?: string | Object, link?: string, name?: string, description?: string): void;
        shareWithLinkedIn(captionOrOptions?: string | Object, description?: string): void;
        shareWithPinterest(linkOrOptions?: string | Object, description?: string): void;
        shareWithTwitter(): void;
        startSelectMarquee(repeat?: boolean): anychart.core.Chart;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.Chart;
        toA11yTable(title?: string, asString?: boolean): Element | string;
        toCsv(chartDataExportMode?: string, csvSettings?: {[prop:string]:string|boolean|((name:any,value:any)=>void)|Object}): string;
        toHtmlTable(title?: string, asString?: boolean): Element | string;
        toJson(stringify?: boolean): Object | string;
        toSvg(paperSize?: string | Object, landscape?: boolean): string;
        toSvg(width?: number, height?: number): string;
        toXml(asXmlNode?: boolean): string | Node;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.core.Chart;
        top(): number | string;
        top(top?: number | string): anychart.core.Chart;
        width(): number | string;
        width(width?: number | string): anychart.core.Chart;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.Chart;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.Chart;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.Chart;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface SeriesPoint extends anychart.core.Point {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getIndex(): number;
        getSeries(): anychart.core.SeriesBase;
        getStackValue(): number;
        getStackZero(): number;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.SeriesPoint;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.SeriesPoint;
        set(field: string, value: any): anychart.core.SeriesPoint;
    }
    interface NoDataSettings extends anychart.core.Base {
        label(): anychart.core.ui.Label;
        label(settings?: Object | string | boolean): anychart.core.NoDataSettings;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface SeriesBase extends anychart.core.VisualBaseWithBounds {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.SeriesBase;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.SeriesBase;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.SeriesBase;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.SeriesBase;
        color(): string;
        color(color: string): anychart.core.SeriesBase;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.SeriesBase;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.SeriesBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.SeriesBase;
        getPixelBounds(): anychart.math.Rect;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.SeriesBase;
        hover(): anychart.core.SeriesBase;
        hover(index?: number): anychart.core.SeriesBase;
        hover(indexes?: Array<number>): anychart.core.SeriesBase;
        hovered(): anychart.core.StateSettings;
        hovered(value?: Object): anychart.core.SeriesBase;
        id(): string | number;
        id(id?: string | number): anychart.core.SeriesBase;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.SeriesBase;
        left(): number | string;
        left(left?: number | string): anychart.core.SeriesBase;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(settings?: Object): anychart.core.SeriesBase;
        markers(): anychart.core.ui.MarkersFactory;
        markers(value?: Object | boolean | string): anychart.core.SeriesBase;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.SeriesBase;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.SeriesBase;
        meta(key?: any): any;
        meta(object?: any, value?: any): anychart.core.SeriesBase;
        meta(key?: any, value?: any): anychart.core.SeriesBase;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.SeriesBase;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.SeriesBase;
        name(): string;
        name(name?: string): anychart.core.SeriesBase;
        normal(): anychart.core.StateSettings;
        normal(value?: Object): anychart.core.SeriesBase;
        right(): number | string;
        right(right?: number | string): anychart.core.SeriesBase;
        select(index?: number): anychart.core.SeriesBase;
        select(indexes?: number | Array<number>): anychart.core.SeriesBase;
        selected(): anychart.core.StateSettings;
        selected(value?: Object): anychart.core.SeriesBase;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.SeriesBase;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.core.SeriesBase;
        top(): number | string;
        top(top?: number | string): anychart.core.SeriesBase;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.SeriesBase;
        unselect(): anychart.core.SeriesBase;
        unselect(index?: number): anychart.core.SeriesBase;
        unselect(indexes?: Array<number>): anychart.core.SeriesBase;
        width(): number | string;
        width(width?: number | string): anychart.core.SeriesBase;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.SeriesBase;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.SeriesBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.SeriesBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.SeriesBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Text extends anychart.core.VisualBase {
        disablePointerEvents(): boolean;
        disablePointerEvents(enabled?: boolean): anychart.core.Text;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.Text;
        fontColor(): string;
        fontColor(color?: string): anychart.core.Text;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(value?: anychart.graphics.vector.Text.Decoration | string): anychart.core.Text;
        fontFamily(): string;
        fontFamily(family?: string): anychart.core.Text;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.core.Text;
        fontSize(): string | number;
        fontSize(size?: string | number): anychart.core.Text;
        fontStyle(): anychart.graphics.vector.Text.FontStyle | string;
        fontStyle(style?: anychart.graphics.vector.Text.FontStyle | string): anychart.core.Text;
        fontVariant(): anychart.graphics.vector.Text.FontVariant | string;
        fontVariant(value?: anychart.graphics.vector.Text.FontVariant | string): anychart.core.Text;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.core.Text;
        hAlign(): anychart.graphics.vector.Text.HAlign | string;
        hAlign(align?: anychart.graphics.vector.Text.HAlign | string): anychart.core.Text;
        letterSpacing(): string | number;
        letterSpacing(spacing?: string | number): anychart.core.Text;
        lineHeight(): string | number;
        lineHeight(height?: string | number): anychart.core.Text;
        selectable(): boolean;
        selectable(enabled?: boolean): anychart.core.Text;
        textDirection(): anychart.graphics.vector.Text.Direction | string;
        textDirection(direction?: anychart.graphics.vector.Text.Direction | string): anychart.core.Text;
        textIndent(): number;
        textIndent(indent?: number): anychart.core.Text;
        textOverflow(): anychart.graphics.vector.Text.TextOverflow | string;
        textOverflow(value?: anychart.graphics.vector.Text.TextOverflow | string): anychart.core.Text;
        textSettings(): Object;
        textSettings(name?: string): string | number | boolean;
        textSettings(objectWithSettings?: Object): anychart.core.Text;
        textSettings(name?: string, settings?: string | number | boolean | (() => void)): anychart.core.Text;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.Text;
        vAlign(): anychart.graphics.vector.Text.VAlign | string;
        vAlign(align?: anychart.graphics.vector.Text.VAlign | string): anychart.core.Text;
        wordBreak(): string;
        wordBreak(mode?: string): anychart.core.Text;
        wordWrap(): string;
        wordWrap(mode?: string): anychart.core.Text;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.Text;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.Text;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.Text;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.Text;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface TreeChartPoint extends anychart.core.Point {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getIndex(): number;
        getNode(): anychart.data.Tree.DataItem | anychart.data.TreeView.DataItem;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.TreeChartPoint;
        selected(): boolean;
        selected(value?: boolean): anychart.core.TreeChartPoint;
        set(field: string, value: any): anychart.core.TreeChartPoint;
    }
    interface VisualBaseWithBounds extends anychart.core.VisualBase {
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.VisualBaseWithBounds;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.VisualBaseWithBounds;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.VisualBaseWithBounds;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.VisualBaseWithBounds;
        getPixelBounds(): anychart.math.Rect;
        height(): number | string;
        height(height?: number | string): anychart.core.VisualBaseWithBounds;
        left(): number | string;
        left(left?: number | string): anychart.core.VisualBaseWithBounds;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.VisualBaseWithBounds;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.VisualBaseWithBounds;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.VisualBaseWithBounds;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.VisualBaseWithBounds;
        right(): number | string;
        right(right?: number | string): anychart.core.VisualBaseWithBounds;
        top(): number | string;
        top(top?: number | string): anychart.core.VisualBaseWithBounds;
        width(): number | string;
        width(width?: number | string): anychart.core.VisualBaseWithBounds;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.VisualBaseWithBounds;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.VisualBaseWithBounds;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.VisualBaseWithBounds;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.VisualBaseWithBounds;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface ChoroplethPoint extends anychart.core.SeriesPoint {
        crs(): string;
        crs(crs?: string): anychart.core.ChoroplethPoint;
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getFeatureBounds(): anychart.math.Rect;
        getFeatureProp(): Object;
        getIndex(): number;
        getSeries(): anychart.core.SeriesBase;
        getStackValue(): number;
        getStackZero(): number;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.ChoroplethPoint;
        middleX(): number;
        middleX(xCoord?: number): anychart.core.ChoroplethPoint;
        middleY(): number;
        middleY(yCoord?: number): anychart.core.ChoroplethPoint;
        scaleFactor(): number;
        scaleFactor(scaleFactor?: number): anychart.core.ChoroplethPoint;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.ChoroplethPoint;
        set(field: string, value: any): anychart.core.ChoroplethPoint;
        translate(dx: number, dy: number): anychart.core.ChoroplethPoint;
        translation(): Array<number>;
        translation(dx?: number, dy?: number): anychart.core.ChoroplethPoint;
    }
    interface PiePoint extends anychart.core.Point {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getEndAngle(): number;
        getIndex(): number;
        getStartAngle(): number;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.PiePoint;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.PiePoint;
        set(field: string, value: any): anychart.core.PiePoint;
    }
    interface BubblePoint extends anychart.core.SeriesPoint {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getIndex(): number;
        getPixelRadius(): number;
        getSeries(): anychart.core.SeriesBase;
        getStackValue(): number;
        getStackZero(): number;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.BubblePoint;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.BubblePoint;
        set(field: string, value: any): anychart.core.BubblePoint;
    }
    interface MapPoint extends anychart.core.Point {
        exists(): boolean;
        get(field: string): any;
        getChart(): anychart.core.SeparateChart;
        getCurrentChart(): anychart.core.SeparateChart;
        getId(): string;
        getIndex(): number;
        getParentChart(): anychart.core.SeparateChart;
        getProperties(): Object;
        getStat(key: string): any;
        hovered(): boolean;
        hovered(enabled?: boolean): anychart.core.MapPoint;
        selected(): boolean;
        selected(enabled?: boolean): anychart.core.MapPoint;
        set(field: string, value: any): anychart.core.MapPoint;
    }
}

declare namespace anychart.core.annotations {
    type AnnotationJSONFormat = {
        allowEdit: boolean;
        anchor: string;
        color: anychart.graphics.vector.AnyColor;
        fill: anychart.graphics.vector.Fill | (() => void);
        grid: anychart.graphics.vector.Stroke | (() => void);
        hatchFill: anychart.graphics.vector.PatternFill | (() => void);
        hoverGap: number;
        hovered: anychart.core.StateSettings;
        markerType: string;
        offsetX: number;
        offsetY: number;
        secondValueAnchor: number;
        secondXAnchor: number;
        selected: anychart.core.StateSettings;
        size: number;
        stroke: anychart.graphics.vector.Stroke | (() => void);
        thirdValueAnchor: number;
        thirdXAnchor: number;
        trend: anychart.graphics.vector.Stroke | (() => void);
        type: string;
        valueAnchor: number;
        xAnchor: number;
    }
    interface Ray extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Ray;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Ray;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Ray;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Ray;
        color(): string;
        color(color: string): anychart.core.annotations.Ray;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Ray;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Ray;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Ray;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Ray;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Ray;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Ray;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Ray;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Ray;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Ray;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Ray;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Ray;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Ray;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.Ray;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.Ray;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Ray;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Ray;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Ray;
        stroke(settings?: Object): anychart.core.annotations.Ray;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Ray;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Ray;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Ray;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Ray;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Ray;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Ray;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Ray;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Ray;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Ray;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Ray;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface InfiniteLine extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.InfiniteLine;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.InfiniteLine;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.InfiniteLine;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.InfiniteLine;
        color(): string;
        color(color: string): anychart.core.annotations.InfiniteLine;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.InfiniteLine;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.InfiniteLine;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.InfiniteLine;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.InfiniteLine;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.InfiniteLine;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.InfiniteLine;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.InfiniteLine;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.InfiniteLine;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.InfiniteLine;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.InfiniteLine;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.InfiniteLine;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.InfiniteLine;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.InfiniteLine;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.InfiniteLine;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.InfiniteLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.InfiniteLine;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.InfiniteLine;
        stroke(settings?: Object): anychart.core.annotations.InfiniteLine;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.InfiniteLine;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.InfiniteLine;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.InfiniteLine;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.InfiniteLine;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.InfiniteLine;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.InfiniteLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.InfiniteLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.InfiniteLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.InfiniteLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.InfiniteLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Label extends anychart.core.annotations.Base {
        adjustFontSize(): Object;
        adjustFontSize(bothOrByWidth?: Object | Array<boolean> | boolean, byHeight?: boolean): anychart.core.annotations.Label;
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Label;
        anchor(): string;
        anchor(anchor?: string): anychart.core.annotations.Label;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.core.annotations.Label;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Label;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Label;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Label;
        disablePointerEvents(): boolean;
        disablePointerEvents(enabled?: boolean): anychart.core.annotations.Label;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Label;
        fontColor(): string;
        fontColor(color?: string): anychart.core.annotations.Label;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(type?: anychart.graphics.vector.Text.Decoration | string): anychart.core.annotations.Label;
        fontFamily(): string;
        fontFamily(fontFamily?: string): anychart.core.annotations.Label;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.core.annotations.Label;
        fontSize(): number;
        fontSize(size?: number | string): anychart.core.annotations.Label;
        fontStyle(): anychart.graphics.vector.Text.FontStyle;
        fontStyle(type?: string | anychart.graphics.vector.Text.FontStyle): anychart.core.annotations.Label;
        fontVariant(): anychart.graphics.vector.Text.FontVariant;
        fontVariant(type?: string | anychart.graphics.vector.Text.FontVariant): anychart.core.annotations.Label;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.core.annotations.Label;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hAlign(): anychart.graphics.vector.Text.HAlign;
        hAlign(type?: string | anychart.graphics.vector.Text.HAlign): anychart.core.annotations.Label;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Label;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Label;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Label;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Label;
        letterSpacing(): number | string;
        letterSpacing(spacing?: number | string): anychart.core.annotations.Label;
        lineHeight(): string | number;
        lineHeight(height?: string | number): anychart.core.annotations.Label;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Label;
        maxFontSize(): number;
        maxFontSize(size?: number | string): anychart.core.annotations.Label;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Label;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Label;
        minFontSize(): number;
        minFontSize(size?: number | string): anychart.core.annotations.Label;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Label;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Label;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Label;
        offsetX(): number | string;
        offsetX(offset?: number | string): anychart.core.annotations.Label;
        offsetY(): number | string;
        offsetY(offset?: number | string): anychart.core.annotations.Label;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.annotations.Label;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.annotations.Label;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Label;
        select(): void;
        selectable(): boolean;
        selectable(enabled?: boolean): anychart.core.annotations.Label;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Label;
        text(): string;
        text(text?: string): anychart.core.annotations.Label;
        textDirection(): anychart.graphics.vector.Text.Direction | string;
        textDirection(type?: anychart.graphics.vector.Text.Direction | string): anychart.core.annotations.Label;
        textIndent(): number;
        textIndent(indent?: number): anychart.core.annotations.Label;
        textOverflow(): anychart.graphics.vector.Text.TextOverflow | string;
        textOverflow(value?: anychart.graphics.vector.Text.TextOverflow | string): anychart.core.annotations.Label;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Label;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.annotations.Label;
        vAlign(): anychart.graphics.vector.Text.VAlign | string;
        vAlign(type?: anychart.graphics.vector.Text.VAlign | string): anychart.core.annotations.Label;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Label;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Label;
        wordBreak(): string;
        wordBreak(type?: string): anychart.core.annotations.Label;
        wordWrap(): string;
        wordWrap(type?: string): anychart.core.annotations.Label;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Line;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Label;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Label;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Label;
        color(): string;
        color(color: string): anychart.core.annotations.Label;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Label;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Label;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Label;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface FibonacciFan extends anychart.core.annotations.FibonacciBase {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.FibonacciFan;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.FibonacciFan;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.FibonacciFan;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.FibonacciFan;
        color(): string;
        color(color: string): anychart.core.annotations.FibonacciFan;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.FibonacciFan;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        grid(): anychart.graphics.vector.Stroke;
        grid(gridFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciFan;
        grid(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciFan;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.FibonacciFan;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.FibonacciFan;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.FibonacciFan;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value?: Object | boolean): anychart.core.annotations.FibonacciFan;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.FibonacciFan;
        levels(): Array<number>;
        levels(levelsList?: Array<any>): anychart.core.annotations.FibonacciFan;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.FibonacciFan;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.FibonacciFan;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.FibonacciFan;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.FibonacciFan;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.FibonacciFan;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.FibonacciFan;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.FibonacciFan;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.FibonacciFan;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.FibonacciFan;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.FibonacciFan;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciFan;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciFan;
        stroke(settings?: Object): anychart.core.annotations.FibonacciFan;
        timeLevels(): Array<number>;
        timeLevels(timeLevelsList?: Array<any>): anychart.core.annotations.FibonacciFan;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.FibonacciFan;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciFan;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciFan;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.FibonacciFan;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.FibonacciFan;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.FibonacciFan;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.FibonacciFan;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.FibonacciFan;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.FibonacciFan;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.FibonacciFan;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.FibonacciFan;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.FibonacciFan;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Rectangle extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Rectangle;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Rectangle;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Rectangle;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Rectangle;
        color(): string;
        color(color: string): anychart.core.annotations.Rectangle;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Rectangle;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.annotations.Rectangle;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.annotations.Rectangle;
        fill(color: string, opacity?: number): anychart.core.annotations.Rectangle;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.annotations.Rectangle;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.annotations.Rectangle;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.annotations.Rectangle;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.annotations.Rectangle;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.annotations.Rectangle;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.annotations.Rectangle;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.annotations.Rectangle;
        hatchFill(enabled?: boolean): anychart.core.annotations.Rectangle;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Rectangle;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Rectangle;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Rectangle;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Rectangle;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Rectangle;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Rectangle;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Rectangle;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Rectangle;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Rectangle;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Rectangle;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Rectangle;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.Rectangle;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.Rectangle;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Rectangle;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Rectangle;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Rectangle;
        stroke(settings?: Object): anychart.core.annotations.Rectangle;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Rectangle;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Rectangle;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Rectangle;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Rectangle;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Rectangle;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Rectangle;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Rectangle;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Rectangle;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Rectangle;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Rectangle;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface AndrewsPitchfork extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.AndrewsPitchfork;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.AndrewsPitchfork;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.AndrewsPitchfork;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.AndrewsPitchfork;
        color(): string;
        color(color: string): anychart.core.annotations.AndrewsPitchfork;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.AndrewsPitchfork;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.AndrewsPitchfork;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.AndrewsPitchfork;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.AndrewsPitchfork;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.AndrewsPitchfork;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.AndrewsPitchfork;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.AndrewsPitchfork;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.AndrewsPitchfork;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.AndrewsPitchfork;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.AndrewsPitchfork;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.AndrewsPitchfork;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.AndrewsPitchfork;
        secondValueAnchor(): any;
        secondValueAnchor(Second: any): anychart.core.annotations.AndrewsPitchfork;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.AndrewsPitchfork;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.AndrewsPitchfork;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.AndrewsPitchfork;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.AndrewsPitchfork;
        stroke(settings?: Object): anychart.core.annotations.AndrewsPitchfork;
        thirdValueAnchor(): any;
        thirdValueAnchor(Third: any): anychart.core.annotations.AndrewsPitchfork;
        thirdXAnchor(): any;
        thirdXAnchor(Third: any): anychart.core.annotations.AndrewsPitchfork;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.AndrewsPitchfork;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.AndrewsPitchfork;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.AndrewsPitchfork;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.AndrewsPitchfork;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.AndrewsPitchfork;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.AndrewsPitchfork;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.AndrewsPitchfork;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.AndrewsPitchfork;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.AndrewsPitchfork;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.AndrewsPitchfork;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Base extends anychart.core.VisualBaseWithBounds {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Base;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Base;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Base;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Base;
        color(): string;
        color(color: string): anychart.core.annotations.Base;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Base;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Base;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Base;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Base;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Base;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Base;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Base;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Base;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Base;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Base;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Base;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Base;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Base;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Base;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Base;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Base;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Base;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Base;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Base;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Base;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Base;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface PlotController extends anychart.core.VisualBase {
        add(annotationTypeOrConfig: string | anychart.core.annotations.AnnotationJSONFormat): anychart.core.annotations.Base;
        andrewsPitchfork(settings?: Object): anychart.core.annotations.AndrewsPitchfork;
        cancelDrawing(): void;
        ellipse(settings?: Object): anychart.core.annotations.Ellipse;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.PlotController;
        fibonacciArc(settings?: Object): anychart.core.annotations.FibonacciArc;
        fibonacciFan(settings?: Object): anychart.core.annotations.FibonacciFan;
        fibonacciRetracement(settings?: Object): anychart.core.annotations.FibonacciRetracement;
        fibonacciTimezones(settings?: Object): anychart.core.annotations.FibonacciTimezones;
        fromJson(config: Object | string): anychart.core.annotations.PlotController;
        fromXml(config: string | Node): anychart.core.annotations.PlotController;
        getAnnotationAt(index: number): anychart.core.annotations.Base;
        getAnnotationsCount(): number;
        getSelectedAnnotation(): anychart.core.annotations.Base;
        horizontalLine(settings?: Object): anychart.core.annotations.HorizontalLine;
        infiniteLine(settings?: Object): anychart.core.annotations.InfiniteLine;
        label(settings?: Object): anychart.core.annotations.Label;
        line(settings?: Object): anychart.core.annotations.Line;
        marker(settings?: Object): anychart.core.annotations.Marker;
        ray(settings?: Object): anychart.core.annotations.Ray;
        rectangle(settings?: Object): anychart.core.annotations.Rectangle;
        removeAllAnnotations(): anychart.core.annotations.PlotController;
        removeAnnotation(annotation: anychart.core.annotations.Base): anychart.core.annotations.PlotController;
        removeAnnotationAt(index: number): anychart.core.annotations.PlotController;
        select(annotation: anychart.core.annotations.Base): anychart.core.annotations.PlotController;
        startDrawing(annotationTypeOrConfig: string | anychart.core.annotations.AnnotationJSONFormat): anychart.core.annotations.Base;
        toJson(stringify?: boolean): Object | string;
        toXml(asXmlNode?: boolean): string | Node;
        trendChannel(settings?: Object): anychart.core.annotations.TrendChannel;
        triangle(settings?: Object): anychart.core.annotations.Triangle;
        unselect(): anychart.core.annotations.PlotController;
        verticalLine(settings?: Object): anychart.core.annotations.VerticalLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.PlotController;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.PlotController;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.PlotController;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.PlotController;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface FibonacciBase extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.FibonacciBase;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.FibonacciBase;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.FibonacciBase;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.FibonacciBase;
        color(): string;
        color(color: string): anychart.core.annotations.FibonacciBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.FibonacciBase;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.FibonacciBase;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.FibonacciBase;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.FibonacciBase;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value?: Object | boolean): anychart.core.annotations.FibonacciBase;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.FibonacciBase;
        levels(): Array<number>;
        levels(levelsList?: Array<any>): anychart.core.annotations.FibonacciBase;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.FibonacciBase;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.FibonacciBase;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.FibonacciBase;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.FibonacciBase;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.FibonacciBase;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.FibonacciBase;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.FibonacciBase;
        secondValueAnchor(): any;
        secondValueAnchor(Second: any): anychart.core.annotations.FibonacciBase;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.FibonacciBase;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.FibonacciBase;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciBase;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciBase;
        stroke(settings?: Object): anychart.core.annotations.FibonacciBase;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.FibonacciBase;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciBase;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciBase;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.FibonacciBase;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.FibonacciBase;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.FibonacciBase;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.FibonacciBase;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.FibonacciBase;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.FibonacciBase;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.FibonacciBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.FibonacciBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.FibonacciBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Triangle extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Triangle;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Triangle;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Triangle;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Triangle;
        color(): string;
        color(color: string): anychart.core.annotations.Triangle;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Triangle;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.annotations.Triangle;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.annotations.Triangle;
        fill(color: string, opacity?: number): anychart.core.annotations.Triangle;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.annotations.Triangle;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.annotations.Triangle;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.annotations.Triangle;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.annotations.Triangle;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.annotations.Triangle;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.annotations.Triangle;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.annotations.Triangle;
        hatchFill(enabled?: boolean): anychart.core.annotations.Triangle;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Triangle;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Triangle;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Triangle;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Triangle;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Triangle;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Triangle;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Triangle;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Triangle;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Triangle;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Triangle;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Triangle;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.Triangle;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.Triangle;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Triangle;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Triangle;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Triangle;
        stroke(settings?: Object): anychart.core.annotations.Triangle;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Triangle;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Triangle;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Triangle;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Triangle;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Triangle;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Triangle;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Triangle;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Triangle;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Triangle;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Triangle;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface FibonacciRetracement extends anychart.core.annotations.FibonacciBase {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.FibonacciRetracement;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.FibonacciRetracement;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.FibonacciRetracement;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.FibonacciRetracement;
        color(): string;
        color(color: string): anychart.core.annotations.FibonacciRetracement;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.FibonacciRetracement;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.FibonacciRetracement;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.FibonacciRetracement;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.FibonacciRetracement;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value?: Object | boolean): anychart.core.annotations.FibonacciRetracement;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.FibonacciRetracement;
        levels(): Array<number>;
        levels(levelsList?: Array<any>): anychart.core.annotations.FibonacciRetracement;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.FibonacciRetracement;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.FibonacciRetracement;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.FibonacciRetracement;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.FibonacciRetracement;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.FibonacciRetracement;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.FibonacciRetracement;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.FibonacciRetracement;
        secondValueAnchor(): any;
        secondValueAnchor(Second: any): anychart.core.annotations.FibonacciRetracement;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.FibonacciRetracement;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.FibonacciRetracement;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciRetracement;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciRetracement;
        stroke(settings?: Object): anychart.core.annotations.FibonacciRetracement;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.FibonacciRetracement;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciRetracement;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciRetracement;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.FibonacciRetracement;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.FibonacciRetracement;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.FibonacciRetracement;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.FibonacciRetracement;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.FibonacciRetracement;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.FibonacciRetracement;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.FibonacciRetracement;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.FibonacciRetracement;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.FibonacciRetracement;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface TrendChannel extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.TrendChannel;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.TrendChannel;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.TrendChannel;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.TrendChannel;
        color(): string;
        color(color: string): anychart.core.annotations.TrendChannel;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.TrendChannel;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | string | Array<any>): anychart.core.annotations.TrendChannel;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.annotations.TrendChannel;
        fill(color: string, opacity?: number): anychart.core.annotations.TrendChannel;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.annotations.TrendChannel;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.annotations.TrendChannel;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.annotations.TrendChannel;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.annotations.TrendChannel;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.annotations.TrendChannel;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.annotations.TrendChannel;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.annotations.TrendChannel;
        hatchFill(enabled?: boolean): anychart.core.annotations.TrendChannel;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.TrendChannel;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.TrendChannel;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.TrendChannel;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.TrendChannel;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.TrendChannel;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.TrendChannel;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.TrendChannel;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.TrendChannel;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.TrendChannel;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.TrendChannel;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.TrendChannel;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.TrendChannel;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.TrendChannel;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.TrendChannel;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.TrendChannel;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.TrendChannel;
        stroke(settings?: Object): anychart.core.annotations.TrendChannel;
        thirdValueAnchor(): any;
        thirdValueAnchor(value: any): anychart.core.annotations.TrendChannel;
        thirdXAnchor(): any;
        thirdXAnchor(value: any): anychart.core.annotations.TrendChannel;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.TrendChannel;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.TrendChannel;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.TrendChannel;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.TrendChannel;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.TrendChannel;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.TrendChannel;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.TrendChannel;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.TrendChannel;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.TrendChannel;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.TrendChannel;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface VerticalLine extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.VerticalLine;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.VerticalLine;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.VerticalLine;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.VerticalLine;
        color(): string;
        color(color: string): anychart.core.annotations.VerticalLine;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.VerticalLine;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.VerticalLine;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.VerticalLine;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.VerticalLine;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.VerticalLine;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.VerticalLine;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.VerticalLine;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.VerticalLine;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.VerticalLine;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.VerticalLine;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.VerticalLine;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.VerticalLine;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.VerticalLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.VerticalLine;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.VerticalLine;
        stroke(settings?: Object): anychart.core.annotations.VerticalLine;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.VerticalLine;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.VerticalLine;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.VerticalLine;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.VerticalLine;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.VerticalLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.VerticalLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.VerticalLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.VerticalLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.VerticalLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface HorizontalLine extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.HorizontalLine;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.HorizontalLine;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.HorizontalLine;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.HorizontalLine;
        color(): string;
        color(color: string): anychart.core.annotations.HorizontalLine;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.HorizontalLine;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.HorizontalLine;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.HorizontalLine;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.HorizontalLine;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.HorizontalLine;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.HorizontalLine;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.HorizontalLine;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.HorizontalLine;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.HorizontalLine;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.HorizontalLine;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.HorizontalLine;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.HorizontalLine;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.HorizontalLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.HorizontalLine;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.HorizontalLine;
        stroke(settings?: Object): anychart.core.annotations.HorizontalLine;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.HorizontalLine;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.HorizontalLine;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.HorizontalLine;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.HorizontalLine;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.HorizontalLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.HorizontalLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.HorizontalLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.HorizontalLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.HorizontalLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface ChartController extends anychart.core.Base {
        cancelDrawing(): void;
        getSelectedAnnotation(): anychart.core.annotations.Base;
        removeAllAnnotations(): anychart.core.annotations.ChartController;
        removeAnnotation(annotation: anychart.core.annotations.Base): anychart.core.annotations.ChartController;
        select(annotation: anychart.core.annotations.Base): anychart.core.annotations.ChartController;
        startDrawing(annotationTypeOrConfig: string | anychart.core.annotations.AnnotationJSONFormat): anychart.core.annotations.Base;
        unselect(): anychart.core.annotations.ChartController;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface FibonacciArc extends anychart.core.annotations.FibonacciBase {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.FibonacciArc;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.FibonacciArc;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.FibonacciArc;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.FibonacciArc;
        color(): string;
        color(color: string): anychart.core.annotations.FibonacciArc;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.FibonacciArc;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.FibonacciArc;
        hoverGap(): number;
        hoverGap(gap: any): anychart.core.annotations.FibonacciArc;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.FibonacciArc;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value?: Object | boolean): anychart.core.annotations.FibonacciArc;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.FibonacciArc;
        levels(): Array<number>;
        levels(levelsList?: Array<any>): anychart.core.annotations.FibonacciArc;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.FibonacciArc;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.FibonacciArc;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.FibonacciArc;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.FibonacciArc;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.FibonacciArc;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.FibonacciArc;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.FibonacciArc;
        secondValueAnchor(): any;
        secondValueAnchor(Second: any): anychart.core.annotations.FibonacciArc;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.FibonacciArc;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.FibonacciArc;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciArc;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciArc;
        stroke(settings?: Object): anychart.core.annotations.FibonacciArc;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.FibonacciArc;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciArc;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciArc;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.FibonacciArc;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.FibonacciArc;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.FibonacciArc;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.FibonacciArc;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.FibonacciArc;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.FibonacciArc;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.FibonacciArc;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.FibonacciArc;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.FibonacciArc;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Line extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Line;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Line;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Line;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Line;
        color(): string;
        color(color: string): anychart.core.annotations.Line;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Line;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Line;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Line;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Line;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Line;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Line;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Line;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Line;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Line;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Line;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Line;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Line;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.Line;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.Line;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Line;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Line;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Line;
        stroke(settings?: Object): anychart.core.annotations.Line;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Line;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Line;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Line;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Line;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Line;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Line;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Line;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Line;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Line;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Line;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface FibonacciTimezones extends anychart.core.annotations.FibonacciBase {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.FibonacciTimezones;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.FibonacciTimezones;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.FibonacciTimezones;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.FibonacciTimezones;
        color(): string;
        color(color: string): anychart.core.annotations.FibonacciTimezones;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.FibonacciTimezones;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.FibonacciTimezones;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.FibonacciTimezones;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.FibonacciTimezones;
        labels(): anychart.core.ui.LabelsFactory;
        labels(value?: Object | boolean): anychart.core.annotations.FibonacciTimezones;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.FibonacciTimezones;
        levels(): Array<number>;
        levels(levelsList?: Array<any>): anychart.core.annotations.FibonacciTimezones;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.FibonacciTimezones;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.FibonacciTimezones;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.FibonacciTimezones;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.FibonacciTimezones;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.FibonacciTimezones;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.FibonacciTimezones;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.FibonacciTimezones;
        secondValueAnchor(): any;
        secondValueAnchor(value: any): anychart.core.annotations.FibonacciTimezones;
        secondXAnchor(): any;
        secondXAnchor(value: any): anychart.core.annotations.FibonacciTimezones;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.FibonacciTimezones;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciTimezones;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciTimezones;
        stroke(settings?: Object): anychart.core.annotations.FibonacciTimezones;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.FibonacciTimezones;
        trend(): anychart.graphics.vector.Stroke;
        trend(trendFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.FibonacciTimezones;
        trend(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.FibonacciTimezones;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.FibonacciTimezones;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.FibonacciTimezones;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.FibonacciTimezones;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.FibonacciTimezones;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.FibonacciTimezones;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.FibonacciTimezones;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.FibonacciTimezones;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.FibonacciTimezones;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.FibonacciTimezones;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Ellipse extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Ellipse;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Ellipse;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Ellipse;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Ellipse;
        color(): string;
        color(color: string): anychart.core.annotations.Ellipse;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Ellipse;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.annotations.Ellipse;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.annotations.Ellipse;
        fill(color: string, opacity?: number): anychart.core.annotations.Ellipse;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.annotations.Ellipse;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.annotations.Ellipse;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.annotations.Ellipse;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.annotations.Ellipse;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.annotations.Ellipse;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.annotations.Ellipse;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.annotations.Ellipse;
        hatchFill(enabled?: boolean): anychart.core.annotations.Ellipse;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Ellipse;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Ellipse;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Ellipse;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Ellipse;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Ellipse;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Ellipse;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Ellipse;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Ellipse;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Ellipse;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Ellipse;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Ellipse;
        secondValueAnchor(): any;
        secondValueAnchor(Second: any): anychart.core.annotations.Ellipse;
        secondXAnchor(): any;
        secondXAnchor(Second: any): anychart.core.annotations.Ellipse;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Ellipse;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Ellipse;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Ellipse;
        stroke(settings?: Object): anychart.core.annotations.Ellipse;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Ellipse;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Ellipse;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Ellipse;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Ellipse;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Ellipse;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Ellipse;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Ellipse;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Ellipse;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Ellipse;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Ellipse;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Marker extends anychart.core.annotations.Base {
        allowEdit(): boolean;
        allowEdit(value: any): anychart.core.annotations.Marker;
        anchor(): string;
        anchor(value: string): anychart.core.annotations.Marker;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.annotations.Marker;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.annotations.Marker;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.annotations.Marker;
        color(): string;
        color(color: string): anychart.core.annotations.Marker;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.annotations.Marker;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.annotations.Marker;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.annotations.Marker;
        fill(color: string, opacity?: number): anychart.core.annotations.Marker;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.annotations.Marker;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.annotations.Marker;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.annotations.Marker;
        getChart(): anychart.core.SeparateChart;
        getPixelBounds(): anychart.math.Rect;
        getPlot(): anychart.core.stock.Plot;
        getType(): string;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.annotations.Marker;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.annotations.Marker;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.annotations.Marker;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.annotations.Marker;
        hatchFill(enabled?: boolean): anychart.core.annotations.Marker;
        height(): number | string;
        height(height?: number | string): anychart.core.annotations.Marker;
        hoverGap(): number;
        hoverGap(value: any): anychart.core.annotations.Marker;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.annotations.Marker;
        left(): number | string;
        left(left?: number | string): anychart.core.annotations.Marker;
        markerType(): string;
        markerType(type: string): anychart.core.annotations.Marker;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.annotations.Marker;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.annotations.Marker;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.annotations.Marker;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.annotations.Marker;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.annotations.Marker;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.annotations.Marker;
        offsetX(): number | string;
        offsetX(value: number | string): anychart.core.annotations.Marker;
        offsetY(): number | string;
        offsetY(offset: number | string): anychart.core.annotations.Marker;
        right(): number | string;
        right(right?: number | string): anychart.core.annotations.Marker;
        select(): void;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.annotations.Marker;
        size(): number;
        size(size?: number): anychart.core.annotations.Marker;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.annotations.Marker;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.annotations.Marker;
        stroke(settings?: Object): anychart.core.annotations.Marker;
        top(): number | string;
        top(top?: number | string): anychart.core.annotations.Marker;
        valueAnchor(): any;
        valueAnchor(value: any): anychart.core.annotations.Marker;
        width(): number | string;
        width(width?: number | string): anychart.core.annotations.Marker;
        xAnchor(): any;
        xAnchor(value: any): anychart.core.annotations.Marker;
        xScale(): anychart.scales.Ordinal | anychart.scales.Linear | anychart.scales.Logarithmic | anychart.scales.StockScatterDateTime;
        xScale(settings?: anychart.scales.Base | anychart.scales.StockScatterDateTime | Object | string): anychart.core.annotations.Marker;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.annotations.Marker;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.annotations.Marker;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.annotations.Marker;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.annotations.Marker;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.annotations.Marker;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
}

declare namespace anychart.core.axes {
    interface Surface extends anychart.core.axes.Linear {
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.Surface;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.Surface;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Surface;
        getPixelBounds(): anychart.math.Rect;
        getRemainingBounds(): anychart.math.Rect;
        isHorizontal(): boolean;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Surface;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Surface;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Surface;
        orientation(): string;
        orientation(orientation?: string): anychart.core.axes.Surface;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.Surface;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axes.Surface;
        staggerLines(): number;
        staggerLines(count?: number): anychart.core.axes.Surface;
        staggerMaxLines(): number;
        staggerMaxLines(count?: number): anychart.core.axes.Surface;
        staggerMode(): boolean;
        staggerMode(enabled?: boolean): anychart.core.axes.Surface;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Surface;
        stroke(settings?: Object): anychart.core.axes.Surface;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.Surface;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.axes.Surface;
        width(): number | string;
        width(width?: number | string): anychart.core.axes.Surface;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Surface;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Surface;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Surface;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Surface;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface CircularTicks extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.CircularTicks;
        fill(): anychart.graphics.vector.Fill | (() => void);
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axes.CircularTicks;
        fill(color: string, opacity?: number): anychart.core.axes.CircularTicks;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axes.CircularTicks;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axes.CircularTicks;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.axes.CircularTicks;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | boolean;
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.axes.CircularTicks;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.axes.CircularTicks;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.axes.CircularTicks;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.axes.CircularTicks;
        hatchFill(enabled?: boolean): anychart.core.axes.CircularTicks;
        length(): string;
        length(length?: number | string): anychart.core.axes.CircularTicks;
        position(): string;
        position(value?: string): anychart.core.axes.CircularTicks;
        stroke(): anychart.graphics.vector.Stroke | (() => void);
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.axes.CircularTicks;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.CircularTicks;
        stroke(settings?: Object): anychart.core.axes.CircularTicks;
        type(): string | (() => void);
        type(type?: string | ((path:anychart.graphics.vector.Path,x:number,y:number,radius:number)=>void)): anychart.core.axes.CircularTicks;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.CircularTicks;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.CircularTicks;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.CircularTicks;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.CircularTicks;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Timeline extends anychart.core.VisualBase {
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axes.Timeline;
        fill(color: string, opacity?: number): anychart.core.axes.Timeline;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axes.Timeline;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axes.Timeline;
        height(): number;
        height(height: number): anychart.core.axes.Timeline;
        labels(): anychart.core.ui.LabelsFactory;
        labels(config?: Object): anychart.core.axes.Timeline;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Timeline;
        stroke(settings?: Object): anychart.core.axes.Timeline;
        ticks(): anychart.core.axes.TimelineTicks;
        ticks(config?: Object): anychart.core.axes.Timeline;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Timeline;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Timeline;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Timeline;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Timeline;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Timeline;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Polar extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Polar;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axes.Polar;
        fill(color: string, opacity?: number): anychart.core.axes.Polar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axes.Polar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axes.Polar;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.axes.Polar;
        getRemainingBounds(): anychart.math.Rect;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Polar;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Polar;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Polar;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.Polar;
        scale(): anychart.scales.ScatterBase;
        scale(settings?: anychart.scales.ScatterBase | string | Object): anychart.core.axes.Polar;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Polar;
        stroke(settings?: Object): anychart.core.axes.Polar;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.Polar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Polar;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Polar;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Polar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Polar;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Linear extends anychart.core.VisualBase {
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.Linear;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.Linear;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Linear;
        getPixelBounds(): anychart.math.Rect;
        getRemainingBounds(): anychart.math.Rect;
        isHorizontal(): boolean;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Linear;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Linear;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Linear;
        orientation(): string;
        orientation(orientation?: string): anychart.core.axes.Linear;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.Linear;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axes.Linear;
        staggerLines(): number;
        staggerLines(count?: number): anychart.core.axes.Linear;
        staggerMaxLines(): number;
        staggerMaxLines(count?: number): anychart.core.axes.Linear;
        staggerMode(): boolean;
        staggerMode(enabled?: boolean): anychart.core.axes.Linear;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Linear;
        stroke(settings?: Object): anychart.core.axes.Linear;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.Linear;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.axes.Linear;
        width(): number | string;
        width(width?: number | string): anychart.core.axes.Linear;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Linear;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Linear;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Linear;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Linear;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface MapSettings extends anychart.core.VisualBase {
        bottom(): anychart.core.axes.Map;
        bottom(settings?: boolean | Object): anychart.core.axes.MapSettings;
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.MapSettings;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.MapSettings;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.MapSettings;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.MapSettings;
        left(): anychart.core.axes.Map;
        left(settings?: boolean | Object): anychart.core.axes.MapSettings;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.MapSettings;
        minorTicks(): anychart.core.axes.MapTicks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.MapSettings;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.MapSettings;
        right(): anychart.core.axes.Map;
        right(settings?: boolean | Object): anychart.core.axes.MapSettings;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(value?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.MapSettings;
        stroke(settings?: Object): anychart.core.axes.MapSettings;
        ticks(): anychart.core.axes.MapTicks;
        ticks(settings?: Object | boolean): anychart.core.axes.MapSettings;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.axes.MapSettings;
        top(): anychart.core.axes.Map;
        top(settings?: boolean | Object): anychart.core.axes.MapSettings;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.MapSettings;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.MapSettings;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.MapSettings;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.MapSettings;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Radial extends anychart.core.VisualBase {
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.Radial;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.Radial;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Radial;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Radial;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Radial;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Radial;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.Radial;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axes.Radial;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Radial;
        stroke(settings?: Object): anychart.core.axes.Radial;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.Radial;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Radial;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Radial;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Radial;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Radial;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Ticks extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Ticks;
        length(): number;
        length(length?: number): anychart.core.axes.Ticks;
        position(): string;
        position(position?: string): anychart.core.axes.Ticks;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke): anychart.core.axes.Ticks;
        stroke(color?: string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Ticks;
        stroke(settings?: Object): anychart.core.axes.Ticks;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Ticks;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Ticks;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Ticks;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Ticks;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface SurfaceTicks extends anychart.core.axes.Ticks {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.SurfaceTicks;
        length(): number;
        length(length?: number): anychart.core.axes.SurfaceTicks;
        position(): string;
        position(position?: string): anychart.core.axes.SurfaceTicks;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke): anychart.core.axes.SurfaceTicks;
        stroke(color?: string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.SurfaceTicks;
        stroke(settings?: Object): anychart.core.axes.SurfaceTicks;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.SurfaceTicks;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.SurfaceTicks;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.SurfaceTicks;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.SurfaceTicks;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Circular extends anychart.core.VisualBase {
        cornersRounding(): string;
        cornersRounding(radius?: number | string): anychart.core.axes.Circular;
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.Circular;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.Circular;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Circular;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axes.Circular;
        fill(color: string, opacity?: number): anychart.core.axes.Circular;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axes.Circular;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axes.Circular;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.axes.Circular;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Circular;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Circular;
        minorTicks(): anychart.core.axes.CircularTicks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Circular;
        overlapMode(): string;
        overlapMode(value?: string | boolean): anychart.core.axes.Circular;
        radius(): string;
        radius(value?: number | string): anychart.core.axes.Circular;
        scale(): anychart.scales.Linear | anychart.scales.Logarithmic;
        scale(settings?: string | anychart.scales.Linear | Object): anychart.core.axes.Circular;
        startAngle(): number;
        startAngle(value?: string | number): anychart.core.axes.Circular;
        sweepAngle(): number;
        sweepAngle(value?: string | number): anychart.core.axes.Circular;
        ticks(): anychart.core.axes.CircularTicks;
        ticks(settings?: Object | boolean): anychart.core.axes.Circular;
        width(): string;
        width(value?: number | string): anychart.core.axes.Circular;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Circular;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Circular;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Circular;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Circular;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface StockDateTime extends anychart.core.VisualBase {
        background(): anychart.core.ui.Background;
        background(settings?: Object | boolean | string): anychart.core.axes.StockDateTime;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.StockDateTime;
        height(): number;
        height(height?: number): anychart.core.axes.StockDateTime;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.StockDateTime;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.StockDateTime;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.StockDateTime;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.StockDateTime;
        showHelperLabel(): boolean;
        showHelperLabel(settings?: boolean): anychart.core.axes.StockDateTime;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.StockDateTime;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.StockDateTime;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.StockDateTime;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.StockDateTime;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.StockDateTime;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Radar extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Radar;
        getRemainingBounds(): anychart.math.Rect;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Radar;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | string | Object): anychart.core.axes.Radar;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Radar;
        stroke(settings?: Object): anychart.core.axes.Radar;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.Radar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Radar;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Radar;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Radar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Radar;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface TimelineTicks extends anychart.core.VisualBase {
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke): anychart.core.axes.TimelineTicks;
        stroke(color?: string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.TimelineTicks;
        stroke(settings?: Object): anychart.core.axes.TimelineTicks;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.TimelineTicks;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.TimelineTicks;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.TimelineTicks;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.TimelineTicks;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.TimelineTicks;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface LinearGauge extends anychart.core.axes.Linear {
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.LinearGauge;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.LinearGauge;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.LinearGauge;
        getPixelBounds(): anychart.math.Rect;
        getRemainingBounds(): anychart.math.Rect;
        isHorizontal(): boolean;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.LinearGauge;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.LinearGauge;
        minorTicks(): anychart.core.axes.Ticks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.LinearGauge;
        offset(): string;
        offset(offset?: string): anychart.core.axes.LinearGauge;
        orientation(): string;
        orientation(orientation?: string): anychart.core.axes.LinearGauge;
        overlapMode(): string;
        overlapMode(mode?: string): anychart.core.axes.LinearGauge;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.axes.LinearGauge;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.axes.LinearGauge;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axes.LinearGauge;
        staggerLines(): number;
        staggerLines(count?: number): anychart.core.axes.LinearGauge;
        staggerMaxLines(): number;
        staggerMaxLines(count?: number): anychart.core.axes.LinearGauge;
        staggerMode(): boolean;
        staggerMode(enabled?: boolean): anychart.core.axes.LinearGauge;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.LinearGauge;
        stroke(settings?: Object): anychart.core.axes.LinearGauge;
        ticks(): anychart.core.axes.Ticks;
        ticks(settings?: Object | boolean): anychart.core.axes.LinearGauge;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.axes.LinearGauge;
        width(): number | string;
        width(width?: number | string): anychart.core.axes.LinearGauge;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.LinearGauge;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.LinearGauge;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.LinearGauge;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.LinearGauge;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface MapTicks extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.MapTicks;
        length(): number;
        length(length?: number | string): anychart.core.axes.MapTicks;
        position(): string;
        position(position?: string): anychart.core.axes.MapTicks;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.MapTicks;
        stroke(settings?: Object): anychart.core.axes.MapTicks;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.MapTicks;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.MapTicks;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.MapTicks;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.MapTicks;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Map extends anychart.core.VisualBase {
        drawFirstLabel(): boolean;
        drawFirstLabel(enabled?: boolean): anychart.core.axes.Map;
        drawLastLabel(): boolean;
        drawLastLabel(enabled?: boolean): anychart.core.axes.Map;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axes.Map;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.axes.Map;
        minorLabels(): anychart.core.ui.LabelsFactory;
        minorLabels(settings?: Object | boolean): anychart.core.axes.Map;
        minorTicks(): anychart.core.axes.MapTicks;
        minorTicks(settings?: Object | boolean): anychart.core.axes.Map;
        overlapMode(): string;
        overlapMode(value?: string): anychart.core.axes.Map;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string | (() => void), thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axes.Map;
        stroke(settings?: Object): anychart.core.axes.Map;
        ticks(): anychart.core.axes.MapTicks;
        ticks(settings?: Object | boolean): anychart.core.axes.Map;
        title(): anychart.core.ui.Title;
        title(settings?: boolean | Object | string): anychart.core.axes.Map;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axes.Map;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axes.Map;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axes.Map;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axes.Map;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
}

declare namespace anychart.core.axisMarkers {
    interface GanttLine extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.GanttLine;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.GanttLine;
        scale(): anychart.scales.GanttDateTime;
        scale(scale?: anychart.scales.GanttDateTime): anychart.core.axisMarkers.GanttLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axisMarkers.GanttLine;
        stroke(settings?: Object): anychart.core.axisMarkers.GanttLine;
        value(): number | string;
        value(value?: number | string): anychart.core.axisMarkers.GanttLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.GanttLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.GanttLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.GanttLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.GanttLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface GanttText extends anychart.core.Text {
        align(): string;
        align(align?: string): anychart.core.axisMarkers.GanttText;
        anchor(): string;
        anchor(anchor?: string): anychart.core.axisMarkers.GanttText;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.core.axisMarkers.GanttText;
        disablePointerEvents(): boolean;
        disablePointerEvents(enabled?: boolean): anychart.core.axisMarkers.GanttText;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.GanttText;
        fontColor(): string;
        fontColor(color?: string): anychart.core.axisMarkers.GanttText;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(value?: anychart.graphics.vector.Text.Decoration | string): anychart.core.axisMarkers.GanttText;
        fontFamily(): string;
        fontFamily(family?: string): anychart.core.axisMarkers.GanttText;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.core.axisMarkers.GanttText;
        fontSize(): string | number;
        fontSize(size?: string | number): anychart.core.axisMarkers.GanttText;
        fontStyle(): anychart.graphics.vector.Text.FontStyle | string;
        fontStyle(style?: anychart.graphics.vector.Text.FontStyle | string): anychart.core.axisMarkers.GanttText;
        fontVariant(): anychart.graphics.vector.Text.FontVariant | string;
        fontVariant(value?: anychart.graphics.vector.Text.FontVariant | string): anychart.core.axisMarkers.GanttText;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.core.axisMarkers.GanttText;
        hAlign(): anychart.graphics.vector.Text.HAlign | string;
        hAlign(align?: anychart.graphics.vector.Text.HAlign | string): anychart.core.axisMarkers.GanttText;
        height(): number | string;
        height(height?: number | string): anychart.core.axisMarkers.GanttText;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.GanttText;
        letterSpacing(): string | number;
        letterSpacing(spacing?: string | number): anychart.core.axisMarkers.GanttText;
        lineHeight(): string | number;
        lineHeight(height?: string | number): anychart.core.axisMarkers.GanttText;
        offsetX(): number | string;
        offsetX(offset?: number | string): anychart.core.axisMarkers.GanttText;
        offsetY(): number | string;
        offsetY(offset?: number | string): anychart.core.axisMarkers.GanttText;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.axisMarkers.GanttText;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.axisMarkers.GanttText;
        rotation(): number;
        rotation(rotation?: number): anychart.core.axisMarkers.GanttText;
        scale(): anychart.scales.GanttDateTime;
        scale(scale?: anychart.scales.GanttDateTime): anychart.core.axisMarkers.GanttText;
        selectable(): boolean;
        selectable(enabled?: boolean): anychart.core.axisMarkers.GanttText;
        text(): string;
        text(text?: string): anychart.core.axisMarkers.GanttText;
        textDirection(): anychart.graphics.vector.Text.Direction | string;
        textDirection(direction?: anychart.graphics.vector.Text.Direction | string): anychart.core.axisMarkers.GanttText;
        textIndent(): number;
        textIndent(indent?: number): anychart.core.axisMarkers.GanttText;
        textOverflow(): anychart.graphics.vector.Text.TextOverflow | string;
        textOverflow(value?: anychart.graphics.vector.Text.TextOverflow | string): anychart.core.axisMarkers.GanttText;
        textSettings(): Object;
        textSettings(name?: string): string | number | boolean;
        textSettings(objectWithSettings?: Object): anychart.core.axisMarkers.GanttText;
        textSettings(name?: string, settings?: string | number | boolean | (() => void)): anychart.core.axisMarkers.GanttText;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.axisMarkers.GanttText;
        vAlign(): anychart.graphics.vector.Text.VAlign | string;
        vAlign(align?: anychart.graphics.vector.Text.VAlign | string): anychart.core.axisMarkers.GanttText;
        value(): number | string;
        value(value?: number | string): anychart.core.axisMarkers.GanttText;
        width(): number | string;
        width(width?: number | string): anychart.core.axisMarkers.GanttText;
        wordBreak(): string;
        wordBreak(mode?: string): anychart.core.axisMarkers.GanttText;
        wordWrap(): string;
        wordWrap(mode?: string): anychart.core.axisMarkers.GanttText;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.GanttText;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.GanttText;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.GanttText;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.GanttText;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface GanttRange extends anychart.core.VisualBase {
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.GanttRange;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill): anychart.core.axisMarkers.GanttRange;
        fill(color: string, opacity?: number): anychart.core.axisMarkers.GanttRange;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axisMarkers.GanttRange;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axisMarkers.GanttRange;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.axisMarkers.GanttRange;
        from(): number | string;
        from(fromValue?: number | string): anychart.core.axisMarkers.GanttRange;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.GanttRange;
        scale(): anychart.scales.GanttDateTime;
        scale(scale?: anychart.scales.GanttDateTime): anychart.core.axisMarkers.GanttRange;
        to(): number | string;
        to(toValue?: number | string): anychart.core.axisMarkers.GanttRange;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.GanttRange;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.GanttRange;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.GanttRange;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.GanttRange;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface CircularRange extends anychart.core.VisualBase {
        axisIndex(): number;
        axisIndex(index?: number): anychart.core.axisMarkers.CircularRange;
        cornersRounding(): string;
        cornersRounding(value?: number | string): anychart.core.axisMarkers.CircularRange;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.CircularRange;
        endSize(): string;
        endSize(value?: number | string): anychart.core.axisMarkers.CircularRange;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axisMarkers.CircularRange;
        from(): number;
        from(fromValue?: number): anychart.core.axisMarkers.CircularRange;
        position(): string;
        position(positionType?: string): anychart.core.axisMarkers.CircularRange;
        radius(): string;
        radius(value?: number | string): anychart.core.axisMarkers.CircularRange;
        startSize(): string;
        startSize(value?: number | string): anychart.core.axisMarkers.CircularRange;
        to(): number;
        to(toValue?: number): anychart.core.axisMarkers.CircularRange;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.CircularRange;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.CircularRange;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.CircularRange;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.CircularRange;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Text extends anychart.core.Text {
        adjustFontSize(): Object;
        adjustFontSize(bothOrByWidth?: Object | Array<boolean> | boolean, byHeight?: boolean): anychart.core.annotations.Label;
        align(): string;
        align(align?: string): anychart.core.axisMarkers.Text;
        anchor(): string;
        anchor(anchor?: string): anychart.core.axisMarkers.Text;
        axis(): anychart.core.axes.Linear;
        axis(axis?: anychart.core.axes.Linear): anychart.core.axisMarkers.Line;
        background(): anychart.core.ui.Background;
        background(settings?: string | Object | boolean): anychart.core.axisMarkers.Text;
        disablePointerEvents(): boolean;
        disablePointerEvents(enabled?: boolean): anychart.core.axisMarkers.Text;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.Text;
        fontColor(): string;
        fontColor(color?: string): anychart.core.axisMarkers.Text;
        fontColor(): string;
        fontColor(color?: string): anychart.core.axisMarkers.Text;
        fontDecoration(): anychart.graphics.vector.Text.Decoration | string;
        fontDecoration(value?: anychart.graphics.vector.Text.Decoration | string): anychart.core.axisMarkers.Text;
        fontFamily(): string;
        fontFamily(family?: string): anychart.core.axisMarkers.Text;
        fontOpacity(): number;
        fontOpacity(opacity?: number): anychart.core.axisMarkers.Text;
        fontSize(): string | number;
        fontSize(size?: string | number): anychart.core.axisMarkers.Text;
        fontStyle(): anychart.graphics.vector.Text.FontStyle | string;
        fontStyle(style?: anychart.graphics.vector.Text.FontStyle | string): anychart.core.axisMarkers.Text;
        fontVariant(): anychart.graphics.vector.Text.FontVariant | string;
        fontVariant(value?: anychart.graphics.vector.Text.FontVariant | string): anychart.core.axisMarkers.Text;
        fontWeight(): string | number;
        fontWeight(weight?: string | number): anychart.core.axisMarkers.Text;
        hAlign(): anychart.graphics.vector.Text.HAlign | string;
        hAlign(align?: anychart.graphics.vector.Text.HAlign | string): anychart.core.axisMarkers.Text;
        height(): number | string;
        height(height?: number | string): anychart.core.axisMarkers.Text;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.Text;
        letterSpacing(): string | number;
        letterSpacing(spacing?: string | number): anychart.core.axisMarkers.Text;
        lineHeight(): string | number;
        lineHeight(height?: string | number): anychart.core.axisMarkers.Text;
        maxFontSize(): number;
        maxFontSize(size?: number | string): anychart.core.axisMarkers.Text;
        minFontSize(): number;
        minFontSize(size?: number | string): anychart.core.axisMarkers.Text;
        offsetX(): number | string;
        offsetX(offset?: number | string): anychart.core.axisMarkers.Text;
        offsetY(): number | string;
        offsetY(offset?: number | string): anychart.core.axisMarkers.Text;
        padding(): anychart.core.utils.Padding;
        padding(padding?: Array<number|string> | Object): anychart.core.axisMarkers.Text;
        padding(value1?: string | number, value2?: string | number, value3?: string | number, value4?: string | number): anychart.core.axisMarkers.Text;
        position(): string;
        position(position?: string): anychart.core.axisMarkers.Text;
        rotation(): number;
        rotation(rotation?: number): anychart.core.axisMarkers.Text;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axisMarkers.Text;
        scaleRangeMode(): string;
        scaleRangeMode(mode?: string): anychart.core.axisMarkers.Text;
        selectable(): boolean;
        selectable(enabled?: boolean): anychart.core.axisMarkers.Text;
        text(): string;
        text(text?: string): anychart.core.axisMarkers.Text;
        textDirection(): anychart.graphics.vector.Text.Direction | string;
        textDirection(direction?: anychart.graphics.vector.Text.Direction | string): anychart.core.axisMarkers.Text;
        textIndent(): number;
        textIndent(indent?: number): anychart.core.axisMarkers.Text;
        textOverflow(): anychart.graphics.vector.Text.TextOverflow | string;
        textOverflow(value?: anychart.graphics.vector.Text.TextOverflow | string): anychart.core.axisMarkers.Text;
        textSettings(): Object;
        textSettings(name?: string): string | number | boolean;
        textSettings(objectWithSettings?: Object): anychart.core.axisMarkers.Text;
        textSettings(name?: string, settings?: string | number | boolean | (() => void)): anychart.core.axisMarkers.Text;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.axisMarkers.Text;
        useHtml(): boolean;
        useHtml(enabled?: boolean): anychart.core.axisMarkers.Text;
        vAlign(): anychart.graphics.vector.Text.VAlign | string;
        vAlign(align?: anychart.graphics.vector.Text.VAlign | string): anychart.core.axisMarkers.Text;
        value(): number;
        value(value?: number): anychart.core.axisMarkers.Text;
        width(): number | string;
        width(width?: number | string): anychart.core.axisMarkers.Text;
        wordBreak(): string;
        wordBreak(mode?: string): anychart.core.axisMarkers.Text;
        wordWrap(): string;
        wordWrap(mode?: string): anychart.core.axisMarkers.Text;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.Text;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.Text;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.Text;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.Text;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface CurrentPriceIndicator extends anychart.core.VisualBase {
        axis(): anychart.core.axes.Linear;
        axis(indexOrAxis?: number | anychart.core.axes.Linear): anychart.core.axisMarkers.CurrentPriceIndicator;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.CurrentPriceIndicator;
        fallingLabel(): anychart.core.ui.Label;
        fallingLabel(index?: string | number, settings?: boolean | Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        fallingStroke(): anychart.graphics.vector.Stroke;
        fallingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axisMarkers.CurrentPriceIndicator;
        fallingStroke(settings?: Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        label(): anychart.core.ui.LabelsFactory;
        label(index?: string | number, settings?: boolean | Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        risingLabel(): anychart.core.ui.Label;
        risingLabel(index?: string | number, settings?: boolean | Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        risingStroke(): anychart.graphics.vector.Stroke;
        risingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axisMarkers.CurrentPriceIndicator;
        risingStroke(settings?: Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        series(): anychart.core.stock.series.Base;
        series(indexOrSeries?: number | anychart.core.stock.series.Base): anychart.core.axisMarkers.CurrentPriceIndicator;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axisMarkers.CurrentPriceIndicator;
        stroke(settings?: Object): anychart.core.axisMarkers.CurrentPriceIndicator;
        value(): string | number | Date;
        value(value?: string | number | Date): anychart.core.axisMarkers.CurrentPriceIndicator;
        valueField(): string;
        valueField(fieldName: string): string;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.CurrentPriceIndicator;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.CurrentPriceIndicator;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.CurrentPriceIndicator;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.CurrentPriceIndicator;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Line extends anychart.core.VisualBase {
        axis(): anychart.core.axes.Linear;
        axis(axis?: anychart.core.axes.Linear): anychart.core.axisMarkers.Line;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.Line;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.Line;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axisMarkers.Line;
        scaleRangeMode(): string;
        scaleRangeMode(mode?: string): anychart.core.axisMarkers.Line;
        stroke(): string | anychart.graphics.vector.Stroke;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.axisMarkers.Line;
        stroke(settings?: Object): anychart.core.axisMarkers.Line;
        value(): number;
        value(newValue?: number): anychart.core.axisMarkers.Line;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.Line;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.Line;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.Line;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.Line;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Range extends anychart.core.VisualBase {
        axis(): anychart.core.axes.Linear;
        axis(axis?: anychart.core.axes.Linear): anychart.core.axisMarkers.Line;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.axisMarkers.Range;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.axisMarkers.Range;
        fill(color: string, opacity?: number): anychart.core.axisMarkers.Range;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.axisMarkers.Range;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.axisMarkers.Range;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.axisMarkers.Range;
        from(): number;
        from(fromValue?: number): anychart.core.axisMarkers.Range;
        isHorizontal(): boolean;
        layout(): string;
        layout(layout?: string): anychart.core.axisMarkers.Range;
        scale(): anychart.scales.Base;
        scale(settings?: anychart.scales.Base | Object | string): anychart.core.axisMarkers.Range;
        scaleRangeMode(): string;
        scaleRangeMode(mode?: string): anychart.core.axisMarkers.Range;
        to(): number;
        to(toValue?: number): anychart.core.axisMarkers.Range;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.axisMarkers.Range;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.axisMarkers.Range;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.axisMarkers.Range;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.axisMarkers.Range;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
}

declare namespace anychart.core.cartesian {
}

declare namespace anychart.core.cartesian.series {
    interface ContinuousBase extends anychart.core.cartesian.series.BaseWithMarkers {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.ContinuousBase;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.ContinuousBase;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.ContinuousBase;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.ContinuousBase;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.ContinuousBase;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.ContinuousBase;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.ContinuousBase;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.ContinuousBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.ContinuousBase;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.ContinuousBase;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.ContinuousBase;
        hover(): anychart.core.cartesian.series.ContinuousBase;
        hover(index?: number): anychart.core.cartesian.series.ContinuousBase;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousBase;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.ContinuousBase;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.ContinuousBase;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousBase;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.ContinuousBase;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.ContinuousBase;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.ContinuousBase;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.ContinuousBase;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousBase;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.ContinuousBase;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.ContinuousBase;
        meta(key?: string, value?: any): anychart.core.cartesian.series.ContinuousBase;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.ContinuousBase;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousBase;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.ContinuousBase;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.ContinuousBase;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.ContinuousBase;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.ContinuousBase;
        select(index?: number): anychart.core.cartesian.series.ContinuousBase;
        select(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousBase;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.ContinuousBase;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.ContinuousBase;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.ContinuousBase;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.ContinuousBase;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.ContinuousBase;
        unselect(): anychart.core.cartesian.series.ContinuousBase;
        unselect(index?: number): anychart.core.cartesian.series.ContinuousBase;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousBase;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.ContinuousBase;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.ContinuousBase;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.ContinuousBase;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.ContinuousBase;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.ContinuousBase;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.ContinuousBase;
        getStat(key: string): any;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.ContinuousBase;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.ContinuousBase;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.ContinuousBase;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.ContinuousBase;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.ContinuousBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.ContinuousBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.ContinuousBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Box extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Box;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Box;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Box;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Box;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Box;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Box;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Box;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Box;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Box;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Box;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Box;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Box;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Box;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Box;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Box;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Box;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Box;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Box;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Box;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Box;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Box;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Box;
        hover(): anychart.core.cartesian.series.Box;
        hover(index?: number): anychart.core.cartesian.series.Box;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Box;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Box;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Box;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Box;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Box;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Box;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Box;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Box;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Box;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Box;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Box;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Box;
        medianStroke(): anychart.graphics.vector.Stroke | (() => void);
        medianStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Box;
        medianStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Box;
        medianStroke(settings?: Object): anychart.core.cartesian.series.Box;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Box;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Box;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Box;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Box;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Box;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Box;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Box;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Box;
        outlierMarkers(): anychart.core.ui.MarkersFactory;
        outlierMarkers(settings?: Object | boolean | string): anychart.core.cartesian.series.Box;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Box;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Box;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Box;
        select(index?: number): anychart.core.cartesian.series.Box;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Box;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Box;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Box;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Box;
        stemStroke(): anychart.graphics.vector.Stroke | (() => void);
        stemStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Box;
        stemStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Box;
        stemStroke(settings?: Object): anychart.core.cartesian.series.Box;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Box;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Box;
        stroke(settings?: Object): anychart.core.cartesian.series.Box;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Box;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Box;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Box;
        unselect(): anychart.core.cartesian.series.Box;
        unselect(index?: number): anychart.core.cartesian.series.Box;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Box;
        whiskerStroke(): anychart.graphics.vector.Stroke | (() => void);
        whiskerStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Box;
        whiskerStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Box;
        whiskerStroke(settings?: Object): anychart.core.cartesian.series.Box;
        whiskerWidth(): number | string;
        whiskerWidth(width?: number | string): anychart.core.cartesian.series.Box;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Box;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Box;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Box;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Box;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Box;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Box;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Box;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Box;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Box;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Line3d extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Line3d;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Line3d;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Line3d;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Line3d;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Line3d;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Line3d;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Line3d;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Line3d;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Line3d;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Line3d;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Line3d;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Line3d;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Line3d;
        hover(): anychart.core.cartesian.series.Line3d;
        hover(index?: number): anychart.core.cartesian.series.Line3d;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Line3d;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Line3d;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Line3d;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Line3d;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Line3d;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Line3d;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Line3d;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Line3d;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Line3d;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Line3d;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Line3d;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Line3d;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Line3d;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Line3d;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Line3d;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Line3d;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Line3d;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Line3d;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Line3d;
        select(index?: number): anychart.core.cartesian.series.Line3d;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Line3d;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Line3d;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Line3d;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Line3d;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Line3d;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Line3d;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Line3d;
        unselect(): anychart.core.cartesian.series.Line3d;
        unselect(index?: number): anychart.core.cartesian.series.Line3d;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Line3d;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Line3d;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Line3d;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Line3d;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Line3d;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Line3d;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Line3d;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Line3d;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Line3d;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Line3d;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Line3d;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface SplineArea extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.SplineArea;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.SplineArea;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.SplineArea;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.SplineArea;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.SplineArea;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.SplineArea;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.SplineArea;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.SplineArea;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.SplineArea;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.SplineArea;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.SplineArea;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.SplineArea;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.SplineArea;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.SplineArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.SplineArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.SplineArea;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.SplineArea;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.SplineArea;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.SplineArea;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.SplineArea;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.SplineArea;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.SplineArea;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.SplineArea;
        hover(): anychart.core.cartesian.series.SplineArea;
        hover(index?: number): anychart.core.cartesian.series.SplineArea;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.SplineArea;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.SplineArea;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.SplineArea;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.SplineArea;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.SplineArea;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.SplineArea;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.SplineArea;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.SplineArea;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.SplineArea;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.SplineArea;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.SplineArea;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.SplineArea;
        meta(key?: string, value?: any): anychart.core.cartesian.series.SplineArea;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.SplineArea;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.SplineArea;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.SplineArea;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.SplineArea;
        negativeFill(): anychart.graphics.vector.Fill;
        negativeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.SplineArea;
        negativeFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.SplineArea;
        negativeFill(color: string, opacity?: number): anychart.core.cartesian.series.SplineArea;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.SplineArea;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.SplineArea;
        negativeFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.SplineArea;
        negativeStroke(): anychart.graphics.vector.Stroke | (() => void);
        negativeStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.SplineArea;
        negativeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.SplineArea;
        negativeStroke(settings?: Object): anychart.core.cartesian.series.SplineArea;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.SplineArea;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.SplineArea;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.SplineArea;
        select(index?: number): anychart.core.cartesian.series.SplineArea;
        select(indexes?: Array<number>): anychart.core.cartesian.series.SplineArea;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.SplineArea;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.SplineArea;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.SplineArea;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.SplineArea;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.SplineArea;
        stroke(settings?: Object): anychart.core.cartesian.series.SplineArea;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.SplineArea;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.SplineArea;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.SplineArea;
        unselect(): anychart.core.cartesian.series.SplineArea;
        unselect(index?: number): anychart.core.cartesian.series.SplineArea;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.SplineArea;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.SplineArea;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.SplineArea;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.SplineArea;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.SplineArea;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.SplineArea;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.SplineArea;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.SplineArea;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.SplineArea;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.SplineArea;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Spline extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Spline;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Spline;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Spline;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Spline;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Spline;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Spline;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Spline;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Spline;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Spline;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Spline;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Spline;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Spline;
        hover(): anychart.core.cartesian.series.Spline;
        hover(index?: number): anychart.core.cartesian.series.Spline;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Spline;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Spline;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Spline;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Spline;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Spline;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Spline;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Spline;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Spline;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Spline;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Spline;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Spline;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Spline;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Spline;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Spline;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Spline;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Spline;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Spline;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Spline;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Spline;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Spline;
        select(index?: number): anychart.core.cartesian.series.Spline;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Spline;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Spline;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Spline;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Spline;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Spline;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Spline;
        stroke(settings?: Object): anychart.core.cartesian.series.Spline;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Spline;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Spline;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Spline;
        unselect(): anychart.core.cartesian.series.Spline;
        unselect(index?: number): anychart.core.cartesian.series.Spline;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Spline;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Spline;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Spline;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Spline;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Spline;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Spline;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Spline;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Spline;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Spline;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Spline;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface DiscreteBase extends anychart.core.cartesian.series.BaseWithMarkers {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.DiscreteBase;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        unhover(): anychart.core.cartesian.series.DiscreteBase;
        unhover(index?: number): anychart.core.cartesian.series.DiscreteBase;
        unhover(indexes?: Array<number>): anychart.core.cartesian.series.DiscreteBase;
        unselect(): anychart.core.cartesian.series.DiscreteBase;
        unselect(index?: number): anychart.core.cartesian.series.DiscreteBase;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.DiscreteBase;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.DiscreteBase;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.DiscreteBase;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.DiscreteBase;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.DiscreteBase;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.DiscreteBase;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.DiscreteBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.DiscreteBase;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.DiscreteBase;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.DiscreteBase;
        hover(): anychart.core.cartesian.series.DiscreteBase;
        hover(index?: number): anychart.core.cartesian.series.DiscreteBase;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.DiscreteBase;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.DiscreteBase;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.DiscreteBase;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.DiscreteBase;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.DiscreteBase;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.DiscreteBase;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.DiscreteBase;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.DiscreteBase;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.DiscreteBase;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.DiscreteBase;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.DiscreteBase;
        meta(key?: string, value?: any): anychart.core.cartesian.series.DiscreteBase;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.DiscreteBase;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.DiscreteBase;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.DiscreteBase;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.DiscreteBase;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.DiscreteBase;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.DiscreteBase;
        select(index?: number): anychart.core.cartesian.series.DiscreteBase;
        select(indexes?: Array<number>): anychart.core.cartesian.series.DiscreteBase;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.DiscreteBase;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.DiscreteBase;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.DiscreteBase;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.DiscreteBase;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.DiscreteBase;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.DiscreteBase;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.DiscreteBase;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.DiscreteBase;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.DiscreteBase;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.DiscreteBase;
        getStat(key: string): any;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.DiscreteBase;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.DiscreteBase;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.DiscreteBase;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.DiscreteBase;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.DiscreteBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.DiscreteBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.DiscreteBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface RangeStepArea extends anychart.core.cartesian.series.ContinuousRangeBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.RangeStepArea;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.RangeStepArea;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.RangeStepArea;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.RangeStepArea;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.RangeStepArea;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeStepArea;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.RangeStepArea;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.RangeStepArea;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeStepArea;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.RangeStepArea;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.RangeStepArea;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeStepArea;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeStepArea;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.RangeStepArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeStepArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeStepArea;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeStepArea;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.RangeStepArea;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.RangeStepArea;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.RangeStepArea;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.RangeStepArea;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.RangeStepArea;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.RangeStepArea;
        highStroke(): anychart.graphics.vector.Stroke | (() => void);
        highStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeStepArea;
        highStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeStepArea;
        highStroke(settings?: Object): anychart.core.cartesian.series.RangeStepArea;
        hover(): anychart.core.cartesian.series.RangeStepArea;
        hover(index?: number): anychart.core.cartesian.series.RangeStepArea;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.RangeStepArea;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.RangeStepArea;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.RangeStepArea;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.RangeStepArea;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.RangeStepArea;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.RangeStepArea;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.RangeStepArea;
        lowStroke(): anychart.graphics.vector.Stroke | (() => void);
        lowStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeStepArea;
        lowStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeStepArea;
        lowStroke(settings?: Object): anychart.core.cartesian.series.RangeStepArea;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.RangeStepArea;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.RangeStepArea;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeStepArea;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.RangeStepArea;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.RangeStepArea;
        meta(key?: string, value?: any): anychart.core.cartesian.series.RangeStepArea;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.RangeStepArea;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeStepArea;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.RangeStepArea;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.RangeStepArea;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.RangeStepArea;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.RangeStepArea;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.RangeStepArea;
        select(index?: number): anychart.core.cartesian.series.RangeStepArea;
        select(indexes?: Array<number>): anychart.core.cartesian.series.RangeStepArea;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.RangeStepArea;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.RangeStepArea;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.RangeStepArea;
        stepDirection(): string;
        stepDirection(direction?: string): anychart.core.cartesian.series.RangeStepArea;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.RangeStepArea;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.RangeStepArea;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.RangeStepArea;
        unselect(): anychart.core.cartesian.series.RangeStepArea;
        unselect(index?: number): anychart.core.cartesian.series.RangeStepArea;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.RangeStepArea;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.RangeStepArea;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.RangeStepArea;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeStepArea;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeStepArea;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.RangeStepArea;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.RangeStepArea;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.RangeStepArea;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.RangeStepArea;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.RangeStepArea;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface StepArea extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.StepArea;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.StepArea;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.StepArea;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.StepArea;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.StepArea;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.StepArea;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.StepArea;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.StepArea;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.StepArea;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.StepArea;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.StepArea;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.StepArea;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.StepArea;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.StepArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.StepArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.StepArea;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.StepArea;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.StepArea;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.StepArea;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.StepArea;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.StepArea;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.StepArea;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.StepArea;
        hover(): anychart.core.cartesian.series.StepArea;
        hover(index?: number): anychart.core.cartesian.series.StepArea;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.StepArea;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.StepArea;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.StepArea;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.StepArea;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.StepArea;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.StepArea;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.StepArea;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.StepArea;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.StepArea;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.StepArea;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.StepArea;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.StepArea;
        meta(key?: string, value?: any): anychart.core.cartesian.series.StepArea;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.StepArea;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.StepArea;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.StepArea;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.StepArea;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.StepArea;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.StepArea;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.StepArea;
        select(index?: number): anychart.core.cartesian.series.StepArea;
        select(indexes?: Array<number>): anychart.core.cartesian.series.StepArea;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.StepArea;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.StepArea;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.StepArea;
        stepDirection(): string;
        stepDirection(direction?: string): anychart.core.cartesian.series.StepArea;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.StepArea;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.StepArea;
        stroke(settings?: Object): anychart.core.cartesian.series.StepArea;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.StepArea;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.StepArea;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.StepArea;
        unselect(): anychart.core.cartesian.series.StepArea;
        unselect(index?: number): anychart.core.cartesian.series.StepArea;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.StepArea;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.StepArea;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.StepArea;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.StepArea;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.StepArea;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.StepArea;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.StepArea;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.StepArea;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.StepArea;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.StepArea;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Base extends anychart.core.SeriesBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Base;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Base;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Base;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Base;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Base;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Base;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Base;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Base;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Base;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Base;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Base;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Base;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Base;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Base;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Base;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Base;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Base;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Base;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Base;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Base;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Base;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Base;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Base;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Base;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Base;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Base;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Base;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Base;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Base;
        select(index?: number): anychart.core.cartesian.series.Base;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Base;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Base;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Base;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Base;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Base;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Base;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Base;
        unselect(): anychart.core.cartesian.series.Base;
        unselect(index?: number): anychart.core.cartesian.series.Base;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Base;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Base;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Base;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Base;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Base;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Base;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Base;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Base;
        hover(): anychart.core.cartesian.series.Base;
        hover(index?: number): anychart.core.cartesian.series.Base;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Base;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Base;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Base;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Base;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface RangeBar extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.RangeBar;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.RangeBar;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.RangeBar;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.RangeBar;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.RangeBar;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeBar;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.RangeBar;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeBar;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.RangeBar;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.RangeBar;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeBar;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeBar;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.RangeBar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeBar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeBar;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeBar;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.RangeBar;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.RangeBar;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.RangeBar;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.RangeBar;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.RangeBar;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.RangeBar;
        hover(): anychart.core.cartesian.series.RangeBar;
        hover(index?: number): anychart.core.cartesian.series.RangeBar;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.RangeBar;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.RangeBar;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.RangeBar;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.RangeBar;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.RangeBar;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.RangeBar;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.RangeBar;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.RangeBar;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.RangeBar;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeBar;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.RangeBar;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.RangeBar;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.RangeBar;
        meta(key?: string, value?: any): anychart.core.cartesian.series.RangeBar;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.RangeBar;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeBar;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.RangeBar;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.RangeBar;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.RangeBar;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.RangeBar;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.RangeBar;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.RangeBar;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.RangeBar;
        select(index?: number): anychart.core.cartesian.series.RangeBar;
        select(indexes?: Array<number>): anychart.core.cartesian.series.RangeBar;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.RangeBar;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.RangeBar;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.RangeBar;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeBar;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeBar;
        stroke(settings?: Object): anychart.core.cartesian.series.RangeBar;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.RangeBar;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.RangeBar;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.RangeBar;
        unselect(): anychart.core.cartesian.series.RangeBar;
        unselect(index?: number): anychart.core.cartesian.series.RangeBar;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.RangeBar;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.RangeBar;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.RangeBar;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.RangeBar;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeBar;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeBar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.RangeBar;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.RangeBar;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.RangeBar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.RangeBar;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Column3d extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Column3d;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Column3d;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Column3d;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Column3d;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Column3d;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Column3d;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Column3d;
        data(): anychart.data.View;
        data(data?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Column3d;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Column3d;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Column3d;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | string | Array<any>): anychart.core.cartesian.series.Column3d;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Column3d;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Column3d;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Column3d;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Column3d;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Column3d;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Column3d;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Column3d;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Column3d;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Column3d;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Column3d;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Column3d;
        hover(): anychart.core.cartesian.series.Column3d;
        hover(index?: number): anychart.core.cartesian.series.Column3d;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Column3d;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Column3d;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Column3d;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Column3d;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Column3d;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Column3d;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Column3d;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Column3d;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Column3d;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Column3d;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Column3d;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Column3d;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Column3d;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Column3d;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Column3d;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Column3d;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Column3d;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Column3d;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Column3d;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Column3d;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Column3d;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Column3d;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Column3d;
        select(index?: number): anychart.core.cartesian.series.Column3d;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Column3d;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Column3d;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Column3d;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Column3d;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Column3d;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Column3d;
        stroke(settings?: Object): anychart.core.cartesian.series.Column3d;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Column3d;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Column3d;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Column3d;
        unselect(): anychart.core.cartesian.series.Column3d;
        unselect(index?: number): anychart.core.cartesian.series.Column3d;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Column3d;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Column3d;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Column3d;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Column3d;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Column3d;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Column3d;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Column3d;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Column3d;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Column3d;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Column3d;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface ContinuousRangeBase extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.ContinuousRangeBase;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.ContinuousRangeBase;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.ContinuousRangeBase;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.ContinuousRangeBase;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.ContinuousRangeBase;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.ContinuousRangeBase;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.ContinuousRangeBase;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.ContinuousRangeBase;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.ContinuousRangeBase;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.ContinuousRangeBase;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.ContinuousRangeBase;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.ContinuousRangeBase;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        highStroke(): anychart.graphics.vector.Stroke | (() => void);
        highStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.ContinuousRangeBase;
        highStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.ContinuousRangeBase;
        highStroke(settings?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        hover(): anychart.core.cartesian.series.ContinuousRangeBase;
        hover(index?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousRangeBase;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.ContinuousRangeBase;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        lowStroke(): anychart.graphics.vector.Stroke | (() => void);
        lowStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.ContinuousRangeBase;
        lowStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.ContinuousRangeBase;
        lowStroke(settings?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.ContinuousRangeBase;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.ContinuousRangeBase;
        meta(key?: string, value?: any): anychart.core.cartesian.series.ContinuousRangeBase;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.ContinuousRangeBase;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        select(index?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        select(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousRangeBase;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.ContinuousRangeBase;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.ContinuousRangeBase;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.ContinuousRangeBase;
        unselect(): anychart.core.cartesian.series.ContinuousRangeBase;
        unselect(index?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.ContinuousRangeBase;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.ContinuousRangeBase;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.ContinuousRangeBase;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.ContinuousRangeBase;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.ContinuousRangeBase;
        getStat(key: string): any;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.ContinuousRangeBase;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.ContinuousRangeBase;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.ContinuousRangeBase;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.ContinuousRangeBase;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.ContinuousRangeBase;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.ContinuousRangeBase;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.ContinuousRangeBase;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Area extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Area;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Area;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Area;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Area;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Area;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Area;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Area;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Area;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Area;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Area;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Area;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Area;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Area;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Area;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Area;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Area;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Area;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Area;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Area;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Area;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Area;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Area;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Area;
        hover(): anychart.core.cartesian.series.Area;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Area;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Area;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Area;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Area;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Area;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Area;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Area;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Area;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Area;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Area;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Area;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Area;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Area;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Area;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Area;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Area;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Area;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Area;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Area;
        select(): anychart.core.cartesian.series.Area;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Area;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Area;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Area;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Area;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Area;
        stroke(settings?: Object): anychart.core.cartesian.series.Area;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.core.cartesian.series.Area;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Area;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Area;
        unselect(): anychart.core.cartesian.series.Area;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Area;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Area;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Area;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Area;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Area;
        getPixelPointWidth(): number;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Area;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Area;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Area;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Area;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Stick extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Stick;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Stick;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Stick;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Stick;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Stick;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Stick;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Stick;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Stick;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Stick;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Stick;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Stick;
        hover(): anychart.core.cartesian.series.Stick;
        hover(index?: number): anychart.core.cartesian.series.Stick;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Stick;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Stick;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Stick;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Stick;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Stick;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Stick;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Stick;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Stick;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Stick;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Stick;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Stick;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Stick;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Stick;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Stick;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Stick;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Stick;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Stick;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Stick;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Stick;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Stick;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Stick;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Stick;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Stick;
        select(index?: number): anychart.core.cartesian.series.Stick;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Stick;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Stick;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Stick;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Stick;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Stick;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Stick;
        stroke(settings?: Object): anychart.core.cartesian.series.Stick;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Stick;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Stick;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Stick;
        unselect(): anychart.core.cartesian.series.Stick;
        unselect(index?: number): anychart.core.cartesian.series.Stick;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Stick;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Stick;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Stick;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Stick;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Stick;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Stick;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Stick;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Stick;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Stick;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Stick;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Bubble extends anychart.core.cartesian.series.BaseWithMarkers {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Bubble;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Bubble;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Bubble;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Bubble;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Bubble;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bubble;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Bubble;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bubble;
        displayNegative(): boolean;
        displayNegative(enabled?: boolean): anychart.core.cartesian.series.Bubble;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Bubble;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Bubble;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Bubble;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Bubble;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Bubble;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Bubble;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Bubble;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bubble;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Bubble;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Bubble;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Bubble;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Bubble;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Bubble;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Bubble;
        hover(): anychart.core.cartesian.series.Bubble;
        hover(index?: number): anychart.core.cartesian.series.Bubble;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Bubble;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Bubble;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Bubble;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Bubble;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Bubble;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Bubble;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Bubble;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Bubble;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Bubble;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bubble;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Bubble;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Bubble;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Bubble;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Bubble;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bubble;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Bubble;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Bubble;
        negativeFill(): anychart.graphics.vector.Fill;
        negativeFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Bubble;
        negativeFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Bubble;
        negativeFill(color: string, opacity?: number): anychart.core.cartesian.series.Bubble;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Bubble;
        negativeFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Bubble;
        negativeFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bubble;
        negativeHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        negativeHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Bubble;
        negativeHatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Bubble;
        negativeHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Bubble;
        negativeHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Bubble;
        negativeHatchFill(enabled?: boolean): anychart.core.cartesian.series.Bubble;
        negativeStroke(): anychart.graphics.vector.Stroke | (() => void);
        negativeStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Bubble;
        negativeStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Bubble;
        negativeStroke(settings?: Object): anychart.core.cartesian.series.Bubble;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Bubble;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Bubble;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Bubble;
        select(index?: number): anychart.core.cartesian.series.Bubble;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Bubble;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Bubble;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Bubble;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Bubble;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Bubble;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Bubble;
        stroke(settings?: Object): anychart.core.cartesian.series.Bubble;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Bubble;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Bubble;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Bubble;
        unselect(): anychart.core.cartesian.series.Bubble;
        unselect(index?: number): anychart.core.cartesian.series.Bubble;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Bubble;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Bubble;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Bubble;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Bubble;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bubble;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bubble;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Bubble;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Bubble;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Bubble;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Bubble;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Bar extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Bar;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Bar;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Bar;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Bar;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Bar;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bar;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Bar;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bar;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Bar;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Bar;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Bar;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Bar;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Bar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Bar;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Bar;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bar;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Bar;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Bar;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Bar;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Bar;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Bar;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Bar;
        hover(): anychart.core.cartesian.series.Bar;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Bar;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Bar;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Bar;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Bar;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Bar;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Bar;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Bar;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Bar;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bar;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Bar;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Bar;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Bar;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Bar;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Bar;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bar;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Bar;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Bar;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Bar;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Bar;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Bar;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Bar;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Bar;
        select(): anychart.core.cartesian.series.Bar;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Bar;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Bar;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Bar;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Bar;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Bar;
        stroke(settings?: Object): anychart.core.cartesian.series.Bar;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Bar;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Bar;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Bar;
        unselect(): anychart.core.cartesian.series.Bar;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Bar;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Bar;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Bar;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bar;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bar;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Bar;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Bar;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Bar;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Bar;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Area3d extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Area3d;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Area3d;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Area3d;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Area3d;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Area3d;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Area3d;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Area3d;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Area3d;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Area3d;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Area3d;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Area3d;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Area3d;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Area3d;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Area3d;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Area3d;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Area3d;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Area3d;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Area3d;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Area3d;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Area3d;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Area3d;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Area3d;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Area3d;
        hover(): anychart.core.cartesian.series.Area3d;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Area3d;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Area3d;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Area3d;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Area3d;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Area3d;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Area3d;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Area3d;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Area3d;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Area3d;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Area3d;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Area3d;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Area3d;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Area3d;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Area3d;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Area3d;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Area3d;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Area3d;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Area3d;
        select(): anychart.core.cartesian.series.Area3d;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Area3d;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Area3d;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Area3d;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Area3d;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Area3d;
        stroke(settings?: Object): anychart.core.cartesian.series.Area3d;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Area3d;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Area3d;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Area3d;
        unselect(): anychart.core.cartesian.series.Area3d;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Area3d;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Area3d;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Area3d;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Area3d;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Area3d;
        getPixelPointWidth(): number;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Area3d;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Area3d;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Area3d;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Area3d;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Area3d;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface OHLC extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.OHLC;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.OHLC;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.OHLC;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.OHLC;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.OHLC;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.OHLC;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.OHLC;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.OHLC;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.OHLC;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.OHLC;
        excludePoint(indexes: number | Array<number>): boolean;
        fallingStroke(): anychart.graphics.vector.Stroke | (() => void);
        fallingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.OHLC;
        fallingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.OHLC;
        fallingStroke(settings?: Object): anychart.core.cartesian.series.OHLC;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.OHLC;
        hover(): anychart.core.cartesian.series.OHLC;
        hover(index?: number): anychart.core.cartesian.series.OHLC;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.OHLC;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.OHLC;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.OHLC;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.OHLC;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.OHLC;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.OHLC;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.OHLC;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.OHLC;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.OHLC;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.OHLC;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.OHLC;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.OHLC;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.OHLC;
        meta(key?: string, value?: any): anychart.core.cartesian.series.OHLC;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.OHLC;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.OHLC;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.OHLC;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.OHLC;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.OHLC;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.OHLC;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.OHLC;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.OHLC;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.OHLC;
        risingStroke(): anychart.graphics.vector.Stroke | (() => void);
        risingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.OHLC;
        risingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.OHLC;
        risingStroke(settings?: Object): anychart.core.cartesian.series.OHLC;
        select(index?: number): anychart.core.cartesian.series.OHLC;
        select(indexes?: Array<number>): anychart.core.cartesian.series.OHLC;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.OHLC;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.OHLC;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.OHLC;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.OHLC;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.OHLC;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.OHLC;
        unselect(): anychart.core.cartesian.series.OHLC;
        unselect(index?: number): anychart.core.cartesian.series.OHLC;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.OHLC;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.OHLC;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.OHLC;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.OHLC;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.OHLC;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.OHLC;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.OHLC;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.OHLC;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.OHLC;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.OHLC;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Candlestick extends anychart.core.cartesian.series.OHLC {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Candlestick;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Candlestick;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Candlestick;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Candlestick;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Candlestick;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Candlestick;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Candlestick;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Candlestick;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Candlestick;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Candlestick;
        excludePoint(indexes: number | Array<number>): boolean;
        fallingFill(): anychart.graphics.vector.Fill;
        fallingFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Candlestick;
        fallingFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Candlestick;
        fallingFill(color: string, opacity?: number): anychart.core.cartesian.series.Candlestick;
        fallingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Candlestick;
        fallingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Candlestick;
        fallingFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Candlestick;
        fallingHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        fallingHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Candlestick;
        fallingHatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Candlestick;
        fallingHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Candlestick;
        fallingHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Candlestick;
        fallingHatchFill(enabled?: boolean): anychart.core.cartesian.series.Candlestick;
        fallingStroke(): anychart.graphics.vector.Stroke | (() => void);
        fallingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Candlestick;
        fallingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Candlestick;
        fallingStroke(settings?: Object): anychart.core.cartesian.series.Candlestick;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Candlestick;
        hover(): anychart.core.cartesian.series.Candlestick;
        hover(index?: number): anychart.core.cartesian.series.Candlestick;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Candlestick;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Candlestick;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Candlestick;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Candlestick;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Candlestick;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Candlestick;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Candlestick;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Candlestick;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Candlestick;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Candlestick;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Candlestick;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Candlestick;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Candlestick;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Candlestick;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Candlestick;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Candlestick;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Candlestick;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Candlestick;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Candlestick;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Candlestick;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Candlestick;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Candlestick;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Candlestick;
        risingFill(): anychart.graphics.vector.Fill;
        risingFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Candlestick;
        risingFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Candlestick;
        risingFill(color: string, opacity?: number): anychart.core.cartesian.series.Candlestick;
        risingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Candlestick;
        risingFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Candlestick;
        risingFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Candlestick;
        risingHatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        risingHatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Candlestick;
        risingHatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Candlestick;
        risingHatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Candlestick;
        risingHatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Candlestick;
        risingHatchFill(enabled?: boolean): anychart.core.cartesian.series.Candlestick;
        risingStroke(): anychart.graphics.vector.Stroke | (() => void);
        risingStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Candlestick;
        risingStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Candlestick;
        risingStroke(settings?: Object): anychart.core.cartesian.series.Candlestick;
        select(index?: number): anychart.core.cartesian.series.Candlestick;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Candlestick;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Candlestick;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Candlestick;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Candlestick;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Candlestick;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Candlestick;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Candlestick;
        unselect(): anychart.core.cartesian.series.Candlestick;
        unselect(index?: number): anychart.core.cartesian.series.Candlestick;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Candlestick;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Candlestick;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Candlestick;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Candlestick;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Candlestick;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Candlestick;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Candlestick;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Candlestick;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Candlestick;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Candlestick;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Column extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Column;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Column;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Column;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Column;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Column;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Column;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Column;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Column;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Column;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Column;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Column;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Column;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Column;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Column;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Column;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Column;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Column;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Column;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Column;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Column;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Column;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Column;
        hover(): anychart.core.cartesian.series.Column;
        hover(index?: number): anychart.core.cartesian.series.Column;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Column;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Column;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Column;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Column;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Column;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Column;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Column;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Column;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Column;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Column;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Column;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Column;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Column;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Column;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Column;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Column;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Column;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Column;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Column;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Column;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Column;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Column;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Column;
        select(): anychart.core.cartesian.series.Column;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Column;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Column;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Column;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Column;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Column;
        stroke(settings?: Object): anychart.core.cartesian.series.Column;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Column;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Column;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Column;
        unselect(): anychart.core.cartesian.series.Column;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Column;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Column;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Column;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Column;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Column;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Column;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Column;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Column;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Column;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface WidthBased extends anychart.core.cartesian.series.BaseWithMarkers {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.WidthBased;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.WidthBased;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.WidthBased;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.WidthBased;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.WidthBased;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.WidthBased;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.WidthBased;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.WidthBased;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.WidthBased;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.WidthBased;
        hover(): anychart.core.cartesian.series.WidthBased;
        hover(index?: number): anychart.core.cartesian.series.WidthBased;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.WidthBased;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.WidthBased;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.WidthBased;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.WidthBased;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.WidthBased;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.WidthBased;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.WidthBased;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.WidthBased;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.WidthBased;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.WidthBased;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.WidthBased;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.WidthBased;
        meta(key?: string, value?: any): anychart.core.cartesian.series.WidthBased;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.WidthBased;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.WidthBased;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.WidthBased;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.WidthBased;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.WidthBased;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.WidthBased;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.WidthBased;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.WidthBased;
        select(index?: number): anychart.core.cartesian.series.WidthBased;
        select(indexes?: Array<number>): anychart.core.cartesian.series.WidthBased;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.WidthBased;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.WidthBased;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.WidthBased;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.WidthBased;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.WidthBased;
        unselect(): anychart.core.cartesian.series.WidthBased;
        unselect(index?: number): anychart.core.cartesian.series.WidthBased;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.WidthBased;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.WidthBased;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.WidthBased;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.WidthBased;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.WidthBased;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.WidthBased;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.WidthBased;
        getStat(key: string): any;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.WidthBased;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.WidthBased;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.WidthBased;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.WidthBased;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.WidthBased;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.WidthBased;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.WidthBased;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface RangeArea extends anychart.core.cartesian.series.ContinuousRangeBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.RangeArea;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.RangeArea;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.RangeArea;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.RangeArea;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.RangeArea;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeArea;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.RangeArea;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.RangeArea;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeArea;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.RangeArea;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.RangeArea;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeArea;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeArea;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.RangeArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeArea;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeArea;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.RangeArea;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.RangeArea;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.RangeArea;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.RangeArea;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.RangeArea;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.RangeArea;
        highStroke(): anychart.graphics.vector.Stroke | (() => void);
        highStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeArea;
        highStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeArea;
        highStroke(settings?: Object): anychart.core.cartesian.series.RangeArea;
        hover(): anychart.core.cartesian.series.RangeArea;
        hover(index?: number): anychart.core.cartesian.series.RangeArea;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.RangeArea;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.RangeArea;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.RangeArea;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.RangeArea;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.RangeArea;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.RangeArea;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.RangeArea;
        lowStroke(): anychart.graphics.vector.Stroke | (() => void);
        lowStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeArea;
        lowStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeArea;
        lowStroke(settings?: Object): anychart.core.cartesian.series.RangeArea;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.RangeArea;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.RangeArea;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeArea;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.RangeArea;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.RangeArea;
        meta(key?: string, value?: any): anychart.core.cartesian.series.RangeArea;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.RangeArea;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeArea;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.RangeArea;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.RangeArea;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.RangeArea;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.RangeArea;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.RangeArea;
        select(index?: number): anychart.core.cartesian.series.RangeArea;
        select(indexes?: Array<number>): anychart.core.cartesian.series.RangeArea;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.RangeArea;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.RangeArea;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.RangeArea;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.RangeArea;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.RangeArea;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.RangeArea;
        unselect(): anychart.core.cartesian.series.RangeArea;
        unselect(index?: number): anychart.core.cartesian.series.RangeArea;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.RangeArea;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.RangeArea;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.RangeArea;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeArea;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeArea;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.RangeArea;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.RangeArea;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.RangeArea;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.RangeArea;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.RangeArea;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface BaseWithMarkers extends anychart.core.cartesian.series.Base {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.BaseWithMarkers;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.BaseWithMarkers;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.BaseWithMarkers;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.BaseWithMarkers;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.BaseWithMarkers;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.BaseWithMarkers;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.BaseWithMarkers;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        hover(): anychart.core.cartesian.series.BaseWithMarkers;
        hover(index?: number): anychart.core.cartesian.series.BaseWithMarkers;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.BaseWithMarkers;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.BaseWithMarkers;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.BaseWithMarkers;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.BaseWithMarkers;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.BaseWithMarkers;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.BaseWithMarkers;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.BaseWithMarkers;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.BaseWithMarkers;
        meta(key?: string, value?: any): anychart.core.cartesian.series.BaseWithMarkers;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.BaseWithMarkers;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.BaseWithMarkers;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.BaseWithMarkers;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        select(index?: number): anychart.core.cartesian.series.BaseWithMarkers;
        select(indexes?: Array<number>): anychart.core.cartesian.series.BaseWithMarkers;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.BaseWithMarkers;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.BaseWithMarkers;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.BaseWithMarkers;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.BaseWithMarkers;
        unselect(): anychart.core.cartesian.series.BaseWithMarkers;
        unselect(index?: number): anychart.core.cartesian.series.BaseWithMarkers;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.BaseWithMarkers;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.BaseWithMarkers;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.BaseWithMarkers;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.BaseWithMarkers;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.BaseWithMarkers;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.BaseWithMarkers;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.BaseWithMarkers;
        getStat(key: string): any;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.BaseWithMarkers;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.BaseWithMarkers;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.BaseWithMarkers;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.BaseWithMarkers;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.BaseWithMarkers;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.BaseWithMarkers;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.BaseWithMarkers;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface JumpLine extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.JumpLine;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.JumpLine;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.JumpLine;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.JumpLine;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.JumpLine;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.JumpLine;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.JumpLine;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.JumpLine;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.JumpLine;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.JumpLine;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.JumpLine;
        hover(): anychart.core.cartesian.series.JumpLine;
        hover(index?: number): anychart.core.cartesian.series.JumpLine;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.JumpLine;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.JumpLine;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.JumpLine;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.JumpLine;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.JumpLine;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.JumpLine;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.JumpLine;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.JumpLine;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.JumpLine;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.JumpLine;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.JumpLine;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.JumpLine;
        meta(key?: string, value?: any): anychart.core.cartesian.series.JumpLine;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.JumpLine;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.JumpLine;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.JumpLine;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.JumpLine;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.JumpLine;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.JumpLine;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.JumpLine;
        select(index?: number): anychart.core.cartesian.series.JumpLine;
        select(indexes?: Array<number>): anychart.core.cartesian.series.JumpLine;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.JumpLine;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.JumpLine;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.JumpLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.JumpLine;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.JumpLine;
        stroke(settings?: Object): anychart.core.cartesian.series.JumpLine;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.JumpLine;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.JumpLine;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.JumpLine;
        unselect(): anychart.core.cartesian.series.JumpLine;
        unselect(index?: number): anychart.core.cartesian.series.JumpLine;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.JumpLine;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.JumpLine;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.JumpLine;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.JumpLine;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.JumpLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.JumpLine;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.JumpLine;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.JumpLine;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.JumpLine;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.JumpLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.JumpLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.JumpLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.JumpLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface StepLine extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.StepLine;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.StepLine;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.StepLine;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.StepLine;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.StepLine;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.StepLine;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.StepLine;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.StepLine;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.StepLine;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.StepLine;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.StepLine;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.StepLine;
        hover(): anychart.core.cartesian.series.StepLine;
        hover(index?: number): anychart.core.cartesian.series.StepLine;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.StepLine;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.StepLine;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.StepLine;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.StepLine;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.StepLine;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.StepLine;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.StepLine;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.StepLine;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.StepLine;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.StepLine;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.StepLine;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.StepLine;
        meta(key?: string, value?: any): anychart.core.cartesian.series.StepLine;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.StepLine;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.StepLine;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.StepLine;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.StepLine;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.StepLine;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.StepLine;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.StepLine;
        select(index?: number): anychart.core.cartesian.series.StepLine;
        select(indexes?: Array<number>): anychart.core.cartesian.series.StepLine;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.StepLine;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.StepLine;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.StepLine;
        stepDirection(): string;
        stepDirection(direction?: string): anychart.core.cartesian.series.StepLine;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.StepLine;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.StepLine;
        stroke(settings?: Object): anychart.core.cartesian.series.StepLine;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.StepLine;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.StepLine;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.StepLine;
        unselect(): anychart.core.cartesian.series.StepLine;
        unselect(index?: number): anychart.core.cartesian.series.StepLine;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.StepLine;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.StepLine;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.StepLine;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.StepLine;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.StepLine;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.StepLine;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.StepLine;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.StepLine;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.StepLine;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.StepLine;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Line extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Line;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Line;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Line;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Line;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Line;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Line;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Line;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Line;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Line;
        draw(): anychart.core.cartesian.series.Line;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Line;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Line;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getIterator(): anychart.data.Iterator;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getResetIterator(): anychart.data.Iterator;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Line;
        hover(): anychart.core.cartesian.series.Line;
        hover(index?: number): anychart.core.cartesian.series.Line;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Line;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Line;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Line;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Line;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Line;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Line;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Line;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Line;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Line;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Line;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Line;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Line;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Line;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Line;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Line;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Line;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Line;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Line;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Line;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Line;
        select(index?: number): anychart.core.cartesian.series.Line;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Line;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Line;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Line;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Line;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Line;
        stroke(settings?: Object): anychart.core.cartesian.series.Line;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Line;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Line;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Line;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Line;
        unselect(): anychart.core.cartesian.series.Line;
        unselect(index?: number): anychart.core.cartesian.series.Line;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Line;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Line;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Line;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Line;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Line;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Line;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Line;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Line;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Line;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Line;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface RangeColumn extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.RangeColumn;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.RangeColumn;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.RangeColumn;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.RangeColumn;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.RangeColumn;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeColumn;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.RangeColumn;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeColumn;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.RangeColumn;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.RangeColumn;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeColumn;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeColumn;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.RangeColumn;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeColumn;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeColumn;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeColumn;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.RangeColumn;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.RangeColumn;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.RangeColumn;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.RangeColumn;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.RangeColumn;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.RangeColumn;
        hover(): anychart.core.cartesian.series.RangeColumn;
        hover(index?: number): anychart.core.cartesian.series.RangeColumn;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.RangeColumn;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.RangeColumn;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.RangeColumn;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.RangeColumn;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.RangeColumn;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.RangeColumn;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.RangeColumn;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.RangeColumn;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.RangeColumn;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeColumn;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.RangeColumn;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.RangeColumn;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.RangeColumn;
        meta(key?: string, value?: any): anychart.core.cartesian.series.RangeColumn;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.RangeColumn;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeColumn;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.RangeColumn;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.RangeColumn;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.RangeColumn;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.RangeColumn;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.RangeColumn;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.RangeColumn;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.RangeColumn;
        select(index?: number): anychart.core.cartesian.series.RangeColumn;
        select(indexes?: Array<number>): anychart.core.cartesian.series.RangeColumn;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.RangeColumn;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.RangeColumn;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.RangeColumn;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeColumn;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeColumn;
        stroke(settings?: Object): anychart.core.cartesian.series.RangeColumn;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(settings?: Object | boolean): anychart.core.cartesian.series.RangeColumn;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.RangeColumn;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.RangeColumn;
        unselect(): anychart.core.cartesian.series.RangeColumn;
        unselect(index?: number): anychart.core.cartesian.series.RangeColumn;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.RangeColumn;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.RangeColumn;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.RangeColumn;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.RangeColumn;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeColumn;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeColumn;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.RangeColumn;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.RangeColumn;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.RangeColumn;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.RangeColumn;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface RangeSplineArea extends anychart.core.cartesian.series.ContinuousRangeBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.RangeSplineArea;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.RangeSplineArea;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.RangeSplineArea;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeSplineArea;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.RangeSplineArea;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.RangeSplineArea;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.RangeSplineArea;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.RangeSplineArea;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.RangeSplineArea;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeSplineArea;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeSplineArea;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeSplineArea;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeSplineArea;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.RangeSplineArea;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.RangeSplineArea;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.RangeSplineArea;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.RangeSplineArea;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.RangeSplineArea;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        highFill(): anychart.graphics.vector.Fill;
        highFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeSplineArea;
        highFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeSplineArea;
        highFill(color: string, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        highFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        highFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeSplineArea;
        highFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeSplineArea;
        highStroke(): anychart.graphics.vector.Stroke | (() => void);
        highStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeSplineArea;
        highStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeSplineArea;
        highStroke(settings?: Object): anychart.core.cartesian.series.RangeSplineArea;
        hover(): anychart.core.cartesian.series.RangeSplineArea;
        hover(index?: number): anychart.core.cartesian.series.RangeSplineArea;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.RangeSplineArea;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.RangeSplineArea;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.RangeSplineArea;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.RangeSplineArea;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.RangeSplineArea;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(): anychart.graphics.vector.Fill;
        lowFill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(color: string, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.RangeSplineArea;
        lowFill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.RangeSplineArea;
        lowStroke(): anychart.graphics.vector.Stroke | (() => void);
        lowStroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.RangeSplineArea;
        lowStroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.RangeSplineArea;
        lowStroke(settings?: Object): anychart.core.cartesian.series.RangeSplineArea;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.RangeSplineArea;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeSplineArea;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.RangeSplineArea;
        meta(key?: string, value?: any): anychart.core.cartesian.series.RangeSplineArea;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.RangeSplineArea;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.RangeSplineArea;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.RangeSplineArea;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.RangeSplineArea;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        select(index?: number): anychart.core.cartesian.series.RangeSplineArea;
        select(indexes?: Array<number>): anychart.core.cartesian.series.RangeSplineArea;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.RangeSplineArea;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.RangeSplineArea;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.RangeSplineArea;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.RangeSplineArea;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.RangeSplineArea;
        unselect(): anychart.core.cartesian.series.RangeSplineArea;
        unselect(index?: number): anychart.core.cartesian.series.RangeSplineArea;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.RangeSplineArea;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.RangeSplineArea;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.RangeSplineArea;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeSplineArea;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.RangeSplineArea;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.RangeSplineArea;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.RangeSplineArea;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.RangeSplineArea;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.RangeSplineArea;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.RangeSplineArea;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Hilo extends anychart.core.cartesian.series.ContinuousBase {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Hilo;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Hilo;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Hilo;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Hilo;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Hilo;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Hilo;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Hilo;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Hilo;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Hilo;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Hilo;
        hover(): anychart.core.cartesian.series.Hilo;
        hover(index?: number): anychart.core.cartesian.series.Hilo;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Hilo;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Hilo;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Hilo;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Hilo;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Hilo;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Hilo;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Hilo;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Hilo;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Hilo;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Hilo;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Hilo;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Hilo;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Hilo;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Hilo;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Hilo;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Hilo;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Hilo;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Hilo;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Hilo;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Hilo;
        select(index?: number): anychart.core.cartesian.series.Hilo;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Hilo;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Hilo;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Hilo;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Hilo;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Hilo;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Hilo;
        stroke(settings?: Object): anychart.core.cartesian.series.Hilo;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Hilo;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Hilo;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(): anychart.core.cartesian.series.Hilo;
        unselect(): anychart.core.cartesian.series.Hilo;
        unselect(index?: number): anychart.core.cartesian.series.Hilo;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Hilo;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Hilo;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Hilo;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Hilo;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Hilo;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Hilo;
        connectMissingPoints(): boolean;
        connectMissingPoints(enabled?: boolean): anychart.core.cartesian.series.Hilo;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Hilo;
        getPixelPointWidth(): number;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Hilo;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Hilo;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Hilo;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Hilo;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Marker extends anychart.core.cartesian.series.Base {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Marker;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Marker;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Marker;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Marker;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Marker;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Marker;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Marker;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Marker;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Marker;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Marker;
        excludePoint(indexes: number | Array<number>): boolean;
        fill(): anychart.graphics.vector.Fill;
        fill(color: anychart.graphics.vector.Fill | Array<anychart.graphics.vector.GradientKey|string>): anychart.core.cartesian.series.Marker;
        fill(fillFunction?: (()=>anychart.graphics.vector.Fill)): anychart.core.cartesian.series.Marker;
        fill(color: string, opacity?: number): anychart.core.cartesian.series.Marker;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, angle?: number, mode?: boolean | anychart.graphics.vector.Rect | Object, opacity?: number): anychart.core.cartesian.series.Marker;
        fill(keys: Array<anychart.graphics.vector.GradientKey|string>, cx: number, cy: number, mode?: anychart.graphics.math.Rect, opacity?: number, fx?: number, fy?: number): anychart.core.cartesian.series.Marker;
        fill(imageSettings: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Marker;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Marker;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Marker;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Marker;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Marker;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Marker;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Marker;
        hover(): anychart.core.cartesian.series.Marker;
        hover(index?: number): anychart.core.cartesian.series.Marker;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Marker;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Marker;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Marker;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Marker;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Marker;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Marker;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Marker;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Marker;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Marker;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Marker;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Marker;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Marker;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Marker;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Marker;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Marker;
        name(): string;
        name(value?: string): anychart.core.cartesian.series.Marker;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Marker;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Marker;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Marker;
        select(index?: number): anychart.core.cartesian.series.Marker;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Marker;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Marker;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Marker;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Marker;
        size(): number;
        size(size?: number): anychart.core.cartesian.series.Marker;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Marker;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Marker;
        stroke(settings?: Object): anychart.core.cartesian.series.Marker;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Marker;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Marker;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        type(): string | (() => void);
        type(type?: string | ((path:anychart.graphics.vector.Path,x:number,y:number,size:number)=>anychart.graphics.vector.Path)): anychart.core.cartesian.series.Marker;
        unhover(): anychart.core.cartesian.series.Marker;
        unselect(): anychart.core.cartesian.series.Marker;
        unselect(index?: number): anychart.core.cartesian.series.Marker;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Marker;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Marker;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Marker;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Marker;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Marker;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Marker;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Marker;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Marker;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Marker;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Marker;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Marker;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
    interface Bar3d extends anychart.core.cartesian.series.WidthBased {
        a11y(): anychart.core.utils.SeriesA11y;
        a11y(value?: boolean | Object): anychart.core.cartesian.series.Bar3d;
        bottom(): number | string;
        bottom(bottom?: number | string): anychart.core.cartesian.series.Bar3d;
        bounds(): anychart.core.utils.Bounds;
        bounds(bounds?: anychart.utils.RectObj | anychart.math.Rect | anychart.core.utils.Bounds): anychart.core.cartesian.series.Bar3d;
        bounds(x?: number | string, y?: number | string, width?: number | string, height?: number | string): anychart.core.cartesian.series.Bar3d;
        clip(): boolean | anychart.math.Rect;
        clip(value?: boolean | anychart.math.Rect): anychart.core.cartesian.series.Bar3d;
        color(): string;
        color(value: anychart.graphics.vector.Fill): anychart.core.cartesian.series.Bar3d;
        colorScale(): anychart.scales.LinearColor | anychart.scales.OrdinalColor;
        colorScale(settings?: anychart.scales.LinearColor | anychart.scales.OrdinalColor | Object | string): anychart.core.cartesian.series.Bar3d;
        data(): anychart.data.View;
        data(value?: anychart.data.View | anychart.data.Set | Array<any> | string, csvSettings?: string | anychart.data.TextParsingSettings): anychart.core.cartesian.series.Bar3d;
        enabled(): boolean;
        enabled(enabled?: boolean): anychart.core.cartesian.series.Bar3d;
        error(): anychart.core.utils.Error;
        error(settings?: Object | boolean | string | number): anychart.core.cartesian.series.Bar3d;
        excludePoint(indexes: number | Array<number>): boolean;
        getExcludedPoints(): Array<anychart.core.Point>;
        getPixelBounds(): anychart.math.Rect;
        getPixelPointWidth(): number;
        getPoint(index: number): anychart.core.SeriesPoint;
        getStat(key: string): any;
        hatchFill(): anychart.graphics.vector.PatternFill | anychart.graphics.vector.HatchFill | (() => void);
        hatchFill(type?: anychart.graphics.vector.HatchFill.HatchFillType | string, color?: string, thickness?: number, size?: number): anychart.core.cartesian.series.Bar3d;
        hatchFill(hatchFillFunction?: (() => void)): anychart.core.cartesian.series.Bar3d;
        hatchFill(patternFill?: anychart.graphics.vector.PatternFill): anychart.core.cartesian.series.Bar3d;
        hatchFill(settings?: anychart.graphics.vector.HatchFill): anychart.core.cartesian.series.Bar3d;
        hatchFill(enabled?: boolean): anychart.core.cartesian.series.Bar3d;
        height(): number | string;
        height(height?: number | string): anychart.core.cartesian.series.Bar3d;
        hover(): anychart.core.cartesian.series.Bar3d;
        hover(index?: number): anychart.core.cartesian.series.Bar3d;
        hover(indexes?: Array<number>): anychart.core.cartesian.series.Bar3d;
        hovered(): anychart.core.StateSettings;
        hovered(settings?: Object): anychart.core.cartesian.series.Bar3d;
        id(): string | number;
        id(id?: string | number): anychart.core.cartesian.series.Bar3d;
        includeAllPoints(): boolean;
        includePoint(indexes: number | Array<number>): boolean;
        isVertical(): boolean;
        isVertical(enabled?: boolean): anychart.core.cartesian.series.Bar3d;
        keepOnlyPoints(indexes: number | Array<number>): void;
        labels(): anychart.core.ui.LabelsFactory;
        labels(settings?: Object | boolean): anychart.core.cartesian.series.Bar3d;
        left(): number | string;
        left(left?: number | string): anychart.core.cartesian.series.Bar3d;
        legendItem(): anychart.core.utils.LegendItemSettings;
        legendItem(value?: Object): anychart.core.cartesian.series.Bar3d;
        markers(): anychart.core.ui.MarkersFactory;
        markers(settings?: Object | boolean | string): anychart.core.cartesian.series.Bar3d;
        maxHeight(): number | string;
        maxHeight(height?: number | string): anychart.core.cartesian.series.Bar3d;
        maxLabels(): anychart.core.ui.LabelsFactory;
        maxLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bar3d;
        maxPointWidth(): string | number;
        maxPointWidth(width?: number | string): anychart.core.cartesian.series.Bar3d;
        maxWidth(): number | string;
        maxWidth(width?: number | string): anychart.core.cartesian.series.Bar3d;
        meta(key?: any): any;
        meta(object?: any): anychart.core.cartesian.series.Bar3d;
        meta(key?: string, value?: any): anychart.core.cartesian.series.Bar3d;
        minHeight(): number | string;
        minHeight(height?: number | string): anychart.core.cartesian.series.Bar3d;
        minLabels(): anychart.core.ui.LabelsFactory;
        minLabels(settings?: Object | boolean): anychart.core.cartesian.series.Bar3d;
        minPointLength(): string | number;
        minPointLength(length?: number | string): anychart.core.cartesian.series.Bar3d;
        minWidth(): number | string;
        minWidth(width?: number | string): anychart.core.cartesian.series.Bar3d;
        name(): string;
        name(name?: string): anychart.core.cartesian.series.Bar3d;
        normal(): anychart.core.StateSettings;
        normal(settings?: Object): anychart.core.cartesian.series.Bar3d;
        pointWidth(): string | number;
        pointWidth(width?: number | string): anychart.core.cartesian.series.Bar3d;
        rendering(): anychart.core.series.RenderingSettings;
        rendering(settings?: Object | (() => void)): anychart.core.cartesian.series.Bar3d;
        right(): number | string;
        right(right?: number | string): anychart.core.cartesian.series.Bar3d;
        select(index?: number): anychart.core.cartesian.series.Bar3d;
        select(indexes?: Array<number>): anychart.core.cartesian.series.Bar3d;
        selected(): anychart.core.StateSettings;
        selected(settings?: Object): anychart.core.cartesian.series.Bar3d;
        selectionMode(): string;
        selectionMode(value?: string): anychart.core.cartesian.series.Bar3d;
        seriesType(): string;
        seriesType(type?: string): anychart.core.cartesian.series.Bar3d;
        stroke(): anychart.graphics.vector.Stroke;
        stroke(strokeFunction?: (()=>anychart.graphics.vector.Stroke|anychart.graphics.vector.ColoredFill)): anychart.core.cartesian.series.Bar3d;
        stroke(color?: anychart.graphics.vector.Stroke | anychart.graphics.vector.ColoredFill | string, thickness?: number, dashpattern?: string, lineJoin?: string | anychart.graphics.vector.StrokeLineJoin, lineCap?: string | anychart.graphics.vector.StrokeLineCap): anychart.core.cartesian.series.Bar3d;
        stroke(settings?: Object): anychart.core.cartesian.series.Bar3d;
        tooltip(): anychart.core.ui.Tooltip;
        tooltip(value?: Object | boolean): anychart.core.cartesian.series.Bar3d;
        top(): number | string;
        top(top?: number | string): anychart.core.cartesian.series.Bar3d;
        transformX(value: any, subRangeRatio?: number): number;
        transformY(value: any, subRangeRatio?: number): number;
        unhover(indexOrIndexes?: number | Array<number>): anychart.core.cartesian.series.Bar3d;
        unselect(): anychart.core.cartesian.series.Bar3d;
        unselect(index?: number): anychart.core.cartesian.series.Bar3d;
        unselect(indexes?: Array<number>): anychart.core.cartesian.series.Bar3d;
        width(): number | string;
        width(width?: number | string): anychart.core.cartesian.series.Bar3d;
        xPointPosition(): number;
        xPointPosition(position?: number): anychart.core.cartesian.series.Bar3d;
        xScale(): anychart.scales.Ordinal;
        xScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bar3d;
        yScale(): anychart.scales.Base;
        yScale(settings?: anychart.scales.Base | Object | string): anychart.core.cartesian.series.Bar3d;
        zIndex(): number;
        zIndex(zIndex?: number): anychart.core.cartesian.series.Bar3d;
        xMode(): string;
        xMode(xMode?: string): anychart.core.cartesian.series.Bar3d;
        container(): anychart.graphics.vector.Layer | anychart.graphics.vector.Stage;
        container(element?: anychart.graphics.vector.Layer | anychart.graphics.vector.Stage | string | Element): anychart.core.cartesian.series.Bar3d;
        parentBounds(): anychart.math.Rect;
        parentBounds(bounds?: anychart.math.Rect | Object | number): anychart.core.cartesian.series.Bar3d;
        parentBounds(left?: number, top?: number, width?: number, height?: number): anychart.core.cartesian.series.Bar3d;
        print(paperSizeOrOptions?: anychart.graphics.vector.PaperSize | Object, landscape?: boolean): void;
        listen(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        listenOnce(type: string, listener: ((e:Object)=>void), useCapture?: boolean, listenerScope?: Object): Object;
        removeAllListeners(type?: string): number;
        unlisten(type: string, listener: ((e:Object)=>boolean), useCapture?: boolean, listenerScope?: Object): boolean;
        unlistenByKey(key: Object): boolean;
    }
}

declare