/**
 * AnyChart is lightweight robust charting library with great API and Docs, that works with your stack and has tons of chart types and features.
 *
 * Modules: theme-core, theme-annotations, theme-bullet, theme-cartesian, theme-cartesian-3d, theme-circular-gauge, theme-gantt, theme-heatmap, theme-linear-gauge, theme-map, theme-mekko, theme-pareto, theme-pert, theme-pie, theme-polar, theme-pyramid-funnel, theme-radar, theme-resource, theme-scatter, theme-sparkline, theme-stock, theme-surface, theme-tag-cloud, theme-timeline, theme-treemap, theme-venn, theme-waterfall
 * Version: 8.6.0.1927 (2019-05-15)
 * License: https://www.anychart.com/buy/
 * Contact: sales@anychart.com
 * Copyright: AnyChart.com 2019. All rights reserved.
 */
(function(global,factory){if(typeof module==='object'&&typeof module.exports==='object'){var wrapper=function(w){if(!w.document){throw Error('AnyChart requires a window with a document');}factory.call(w,w,w.document);try{w.acgraph.isNodeJS=Object.prototype.toString.call(global.process)=="[object process]";}catch(e){};return w.anychart;};module.exports=global.document?wrapper(global):wrapper;}else{factory.call(global,window,document)}})(typeof window!=='undefined'?window:this,function(window,document,opt_noGlobal){var $,_,$_=this.anychart;if($_&&(_=$_._)){$=$_.$}else{throw Error('anychart-base.min.js module should be included first. See modules explanation at https://docs.anychart.com/Quick_Start/Modules for details');$={};_={}}if(!_.theme_core){_.theme_core=1;(function($){var OJ,aK,bK,gK;$.LJ=function(a,b){var c=null===a||"boolean"==typeof a||""==a?window.NaN:+a;return(0,window.isNaN)(c)?a:$.pr(c,b,void 0,void 0,void 0,void 0,void 0,void 0)};$.MJ=function(){return $.LJ(this.value)};$.NJ=function(){return this.name||this.getData("id")};OJ=function(){return this.x};$.PJ=function(){return this.sourceColor};$.QJ=function(){return $.Ck(this.sourceColor,.7,!0)};$.RJ=function(){return $.Ck(this.sourceColor,.65,!0)};$.SJ=function(){return $.Ck(this.sourceColor,.5,!0)};
$.TJ=function(){return $.Ck(this.sourceColor,.85,!0)};$.UJ=function(){return $.yk(this.sourceColor)};$.VJ=function(){return $.xk(this.sourceColor)};$.WJ=function(){return $.Ck($.xk(this.sourceColor),.5,!0)};$.XJ=function(){return $.Lk(this.sourceColor,1.5)};$.YJ=function(){return $.Lk(this.sourceColor,1)};$.ZJ=function(){return $.Lk($.xk(this.sourceColor),1.5)};$.$J=function(){return"High: "+$.LJ(this.high)+"\nLow: "+$.LJ(this.low)};
aK=function(){return"Open: "+$.LJ(this.open)+"\nHigh: "+$.LJ(this.high)+"\nLow: "+$.LJ(this.low)+"\nClose: "+$.LJ(this.close)};bK=function(){return $.Lk(this.sourceColor,1.5)};$.cK=function(){var a=this.chart,b=$.hq(a,"title");b=b&&b.enabled()&&b.text()?b.text():"";return(a.Qa()||"Anychart ")+" chart "+(b?" entitled "+b:"")};$.dK=function(){var a=this.chart,b=$.cK.apply(this);b+=", with "+a.pg("count")+" points. ";return b+="Min value is "+a.pg("min")+", max value is "+a.pg("max")+"."};
$.eK=function(){for(var a=this.chart,b=$.cK.call(this),c=a.jk(),d={},e=0;e<c;e++){var f=a.Zh(e).Ui();d.hasOwnProperty(f)?d[f]+=1:d[f]=1}b+=", with ";for(var h in d)b+=d[h]+" "+h+" series, ";b+=". ";d=a.bb();a=a.Wa();c=a.Qa();e=d.Qa();if("ordinal"==e){d=d.values();b+="Y-scale with "+d.length+" categories: ";for(e=0;e<d.length;e++)b+=d[e]+", ";b+=". "}else f=d.kh(),d=d.Ih(),"date-time"==e&&(f=$.gr(f),d=$.gr(d)),b+="Y-scale minimum value is "+f+" , maximum value is "+d+". ";if("ordinal"==c){a=a.values();
b+="X-scale with "+a.length+" categories: ";for(c=0;c<a.length;c++)b+=a[c]+", ";b+=". "}else f=a.kh(),d=a.Ih(),"date-time"==c&&(f=$.gr(f),d=$.gr(d)),b+="X-scale minimum value is "+f+" , maximum value is "+d+". ";return b};
$.fK=function(){for(var a=this.chart,b=$.cK.call(this),c=a.jk(),d={},e=0;e<c;e++){var f=a.Zh(e).Qa();d.hasOwnProperty(f)?d[f]+=1:d[f]=1}b+=", with ";for(var h in d)b+=d[h]+" "+h+" series, ";b+=". ";d=a.bb();a=a.Wa();c=a.Qa();e=d.Qa();if("ordinal"==e){d=d.values();b+="Y-scale with "+d.length+" categories: ";for(e=0;e<d.length;e++)b+=d[e]+", ";b+=". "}else f=d.kh(),d=d.Ih(),"date-time"==e&&(f=$.gr(f),d=$.gr(d)),b+="Y-scale minimum value is "+f+", maximum value is "+d+". ";if("ordinal"==c){a=a.values();
b+="X-scale with "+a.length+" categories: ";for(c=0;c<a.length;c++)b+=a[c]+", ";b+=". "}else f=a.kh(),d=a.Ih(),"date-time"==c&&(f=$.gr(f),d=$.gr(d)),b+="X-scale minimum value is "+f+", maximum value is "+d+". ";return b};gK=function(a){switch(a.xScaleType){case "date-time":return $.hr(a.x);default:return $.LJ(a.x)}};
$.F("anychart.themes.defaultTheme",{palette:{type:"distinct",items:"#64b5f6 #1976d2 #ef6c00 #ffd54f #455a64 #96a6a6 #dd2c00 #00838f #00bfa5 #ffa000".split(" ")},hatchFillPalette:{items:"backward-diagonal forward-diagonal horizontal vertical dashed-backward-diagonal grid dashed-forward-diagonal dashed-horizontal dashed-vertical diagonal-cross diagonal-brick divot horizontal-brick vertical-brick checker-board confetti plaid solid-diamond zig-zag weave percent-05 percent-10 percent-20 percent-25 percent-30 percent-40 percent-50 percent-60 percent-70 percent-75 percent-80 percent-90".split(" ")},hatchFillPaletteFor3D:{items:"backward-diagonal forward-diagonal dashed-backward-diagonal grid dashed-forward-diagonal dashed-horizontal dashed-vertical diagonal-cross diagonal-brick divot horizontal-brick vertical-brick checker-board confetti plaid solid-diamond zig-zag weave percent-05 percent-10 percent-20 percent-25 percent-30 percent-40 percent-50 percent-60 percent-70 percent-75 percent-80 percent-90 horizontal vertical".split(" ")},
markerPalette:{items:"circle diamond square triangle-down triangle-up diagonal-cross pentagon cross v-line star5 star4 trapezium star7 star6 star10".split(" ")},defaultScaleSettings:{linear:{maxTicksCount:1E3,inverted:!1,maximum:null,minimum:null,minimumGap:.1,maximumGap:.1,softMinimum:null,softMaximum:null,alignMinimum:!0,alignMaximum:!0,ticks:{mode:"linear",base:0,explicit:null,minCount:4,maxCount:6,interval:window.NaN,allowFractional:!0},minorTicks:{mode:"linear",base:0,explicit:null,count:5,interval:window.NaN,
allowFractional:!0},stackMode:"none",stackDirection:"direct",stickToZero:!0},ordinal:{type:"ordinal",inverted:!1,mode:"discrete",names:[],ticks:{maxCount:100}},log:{type:"log",logBase:10,ticks:{mode:"log"},minorTicks:{mode:"log"}},dateTime:{type:"date-time",alignMinimum:!1,alignMaximum:!1,minimumGap:0,maximumGap:0,ticks:{count:4},minorTicks:{count:4}}},defaultFontSettings:{fontSize:13,fontFamily:"Verdana, Helvetica, Arial, sans-serif",fontColor:"#7c868e",textDirection:"ltr",fontOpacity:1,fontDecoration:"none",
fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",letterSpacing:"normal",lineHeight:"normal",textIndent:0,vAlign:"top",hAlign:"start",wordWrap:"normal",wordBreak:"normal",textOverflow:"",selectable:!1,disablePointerEvents:!1,useHtml:!1},defaultBackground:{enabled:!1,fill:"#ffffff",stroke:"none",cornerType:"round",corners:0},defaultSeparator:{enabled:!1,fill:"#CECECE 0.3",width:"100%",height:1,margin:{top:5,right:0,bottom:5,left:0},orientation:"top",stroke:"none",zIndex:1},defaultLabelFactory:{enabled:!1,
offsetX:0,offsetY:0,width:null,height:null,clip:null,fontSize:12,minFontSize:8,maxFontSize:72,adjustFontSize:{width:!1,height:!1},anchor:"center",padding:4,rotation:0,format:$.MJ,positionFormatter:$.MJ},defaultSimpleLabelsSettings:{fontSize:13,fontFamily:"Verdana, Helvetica, Arial, sans-serif",fontColor:"#7c868e",textDirection:"ltr",fontOpacity:1,fontDecoration:"none",fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",letterSpacing:"normal",lineHeight:"normal",textIndent:0,vAlign:"top",hAlign:"left",
wordWrap:null,wordBreak:null,textOverflow:!1,selectable:!1,useHtml:!1,allowMultiline:!1,padding:4,width:null,height:null,anchor:"left-top",position:"left-top",offsetX:0,offsetY:0,enabled:!0,disablePointerEvents:!0},defaultMarkerFactory:{anchor:"center",size:6,offsetX:0,offsetY:0,rotation:0,positionFormatter:$.MJ},defaultTitle:{enabled:!1,fontSize:16,text:"Title text",width:null,height:null,align:"center",hAlign:"center",padding:0,margin:0},defaultTooltip:{enabled:!0,title:{fontColor:"#ffffff",text:"",
fontSize:14,rotation:0,align:"left",hAlign:"left",orientation:"top",zIndex:1,background:{fill:"none",stroke:"none"}},contentInternal:{enabled:!0,fontSize:12,minFontSize:9,maxFontSize:13,fontColor:"#ffffff",hAlign:"left",text:"Tooltip Text",width:"100%",height:"100%",anchor:"left-top",offsetX:0,offsetY:0,position:"left-top",adjustFontSize:{width:!1,height:!1},padding:0,rotation:0,zIndex:1,background:{disablePointerEvents:!1,fill:"none",stroke:"none"}},fontSize:12,minFontSize:9,maxFontSize:13,fontColor:"#ffffff",
text:"Tooltip Text",width:null,height:null,adjustFontSize:{width:!1,height:!1},background:{enabled:!0,fill:"#212121 0.7",corners:3,zIndex:0,cornerType:"round"},offsetX:10,offsetY:10,padding:{top:5,right:10,bottom:5,left:10},valuePrefix:"",valuePostfix:"",position:"left-top",anchor:"left-top",hideDelay:0,titleFormat:$.MJ,format:function(){return this.valuePrefix+$.LJ(this.value)+this.valuePostfix},unionFormat:"{%joinedFormattedValues}",zIndex:0,allowLeaveChart:!0,allowLeaveScreen:!1,allowLeaveStage:!1},
defaultAxis:{enabled:!0,startAngle:0,drawLastLabel:!0,drawFirstLabel:!0,staggerMaxLines:2,staggerMode:!1,staggerLines:null,width:null,overlapMode:"no-overlap",stroke:"#CECECE",title:{padding:5,fontSize:13,text:"Axis title",fontColor:"#545f69",zIndex:35},labels:{enabled:!0,format:$.MJ,position:"outside",zIndex:35},minorLabels:{fontSize:9,format:$.MJ,position:"outside",zIndex:35},ticks:{enabled:!0,length:6,position:"outside",stroke:"#CECECE",zIndex:35},minorTicks:{enabled:!1,length:4,position:"outside",
stroke:"#EAEAEA",zIndex:35},zIndex:35},defaultGridSettings:{enabled:!0,isMinor:!1,drawFirstLine:!0,drawLastLine:!0,fill:function(){return this.palette.ic(this.index)},palette:{items:["none"]},stroke:"#CECECE",scale:1,zIndex:11},defaultMinorGridSettings:{isMinor:!0,stroke:"#EAEAEA",zIndex:10},defaultLineMarkerSettings:{enabled:!0,value:0,layout:null,stroke:{color:"#7c868e",thickness:2,opacity:1,dash:"",lineJoin:"miter",lineCap:"square"},zIndex:25.2,scale:1,scaleRangeMode:"none"},defaultTextMarkerSettings:{fontSize:12,
value:0,anchor:"auto",align:"center",layout:null,text:"Text marker",zIndex:25.3,scale:1,scaleRangeMode:"none",rotation:null},defaultRangeMarkerSettings:{enabled:!0,from:0,to:0,layout:null,fill:"#c1c1c1 0.4",zIndex:25.1,scale:1,scaleRangeMode:"none"},defaultLegend:{enabled:!1,vAlign:"bottom",fontSize:12,textOverflow:"...",itemsLayout:"horizontal",positionMode:"outside",itemsSpacing:15,items:null,itemsFormat:null,itemsSourceMode:"default",inverted:!1,hoverCursor:"pointer",iconTextSpacing:5,iconSize:15,
width:null,height:null,position:"top",align:"center",padding:{top:0,right:10,bottom:10,left:10},margin:0,title:{fontSize:15},paginator:{enabled:!0,fontSize:12,fontColor:"#545f69",orientation:"right",layout:"horizontal",padding:{top:0,right:0,bottom:0,left:5},margin:0,zIndex:30,buttonsSettings:{normal:{stroke:"#757575",fill:"#9e9e9e"},hover:{stroke:"#546e7a",fill:"#7c868e"},pushed:{stroke:"#7c868e",fill:"#9e9e9e"},disabled:{stroke:null,fill:"#e0e0e0"}}},titleFormat:null,tooltip:{enabled:!1,allowLeaveScreen:!0},
drag:!1,maxWidth:null,maxHeight:null,zIndex:200},defaultCrosshairLabel:{x:0,y:0,axisIndex:0,anchor:null,format:$.MJ,enabled:!0,fontSize:12,minFontSize:8,maxFontSize:16,fontColor:"#ffffff",fontWeight:400,disablePointerEvents:!0,text:"Label text",background:{enabled:!0,disablePointerEvents:!0,fill:"#212121 0.7",corners:3,zIndex:0},padding:{top:5,right:10,bottom:5,left:10},width:null,height:null,offsetX:0,offsetY:0,adjustFontSize:{width:!1,height:!1},rotation:0},defaultCallout:{enabled:!0,orientation:"left",
title:{enabled:!1},padding:0,margin:0,align:"center",labels:{enabled:!0,vAlign:"middle",hAlign:"center",positionFormatter:$.MJ,adjustFontSize:!1,connectorStroke:null}},defaultScroller:{enabled:!1,fill:"#f7f7f7",selectedFill:"#ddd",outlineStroke:"none",height:16,minHeight:null,maxHeight:null,autoHide:!1,orientation:"bottom",position:"after-axes",allowRangeChange:!0,thumbs:{enabled:!0,autoHide:!1,normal:{fill:"#E9E9E9",stroke:"#7c868e"},hovered:{fill:"#ffffff",stroke:"#757575"}},inverted:!1,zIndex:35},
defaultLabelSettings:{enabled:!0,text:"Chart label",width:null,height:null,anchor:"left-top",position:"left-top",offsetX:0,offsetY:0,minFontSize:8,maxFontSize:72,adjustFontSize:{width:!1,height:!1},rotation:0,zIndex:50},defaultButtonSettings:{padding:[3,5],normal:{hAlign:"center",vAlign:"middle",background:{enabled:!0,stroke:"#dedede",fill:"#e7e7e7",corners:[0]},content:"Button",disablePointerEvents:!0,selectable:!1,adjustFontSize:{width:!1,height:!1},minFontSize:8,maxFontSize:72},hovered:{},selected:{}},
defaultNoDataLabel:{padding:{},disablePointerEvents:!1,enabled:!1,background:{zIndex:0,enabled:!1,visible:!1,disablePointerEvents:!1},fontFamily:"Arial",fontColor:"black",fontWeight:"bold",fontSize:15,position:"center",anchor:"center",zIndex:999999,text:"No data."},stageCredits:{text:"AnyChart",url:"https://www.anychart.com/?utm_source=registered",alt:"AnyChart - JavaScript Charts designed to be embedded and integrated{{anychart-version}}",imgAlt:"AnyChart - JavaScript Charts",logoSrc:"https://static.anychart.com/logo.png"},
chart:{zIndex:0,enabled:!0,padding:{top:10,right:20,bottom:15,left:10},margin:{top:0,right:0,bottom:0,left:0},autoRedraw:!0,background:{enabled:!0,zIndex:.5},contextMenu:{fromTheme:!0,enabled:!0},title:{text:"Chart Title",padding:{top:0,right:0,bottom:10,left:0},zIndex:80,background:{zIndex:0}},animation:{enabled:!1,duration:1E3},interactivity:{hoverMode:"single",selectionMode:"multi-select",spotRadius:2,multiSelectOnClick:!1,unselectOnClickOutOfPoint:!0},tooltip:{displayMode:"single",positionMode:"float",
title:{enabled:!0},separator:{enabled:!0},titleFormat:function(){return gK(this.points[0])},format:function(){return this.formattedValues.join("\n")}},bounds:{top:null,right:null,bottom:null,left:null,width:null,height:null,minWidth:null,minHeight:null,maxWidth:null,maxHeight:null},credits:{},defaultSeriesSettings:{base:{enabled:!0,isVertical:null,background:{enabled:!0},tooltip:{titleFormat:function(){return gK(this)},format:function(){return this.seriesName+": "+this.valuePrefix+$.LJ(this.value)+
this.valuePostfix}},normal:{fill:$.RJ,stroke:$.XJ,lowStroke:$.XJ,highStroke:$.XJ,lowFill:$.PJ,highFill:$.PJ,negativeFill:$.PJ,negativeStroke:$.XJ,risingFill:$.PJ,risingStroke:$.XJ,fallingFill:$.PJ,fallingStroke:$.XJ,risingHatchFill:!1,fallingHatchFill:!1,hatchFill:!1,labels:{enabled:null,anchor:"auto",position:"value"},minLabels:{enabled:null},maxLabels:{enabled:null},outlierMarkers:{enabled:null},markers:{enabled:!1,disablePointerEvents:!1,position:"value",positionFormatter:$.MJ,size:4}},hovered:{fill:$.PJ,
stroke:$.ZJ,lowFill:$.PJ,highFill:$.PJ,lowStroke:$.ZJ,highStroke:$.ZJ,negativeFill:$.PJ,negativeStroke:$.ZJ,risingFill:$.PJ,fallingFill:$.PJ,risingStroke:$.ZJ,fallingStroke:$.ZJ,risingHatchFill:null,fallingHatchFill:null,hatchFill:null,labels:{enabled:null},minLabels:{enabled:null},maxLabels:{enabled:null},outlierMarkers:{enabled:null},markers:{enabled:null,size:6}},selected:{fill:"#333 0.85",stroke:"#333 0.85",lowStroke:"#333 0.85",highStroke:"#333 0.85",lowFill:"#333 0.85",highFill:"#333 0.85",
negativeFill:"#333 0.85",negativeStroke:"#333 0.85",risingFill:"#333 0.85",risingStroke:"#333 0.85",fallingFill:"#333 0.85",fallingStroke:"#333 0.85",risingHatchFill:null,fallingHatchFill:null,hatchFill:null,labels:{enabled:null},minLabels:{enabled:null},maxLabels:{enabled:null},outlierMarkers:{enabled:null},markers:{enabled:null,fill:"#333 0.85",stroke:"1.5 #212121",size:6}},legendItem:{enabled:!0,iconType:"square"},clip:!0,color:null,xScale:null,yScale:null,error:{mode:"both",xError:null,xUpperError:null,
xLowerError:null,valueError:null,valueUpperError:null,valueLowerError:null,xErrorWidth:10,valueErrorWidth:10,xErrorStroke:$.UJ,valueErrorStroke:$.UJ},pointWidth:null,connectMissingPoints:!1,a11y:{enabled:!1,titleFormat:"Series named {%SeriesName} with {%SeriesPointsCount} points. Min value is {%SeriesYMin}, max value is {%SeriesYMax}"}},marker:{normal:{fill:$.PJ,stroke:bK,size:4,labels:{offsetY:3}},hovered:{fill:$.VJ,stroke:bK,size:6},selected:{fill:"#333 0.85",stroke:"1.5 #212121",size:6},legendItem:{iconStroke:"none"}},
bubble:{normal:{fill:$.QJ,negativeFill:function(){return $.yk($.yk($.yk(this.sourceColor)))},negativeStroke:function(){return $.yk($.yk($.yk($.yk(this.sourceColor))))},negativeHatchFill:!1,labels:{anchor:"center"}},hovered:{fill:$.SJ,negativeFill:function(){return $.yk($.yk($.yk($.yk(this.sourceColor))))},negativeStroke:function(){return $.yk($.yk($.yk($.yk($.yk(this.sourceColor)))))},negativeHatchFill:null},selected:{negativeFill:function(){return $.yk($.yk($.yk(this.sourceColor)))},negativeStroke:function(){return $.yk($.yk($.yk($.yk(this.sourceColor))))},
negativeHatchFill:null},displayNegative:!1,legendItem:{iconStroke:"none"}},areaLike:{normal:{fill:$.RJ},hovered:{fill:$.RJ,markers:{enabled:!0}},selected:{markers:{enabled:!0}},legendItem:{iconStroke:"none"},stepDirection:"center"},barLike:{normal:{fill:$.TJ},hovered:{fill:$.RJ},legendItem:{iconStroke:"none"}},lineLike:{hovered:{markers:{enabled:!0}},selected:{markers:{enabled:!0}},stepDirection:"center"},rangeLike:{normal:{labels:{format:function(){return $.LJ(this.high)},position:"high"},markers:{position:"high"}},
tooltip:{format:$.$J}},candlestick:{normal:{risingFill:"#64b5f6",risingStroke:"#64b5f6",fallingFill:"#ef6c00",fallingStroke:"#ef6c00",risingHatchFill:!1,fallingHatchFill:!1,markers:{position:"high"},labels:{position:"high",format:OJ}},hovered:{risingFill:$.VJ,risingStroke:$.UJ,fallingFill:$.VJ,fallingStroke:$.UJ,risingHatchFill:null,fallingHatchFill:null},selected:{risingFill:"#333 0.85",risingStroke:"#333 0.85",fallingFill:"#333 0.85",fallingStroke:"#333 0.85",risingHatchFill:null,fallingHatchFill:null},
tooltip:{format:aK}},column:{isVertical:!1,normal:{labels:{offsetY:3}}},ohlc:{normal:{risingStroke:"#64b5f6",fallingStroke:"#ef6c00",markers:{position:"high"},labels:{position:"high",format:OJ}},hovered:{risingStroke:$.UJ,fallingStroke:$.UJ},selected:{risingStroke:"3 #333 0.85",fallingStroke:"3 #333 0.85"},tooltip:{format:aK}},stick:{normal:{stroke:$.YJ}},jumpLine:{pointWidth:"100%"},hilo:{pointWidth:1}},chartLabels:[],maxBubbleSize:"20%",minBubbleSize:"5%",a11y:{enabled:!0,titleFormat:$.cK,mode:"chart-elements"},
normal:{labels:{enabled:!1},minLabels:{enabled:null},maxLabels:{enabled:null}},hovered:{labels:{enabled:null},minLabels:{enabled:null},maxLabels:{enabled:null}},selected:{labels:{enabled:null},minLabels:{enabled:null},maxLabels:{enabled:null}},crossing:{stroke:"none"},baseline:0,defaultQuarterSettings:{enabled:!1,zIndex:1,fill:"none",stroke:"none",title:{padding:5},defaultLabelSettings:{text:"Quarter label",anchor:"center",position:"center"},margin:{},padding:{}},quarters:{rightTop:{fill:"#e3f2fd",
title:{orientation:"top"}},leftTop:{title:{orientation:"top"}},leftBottom:{fill:"#e3f2fd",title:{orientation:"bottom"}},rightBottom:{title:{orientation:"bottom"}}},selectMarqueeFill:"#d3d3d3 0.4",selectMarqueeStroke:"#d3d3d3",maxPointWidth:"100%",minPointLength:0,dataArea:{zIndex:10,background:{fill:"none"}}},cartesianBase:{defaultSeriesSettings:{base:{normal:{labels:{enabled:null,format:"{%Value}{decimalsCount:2}"}}},bar:{isVertical:!0,normal:{labels:{offsetY:3}},tooltip:{anchor:"left-top"}},column:{tooltip:{anchor:"left-top"}},
rangeColumn:{isVertical:!1,tooltip:{anchor:"left-top",offsetX:10}},rangeBar:{normal:{labels:{offsetY:3}},isVertical:!0},box:{normal:{medianStroke:$.UJ,stemStroke:$.UJ,whiskerStroke:$.UJ,whiskerWidth:0,outlierMarkers:{enabled:!0,disablePointerEvents:!1,position:"center",rotation:0,anchor:"center",offsetX:0,offsetY:0,type:"circle",size:3,positionFormatter:$.MJ},markers:{position:"median"},labels:{position:"highest",format:function(){return"Highest: "+$.LJ(this.highest)+"\nMedian: "+$.LJ(this.median)+
"\nLowest: "+$.LJ(this.lowest)}}},hovered:{medianStroke:$.PJ,stemStroke:$.PJ,whiskerStroke:$.UJ,whiskerWidth:null,outlierMarkers:{enabled:null,size:4}},selected:{medianStroke:"#333 0.85",stemStroke:"#333 0.85",whiskerStroke:"#333 0.85",whiskerWidth:null,outlierMarkers:{enabled:null,size:4,fill:"#333 0.85",stroke:"1.5 #212121"}},tooltip:{titleFormat:function(){return this.name||this.x},format:function(){return"Lowest: "+this.valuePrefix+$.LJ(this.lowest)+this.valuePostfix+"\nQ1: "+this.valuePrefix+
$.LJ(this.q1)+this.valuePostfix+"\nMedian: "+this.valuePrefix+$.LJ(this.median)+this.valuePostfix+"\nQ3: "+this.valuePrefix+$.LJ(this.q3)+this.valuePostfix+"\nHighest: "+this.valuePrefix+$.LJ(this.highest)+this.valuePostfix}}}},defaultXAxisSettings:{orientation:"bottom",title:{text:"X-Axis",padding:{top:5,right:0,bottom:0,left:0}},labels:{format:function(){var a=this.tickValue;switch(this.scale.Qa()){case "ordinal":return this.value;case "date-time":var b=this.intervalUnit;return $.gr(a,$.er($.dr(b,
b,"charts")));default:return $.pr(this.value)}}},minorLabels:{format:function(){var a=this.tickValue;switch(this.scale.Qa()){case "ordinal":return this.value;case "date-time":var b=this.minorIntervalUnit;return $.gr(a,$.er($.dr(b,$.oo(b),"charts")));default:return $.pr(this.value)}}},scale:0},defaultYAxisSettings:{orientation:"left",title:{text:"Y-Axis",padding:{top:0,right:0,bottom:5,left:0}},labels:{format:"{%Value}"},scale:1},defaultAnnotationSettings:{},annotations:{annotationsList:[],zIndex:2E3},
xAxes:[{}],yAxes:[{}],xGrids:[],yGrids:[],xMinorGrids:[],yMinorGrids:[],series:[],lineAxesMarkers:[],rangeAxesMarkers:[],textAxesMarkers:[],xScale:0,yScale:1,barsPadding:.4,barGroupsPadding:.8,maxBubbleSize:"20%",minBubbleSize:"5%",isVertical:!1,scales:[{type:"ordinal"},{type:"linear"}],yScroller:{orientation:"left",inverted:!1},crosshair:{enabled:!1,displayMode:"float",xStroke:"#969EA5",yStroke:"#969EA5",zIndex:41,xLabels:[{enabled:null}],yLabels:[{enabled:null}]},xZoom:{continuous:!0,startRatio:0,
endRatio:1},yZoom:{continuous:!0,startRatio:0,endRatio:1},a11y:{titleFormat:$.eK}},pieFunnelPyramidBase:{mode3d:!1,animation:{duration:500},normal:{fill:$.PJ,stroke:"none",hatchFill:null,labels:{enabled:!0,fontColor:null,position:"inside",disablePointerEvents:!1,autoRotate:!1,zIndex:34,format:function(){return this.name?this.name:this.x}},markers:{enabled:!1,position:"center",positionFormatter:$.MJ,zIndex:33}},hovered:{fill:$.VJ,stroke:$.PJ,labels:{enabled:null},markers:{enabled:null}},selected:{fill:"#333 0.85",
stroke:"1.5 #212121",labels:{enabled:null},markers:{enabled:null}},connectorStroke:"#CECECE",overlapMode:"no-overlap",connectorLength:20,baseWidth:"70%",neckWidth:null,neckHeight:null,pointsPadding:0,forceHoverLabels:!0,outsideLabels:{disablePointerEvents:!1,autoColor:"#545f69"},insideLabels:{disablePointerEvents:!0,autoColor:"#ffffff"},legend:{enabled:!0,padding:{top:10,right:10,bottom:0,left:10},position:"bottom"},tooltip:{title:{enabled:!0},separator:{enabled:!0},titleFormat:function(){return this.name||
this.x},format:function(){return"Value: "+$.LJ(this.value)+"\nPercent Value: "+(100*this.value/this.getStat("sum")).toFixed(1)+"%"}},interactivity:{hoverMode:"single"}},defaultScrollBar:{barSize:10,backgroundFill:"#e0e0e0",backgroundStroke:"#d5d5d5",sliderFill:"#d5d5d5",sliderStroke:"#656565",mouseOverOpacity:.45,mouseOutOpacity:.25,handlePositionChange:!0,startRatio:"0",endRatio:"1",buttonsVisible:!1,cornersRadius:5},standalones:{background:{enabled:!0,zIndex:0},label:{enabled:!0,text:"Label text",
padding:0,width:null,height:null,anchor:"left-top",position:"left-top",offsetX:0,offsetY:0,minFontSize:8,maxFontSize:72,adjustFontSize:{width:!1,height:!1},rotation:0,zIndex:0},labelsFactory:{enabled:!0,zIndex:0},legend:{enabled:!0,zIndex:0},markersFactory:{enabled:!0,zIndex:0},title:{enabled:!0,zIndex:0},linearAxis:{enabled:!0,zIndex:0,ticks:{enabled:!0},minorTicks:{enabled:!0}},polarAxis:{enabled:!0,startAngle:0,zIndex:0,ticks:{enabled:!0},minorTicks:{enabled:!0}},radarAxis:{enabled:!0,startAngle:0,
zIndex:0,ticks:{enabled:!0},minorTicks:{enabled:!0}},radialAxis:{enabled:!0,startAngle:0,innerRadius:0,zIndex:0,ticks:{enabled:!0},minorTicks:{enabled:!0},minorLabels:{padding:{top:1,right:1,bottom:0,left:1}}},linearGrid:{enabled:!0,scale:null,zIndex:0},polarGrid:{enabled:!0,layout:"circuit",zIndex:0},radarGrid:{enabled:!0,layout:"circuit",zIndex:0},lineAxisMarker:{enabled:!0,zIndex:0},textAxisMarker:{enabled:!0,zIndex:0},rangeAxisMarker:{enabled:!0,zIndex:0},scroller:{enabled:!0}}});}).call(this,$)}
if(!_.theme_annotations){_.theme_annotations=1;(function($){$.ra($.fa.anychart.themes.defaultTheme.chart,{defaultAnnotationSettings:{base:{enabled:!0,normal:{fill:$.SJ,stroke:$.PJ,hatchFill:null,markers:{enabled:!1,size:5,type:"square",fill:"#ffff66",stroke:"#333333"},labels:{enabled:!0,position:"center-top",anchor:"center-top",format:function(){return this.level}}},hovered:{fill:$.QJ,stroke:$.UJ,markers:{enabled:null},labels:{enabled:null}},selected:{fill:$.QJ,stroke:$.UJ,markers:{enabled:!0},labels:{enabled:null}},color:"#e06666",allowEdit:!0,hoverGap:5},
ray:{},line:{},infiniteLine:{},verticalLine:{},horizontalLine:{},rectangle:{},ellipse:{},triangle:{},trendChannel:{},andrewsPitchfork:{},fibonacciFan:{levels:[0,.382,.5,.618,1],timeLevels:[0,.382,.5,.618,1],labels:{anchor:null}},fibonacciArc:{levels:[.236,.382,.5,.618,.764,1],labels:{anchor:null}},fibonacciRetracement:{levels:[0,.236,.382,.5,.618,.764,1,1.236,1.382,1.5,1.618,1.764,2.618,4.236],normal:{labels:{position:"left-center",anchor:"right-center"}}},fibonacciTimezones:{levels:[0,1,2,3,5,8,
13,21,34,55,89,144,233,377,610,987,1597,2584,4181,6765,10946,17711,28657,46368,75025,121393,196418,317811,514229,832040,1346269,2178309,3524578,5702887,9227465,14930352,24157817,39088169],labels:{anchor:"left-bottom"}},marker:{markerType:"arrow-up",normal:{size:20},anchor:"center-top",offsetX:0,offsetY:0},label:{text:"Label",offsetX:0,offsetY:0,anchor:"left-top",hAlign:"start",vAlign:"top",width:null,height:null,background:{enabled:!0,fill:"#eee 0.4",stroke:$.yk("#eee")},padding:5,normal:{markers:{size:3}}}}});}).call(this,$)}
if(!_.theme_bullet){_.theme_bullet=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{bullet:{background:{enabled:!0},layout:"horizontal",defaultRangeMarkerSettings:{enabled:!0,from:0,to:0,zIndex:2,fill:null},padding:{top:5,right:10,bottom:5,left:10},margin:0,defaultMarkerSettings:{fill:"#64b5f6",stroke:"2 #64b5f6",zIndex:2},rangePalette:{type:"distinct",items:["#828282","#a8a8a8","#c2c2c2","#d4d4d4","#e1e1e1"]},markerPalette:{items:["bar","line","x","ellipse"]},axis:{enabled:!1,title:{padding:0,margin:{top:0,right:0,bottom:10,left:0}},labels:{fontSize:9,
padding:0},minorLabels:{padding:0},ticks:{enabled:!1},orientation:null,zIndex:3},title:{rotation:0},scale:{type:"linear",minimumGap:0,maximumGap:0,ticks:{minCount:2,maxCount:5,interval:window.NaN}},ranges:[],a11y:{titleFormat:function(){return $.cK.apply(this)+". "}}}});}).call(this,$)}
if(!_.theme_cartesian){_.theme_cartesian=1;(function($){var m5=function(){return $.hr(this.x)},mia=function(){return $.hr(this.tickValue)};
$.ra($.fa.anychart.themes.defaultTheme,{cartesian:{defaultSeriesType:"line",defaultSeriesSettings:{base:{xMode:"ordinal"}}},area:{defaultSeriesType:"area",tooltip:{displayMode:"union"},interactivity:{hoverMode:"by-x"}},bar:{isVertical:!0,defaultSeriesType:"bar",defaultXAxisSettings:{orientation:"left"},defaultYAxisSettings:{orientation:"bottom"},scales:[{type:"ordinal",inverted:!0},{type:"linear",stackDirection:"reverse"}],tooltip:{displayMode:"single",position:"right-center",anchor:"left-center"},
xScroller:{orientation:"left",inverted:!0},yScroller:{orientation:"bottom",inverted:!1}},column:{defaultSeriesType:"column",tooltip:{displayMode:"single",position:"center-top",anchor:"center-bottom",offsetX:0,offsetY:10},scales:[{type:"ordinal"},{type:"linear",softMinimum:0}]},line:{defaultSeriesType:"line",tooltip:{displayMode:"union"},interactivity:{hoverMode:"by-x"}},box:{defaultSeriesType:"box"},financial:{defaultSeriesType:"candlestick",defaultSeriesSettings:{candlestick:{tooltip:{titleFormat:m5},
normal:{labels:{format:m5}}},ohlc:{tooltip:{titleFormat:m5},normal:{labels:{format:m5}}}},xAxes:[{labels:{format:mia},minorLabels:{format:mia}}],scales:[{type:"date-time"},{type:"linear"}]},candlestick:{defaultSeriesType:"candlestick"},ohlc:{defaultSeriesType:"ohlc"},verticalLine:{isVertical:!0,defaultSeriesType:"line",defaultXAxisSettings:{orientation:"left"},defaultYAxisSettings:{orientation:"bottom"},scales:[{type:"ordinal",inverted:!0},{type:"linear"}],tooltip:{displayMode:"union"},interactivity:{hoverMode:"by-x"},
xScroller:{orientation:"left",inverted:!0},yScroller:{orientation:"bottom",inverted:!1}},verticalArea:{isVertical:!0,defaultSeriesType:"area",defaultXAxisSettings:{orientation:"left"},defaultYAxisSettings:{orientation:"bottom"},scales:[{type:"ordinal",inverted:!0},{type:"linear"}],tooltip:{displayMode:"union"},interactivity:{hoverMode:"by-x"},xScroller:{orientation:"left",inverted:!0},yScroller:{orientation:"bottom",inverted:!1}}});}).call(this,$)}
if(!_.theme_cartesian_3d){_.theme_cartesian_3d=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{cartesian3dBase:{zAngle:45,zAspect:"50%",zDistribution:!1,zPadding:10,defaultSeriesSettings:{base:{normal:{stroke:"none",fill:$.PJ},hovered:{stroke:"none",fill:$.VJ},selected:{stroke:"none",fill:"#333"},tooltip:{anchor:"left-top",position:"left-top"}},area:{hovered:{markers:{enabled:!0}},selected:{markers:{enabled:!0}}},bar:{isVertical:!0},line:{hovered:{markers:{enabled:!0}},selected:{markers:{enabled:!0}}},line2d:{normal:{stroke:$.PJ},hovered:{stroke:$.VJ,
markers:{enabled:!0}},selected:{stroke:"#333",markers:{enabled:!0}}}}},bar3d:{xGrids:[{}],yGrids:[{enabled:!0,scale:0}],yScale:{stackDirection:"reverse"}},column3d:{defaultSeriesType:"column"},area3d:{defaultSeriesType:"area",zDistribution:!0,zPadding:5},line3d:{defaultSeriesType:"line",zDistribution:!0,zPadding:5},cartesian3d:{defaultSeriesType:"column",xGrids:[{enabled:!0,scale:0}],yGrids:[{}]}});}).call(this,$)}
if(!_.theme_circular_gauge){_.theme_circular_gauge=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{circularGauge:{defaultPointerType:"needle",title:{enabled:!1},defaultAxisSettings:{startAngle:null,labels:{position:"inside",adjustFontSize:!0,offsetY:0},minorLabels:{position:"inside",adjustFontSize:!0,offsetY:0},fill:"#CECECE",ticks:{hatchFill:!1,type:"line",position:"center",length:null,fill:"#545f69",stroke:"none"},minorTicks:{hatchFill:!1,type:"line",position:"center",length:null,fill:"#545f69",stroke:"none"},zIndex:10,cornersRounding:"0%"},defaultPointerSettings:{base:{enabled:!0,
fill:"#545f69",stroke:"#545f69",hatchFill:!1,axisIndex:0},bar:{position:"center",barDrawer:function(){this.path.clear();this.path.circularArc(this.centerX,this.centerY,this.radius-this.width/2,this.radius-this.width/2,this.startAngle,this.sweepAngle);this.path.circularArc(this.centerX,this.centerY,this.radius+this.width/2,this.radius+this.width/2,this.startAngle+this.sweepAngle,-this.sweepAngle,!0);this.path.close()}},marker:{size:"4%",hoverSize:6,selectSize:6,position:"inside",type:"triangle-up"},
knob:{fill:"#CECECE",stroke:"#c1c1c1",verticesCount:6,verticesCurvature:.5,topRatio:.5,bottomRatio:.5},needle:{startRadius:"-20%",startWidth:"3%",middleWidth:"1%"}},defaultRangeSettings:{enabled:!0,axisIndex:0,fill:"#7c868e 0.7",position:"center",startSize:0,endSize:"10%",cornersRounding:"0%"},fill:"#f5f5f5",stroke:"#EAEAEA",startAngle:0,sweepAngle:360,cap:{enabled:!1,fill:"#EAEAEA",stroke:"#CECECE",hatchFill:!1,radius:"15%",zIndex:50},circularPadding:"10%",encloseWithStraightLine:!1,axes:[{}],bars:[],
markers:[],needles:[],knobs:[],ranges:[],tooltip:{title:{enabled:!1},separator:{enabled:!1},titleFormat:function(){return this.index},format:function(){return"Value: "+$.LJ(this.value)}}}});}).call(this,$)}
if(!_.theme_gantt){_.theme_gantt=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{ganttDefaultSimpleLabelsSettings:{fontSize:11,vAlign:"middle",height:"100%",padding:{left:4,top:0,right:4,bottom:0}},defaultLevelsLabelsSettings:{fontSize:10,format:function(){return this.value},textOverflow:!0},defaultGanttHeader:{stroke:"#cecece",background:{fill:"#f7f7f7",enabled:!0}},defaultLevelSettings:{height:null},defaultDataGrid:{isStandalone:!0,headerHeight:25,backgroundFill:"none",columnStroke:"#cecece",rowHoverFill:$.PJ,rowSelectedFill:$.PJ,rowStroke:"#cecece",
rowOddFill:"none",rowEvenFill:"none",rowFill:"none",onEditStart:function(){return 1>this.columnIndex?{cancelEdit:!0}:{value:this.value}},onEditEnd:function(){return 1==this.columnIndex?{itemMap:{name:this.value}}:{cancelEdit:!0}},buttons:{padding:[0,0,0,0],width:15,height:15,cursor:"pointer",normal:{hAlign:"center",vAlign:"middle",fontColor:"#7c868e",fontSize:12,content:"+"},hovered:{},selected:{content:"-"}},zIndex:5,headerFill:"#f7f7f7",tooltip:{padding:5,title:{enabled:!0,fontSize:"14px",fontWeight:"normal",
fontColor:"#e5e5e5"},separator:{enabled:!0},format:"{%name}"},defaultColumnSettings:{width:90,buttonCursor:"pointer",depthPaddingMultiplier:0,collapseExpandButtons:!1,title:{enabled:!0,margin:0,vAlign:"middle",hAlign:"center",background:{enabled:!1},wordWrap:"normal",wordBreak:"normal"}},columns:[{width:50,title:{text:"#"}},{width:170,collapseExpandButtons:!0,depthPaddingMultiplier:15,title:{text:"Name"}}]},defaultTimeline:{isStandalone:!0,columnStroke:"#cecece",backgroundFill:"none",rowHoverFill:$.PJ,
rowSelectedFill:$.PJ,rowStroke:"#cecece",rowOddFill:"none",rowEvenFill:"none",rowFill:"none",zIndex:5,headerHeight:70,elements:{anchor:"auto",position:"left-center",offset:0,height:"70%",normal:{fill:$.PJ,stroke:$.PJ},selected:{fill:$.PJ,stroke:$.PJ},labels:{enabled:null},rendering:{drawer:function(){$.zC.vector.primitives.roundedRect(this.shapes.path,this.predictedBounds,0)},shapes:[{name:"path",shapeType:"path",zIndex:10,disablePointerEvents:!1}]},edit:{thumbs:{fill:"#eaeaea",stroke:"#545f69",size:3,
enabled:!0},connectorThumbs:{fill:"#eaeaea",stroke:"#545f69",size:10,type:"circle",verticalOffset:0,horizontalOffset:0,enabled:!0},fill:{color:"#fff",opacity:1E-5},stroke:{color:"#aaa",dash:"3 3"},enabled:null}},tasks:{progress:{height:"100%",anchor:"left-center",rendering:{shapes:[{name:"path",shapeType:"path",zIndex:11,disablePointerEvents:!0}]},edit:{fill:"#eaeaea",stroke:"#545f69",enabled:null}}},groupingTasks:{rendering:{drawer:function(){var a=this.predictedBounds,b=a.left+a.width,c=a.top+a.height,
d=a.top+1.4*a.height;this.shapes.path.moveTo(a.left,a.top).lineTo(b,a.top).lineTo(b,d).lineTo(b-1,d).lineTo(b-1,c).lineTo(a.left+1,c).lineTo(a.left+1,d).lineTo(a.left,d).close()}}},milestones:{rendering:{drawer:function(){var a=this.predictedBounds,b=a.width/2;$.zC.vector.primitives.diamond(this.shapes.path,a.left+b,a.top+b,b)}}},baselines:{above:!1},connectors:{previewStroke:{color:"#545f69",dash:"3 3"},normal:{fill:$.PJ,stroke:$.PJ},selected:{fill:$.PJ,stroke:$.PJ}},tooltip:{padding:5,title:{enabled:!0,
fontSize:"14px",fontWeight:"normal",fontColor:"#e5e5e5"},separator:{enabled:!0},zIndex:100},labels:{enabled:!0,anchor:"left-center",position:"right-center",padding:{top:3,right:5,bottom:3,left:5},vAlign:"middle",background:null,fontSize:11,zIndex:40,disablePointerEvents:!0},markers:{anchor:"center-top",zIndex:50,type:"star5",fill:"#ff0",stroke:"2 red"},defaultLineMarkerSettings:{layout:"vertical",zIndex:1.5},defaultRangeMarkerSettings:{layout:"vertical",zIndex:1},defaultTextMarkerSettings:{layout:"vertical",
zIndex:2}},ganttBase:{defaultRowHoverFill:"#f8fafb",defaultRowSelectedFill:"#ebf1f4",splitterPosition:"30%",headerHeight:70,rowStroke:"#cecece",rowHoverFill:$.PJ,rowSelectedFill:$.PJ,edit:{fill:{color:"#4285F4",opacity:.2},stroke:{color:"#4285F4",thickness:2},placementStroke:{color:"#4285F4",dash:"4 4"},enabled:!1},title:{enabled:!1},legend:{enabled:!1},background:{fill:"#fff"},margin:0,padding:0,dataGrid:{isStandalone:!1,backgroundFill:"none",tooltip:{zIndex:100}},timeline:{isStandalone:!1,labels:{padding:[0,
4,0,4]}}},ganttResource:{dataGrid:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%start}\nEnd Date: {%end}"}},timeline:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%start}\nEnd Date: {%end}"},labels:{format:"Progress Label",position:"center",anchor:"center",enabled:!1}}},ganttProject:{dataGrid:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%actualStart}\nEnd Date: {%actualEnd}\nComplete: {%progress}"}},timeline:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%actualStart}\nEnd Date: {%actualEnd}\nComplete: {%progress}"},
elements:{labels:{format:"{%Progress}",position:"right-center",anchor:"left-center",enabled:null}},tasks:{progress:{labels:{format:"{%Progress}",enabled:!1}}},groupingTasks:{progress:{labels:{format:"{%Progress}",enabled:!1}}},baselines:{labels:{position:"right-center",anchor:"left-center",format:"Baseline Label",enabled:!1}},milestones:{labels:{format:"{%Name}",anchor:"left-center",position:"right-center",enabled:null}}}}});
$.ra($.fa.anychart.themes.defaultTheme.standalones,{projectTimeline:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%actualStart}\nEnd Date: {%actualEnd}\nComplete: {%progress}"}},resourceTimeline:{tooltip:{titleFormat:"{%Name}",format:"Start Date: {%start}\nEnd Date: {%end}"}},dataGrid:{enabled:!0,zIndex:0}});}).call(this,$)}
if(!_.theme_heatmap){_.theme_heatmap=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{heatMap:{annotations:{annotationsList:[],zIndex:2E3},isVertical:!1,scales:[{type:"ordinal"},{type:"ordinal",inverted:!0},{type:"ordinal-color"}],xScale:0,yScale:1,colorScale:2,background:{enabled:!0},xAxes:[{orientation:"top"}],yAxes:[{}],xGrids:[],yGrids:[],tooltip:{enabled:!0,title:{enabled:!0,fontSize:13,fontWeight:"normal"},contentInternal:{fontSize:11},separator:{enabled:!0},titleFormat:function(){return this.name||this.x},format:function(){if(void 0!==
this.heat){var a="Value: "+this.valuePrefix+this.heat+this.valuePostfix;(0,window.isNaN)(+this.heat)||(a+="\nPercent Value: "+(100*this.heat/this.getStat("sum")).toFixed(1)+"%");return a}return"x: "+this.x+"\ny: "+this.y}},legendItem:{iconStroke:null},legend:{itemsSourceMode:"categories"},defaultXAxisSettings:{enabled:!0,orientation:"bottom",ticks:{enabled:!1},title:{text:"X-Axis",padding:5},scale:0},defaultYAxisSettings:{enabled:!0,orientation:"left",ticks:{enabled:!1},title:{text:"Y-Axis",padding:5},
scale:1},defaultSeriesSettings:{heatMap:{normal:{fill:function(){if(this.colorScale){var a=this.iterator.get("heat");a=this.colorScale.valueToColor(a)}else a=$.Ck(this.sourceColor,.85,!0);return a},stroke:"1 #ffffff",labels:{disablePointerEvents:!0,enabled:!0,fontSize:11,anchor:"center",adjustFontSize:{width:!0,height:!0},minFontSize:7,maxFontSize:13,hAlign:"center",vAlign:"middle",fontWeight:"normal",fontColor:"#212121",selectable:!1,background:{enabled:!1},padding:{top:2,right:4,bottom:2,left:4},
position:"center",format:function(){return $.LJ(this.heat)}},markers:{enabled:!1,disablePointerEvents:!1,position:"center",rotation:0,anchor:"center",offsetX:0,offsetY:0,size:4,positionFormatter:$.MJ,fill:"#dd2c00",type:"circle",stroke:"none"},hatchFill:!1},hovered:{fill:"#757575",stroke:"2 #ffffff",labels:{fontColor:"#f5f5f5",enabled:null},markers:{enabled:null,size:6},hatchFill:null},selected:{fill:"#333 0.85",stroke:"2 #ffffff",labels:{fontColor:"#fff",enabled:null},markers:{enabled:null,size:6,
fill:"#333 0.85",stroke:"1.5 #212121"},hatchFill:null},tooltip:{enabled:!0,title:{enabled:!0,fontSize:13,fontWeight:"normal"},contentInternal:{fontSize:11},separator:{enabled:!0},titleFormat:function(){return this.name||this.x},format:function(){if(void 0!==this.heat){var a="Value: "+this.valuePrefix+this.heat+this.valuePostfix;(0,window.isNaN)(+this.heat)||(a+="\nPercent Value: "+(100*this.heat/this.getStat("sum")).toFixed(1)+"%");return a}return"x: "+this.x+"\ny: "+this.y}}}},labelsDisplayMode:"drop",
clip:!0,xZoom:{continuous:!0,startRatio:0,endRatio:1},yZoom:{continuous:!0,startRatio:0,endRatio:1},yScroller:{orientation:"right",inverted:!0},a11y:{titleFormat:$.cK}}});}).call(this,$)}
if(!_.theme_linear_gauge){_.theme_linear_gauge=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{linearGauge:{padding:10,markerPalette:{items:"circle diamond square triangle-down triangle-up triangle-left triangle-right diagonal-cross pentagon cross v-line star5 star4 trapezium star7 star6 star10".split(" ")},globalOffset:"0%",layout:"vertical",tooltip:{titleFormat:function(){return this.name},format:function(){return this.high?$.$J.call(this):"Value: "+$.LJ(this.value)}},scales:[{type:"linear"}],defaultAxisSettings:{enabled:!0,width:"10%",offset:"0%"},
defaultScaleBarSettings:{enabled:!0,width:"10%",offset:"0%",from:"min",to:"max",colorScale:{type:"ordinal-color",inverted:!1,ticks:{maxCount:100}},points:[{height:0,left:0,right:0},{height:1,left:0,right:0}]},defaultPointerSettings:{base:{enabled:!0,selectionMode:"single",width:"10%",offset:"0%",legendItem:{enabled:!0},normal:{stroke:$.XJ,fill:$.PJ,hatchFill:null,labels:{zIndex:0,position:"center-top"}},hovered:{stroke:$.ZJ,fill:$.VJ,labels:{enabled:null}},selected:{stroke:$.UJ,fill:$.UJ,labels:{enabled:null}}},
bar:{},rangeBar:{normal:{labels:{format:function(){return $.LJ(this.high)}}}},marker:{width:"3%"},tank:{normal:{emptyFill:"#fff 0.3",emptyHatchFill:null},hovered:{emptyFill:$.PJ},selected:{emptyFill:$.PJ}},thermometer:{normal:{fill:function(){var a=this.sourceColor,b=$.yk(a);return{angle:this.isVertical?0:90,keys:[{color:b},{color:a},{color:b}]}}},width:"3%",bulbRadius:"120%",bulbPadding:"3%"},led:{dimmer:function(a){return $.yk(a)},gap:"1%",size:"2%",count:null,colorScale:{type:"ordinal-color",inverted:!1,
ticks:{maxCount:100}}}}},thermometer:{},tank:{},led:{}});}).call(this,$)}
if(!_.theme_map){_.theme_map=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{map:{defaultCalloutSettings:{},defaultSeriesSettings:{base:{normal:{fill:function(){return this.scaledColor||this.sourceColor},stroke:$.UJ,hatchFill:!1,labels:{anchor:"center-bottom",enabled:null,adjustFontSize:{width:!0,height:!0},format:function(){return this.getData("name")?this.getData("name"):this.name?this.name:this.getData("id")?this.getData("id"):"lat: "+this.lat+"\nlong: "+this["long"]}},markers:{enabled:!1,disablePointerEvents:!1}},hovered:{fill:"#757575",
stroke:{thickness:.5,color:"#545f69"},labels:{enabled:null},markers:{enabled:null}},selected:{fill:"#333 0.85",stroke:{thickness:.5,color:"#545f69"},labels:{enabled:null},markers:{enabled:null}},color:null,tooltip:{titleFormat:function(){return this.name||this.getData("name")||"Tooltip title"},format:function(){return"Id: "+this.id+"\nValue: "+this.valuePrefix+$.LJ(this.value)+this.valuePostfix}},xScale:null,yScale:null,a11y:{titleFormat:"Series named {%SeriesName}"},clip:!1},choropleth:{normal:{labels:{fontColor:"#212121",
anchor:"center"},markers:{anchor:null}},colorScale:{}},connector:{startSize:0,endSize:0,curvature:.3,normal:{stroke:function(){return{thickness:2,color:this.sourceColor,lineJoin:"round"}},markers:{position:"middle",enabled:!0,size:15,stroke:"1.5 #f7f7f7",rotation:null,anchor:null,type:"arrowhead"},labels:{enabled:!1,position:"middle",anchor:null,format:function(){return"from: "+this.startPoint.lat+","+this.startPoint["long"]+"\nto: "+this.endPoint.lat+","+this.endPoint["long"]}}},hovered:{stroke:$.VJ,
markers:{stroke:"1.5 #f7f7f7",size:15}},selected:{stroke:"2 #333 0.85",markers:{fill:"#333 0.85",stroke:"1.5 #f7f7f7",size:15}},tooltip:{title:{enabled:!1},separator:{enabled:!1},format:function(){return"from: "+this.startPoint.lat+", "+this.startPoint["long"]+"\nto: "+this.endPoint.lat+", "+this.endPoint["long"]}}},bubble:{normal:{stroke:function(){return{thickness:2,color:$.yk(this.sourceColor)}},labels:{anchor:"center"}},hovered:{fill:"#757575"},selected:{fill:"#333 0.85"},tooltip:{format:function(){var a=
this.id?"Id: "+this.id:"lat: "+this.lat+"\nlong: "+this["long"];this.size&&(a+="\nValue: "+this.valuePrefix+$.LJ(this.size)+this.valuePostfix);return a}}},marker:{normal:{labels:{enabled:!0}},hovered:{labels:{fontWeight:"bold"}},selected:{labels:{fontWeight:"bold"}},tooltip:{format:function(){var a=this.id?"Id: "+this.id:"lat: "+this.lat+"\nlong: "+this["long"];this.value&&(a+="\nValue: "+this.valuePrefix+$.LJ(this.value)+this.valuePostfix);return a}}}},colorRange:{zIndex:50},geoScale:{maxTicksCount:1E3,
precision:2},callouts:[],axesSettings:{enabled:!1,title:{padding:5,fontSize:13,text:"Axis title",fontColor:"#545f69",zIndex:10},labels:{enabled:!0,padding:2,rotation:null,fontSize:10,anchor:"auto",position:"outside",zIndex:5},minorLabels:{enabled:null,padding:2,rotation:null,fontSize:9,anchor:null,position:"outside",zIndex:4},overlapMode:"no-overlap",ticks:{enabled:!0,length:5,position:"outside",stroke:"#CECECE",zIndex:3},minorTicks:{enabled:!1,length:2,position:"outside",stroke:"#CECECE",zIndex:2},
drawFirstLabel:!0,drawLastLabel:!0,stroke:"#CECECE"},gridsSettings:{enabled:!1,minorStroke:"none",zIndex:5},crosshair:{enabled:!1,xStroke:"#969EA5",yStroke:"#969EA5",zIndex:110,xLabels:[{enabled:null,axisIndex:2}],yLabels:[{enabled:null,axisIndex:3}]},unboundRegions:{enabled:!0,fill:"#F7F7F7",stroke:"#e0e0e0"},maxBubbleSize:"10%",minBubbleSize:"1%",geoIdField:"id",interactivity:{copyFormat:function(a){a=a.seriesStatus;for(var b="",c=0,d=a.length;c<d;c++){var e=a[c];if(e.points.length){b+="Series "+
e.series.getIndex()+":\n";for(var f=0,h=e.points.length;f<h;f++){var k=e.points[f];b+="id: "+k.id+" index: "+k.index;f!=h-1&&(b+="\n")}c!=d-1&&(b+="\n")}}return b||"no selected points"},drag:!0,zoomOnMouseWheel:!1,keyboardZoomAndMove:!0,zoomOnDoubleClick:!1},minZoomLevel:1,maxZoomLevel:10,overlapMode:"no-overlap",crsAnimation:{enabled:!0,duration:300},legend:{enabled:!1,tooltip:{contentInternal:{background:{disablePointerEvents:!1}}}}},choropleth:{},bubbleMap:{},markerMap:{},connector:{},seatMap:{}});}).call(this,$)}
if(!_.theme_mekko){_.theme_mekko=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{mekko:{defaultSeriesType:"mekko",isVertical:!1,normal:{labels:{enabled:!0}},defaultSeriesSettings:{base:{normal:{fill:$.TJ,stroke:$.YJ,labels:{format:"{%Value}{decimalsCount:2}",position:"center",offsetY:0,fontColor:"#ffffff"},markers:{position:"center",anchor:"center"}},hovered:{fill:$.RJ,stroke:function(){return $.Lk($.xk(this.sourceColor),1)}},legendItem:{iconStroke:"none"},isVertical:!1,tooltip:{anchor:"left-top"}},mekko:{}},defaultXAxisSettings:{orientation:"bottom",
title:{text:"X-Axis",padding:{top:5,right:0,bottom:0,left:0}},labels:{format:"{%Value}"},scale:0},defaultYAxisSettings:{orientation:"left",title:{text:"Y-Axis",padding:{top:0,right:0,bottom:5,left:0}},labels:{format:"{%Value}%"},scale:1},xAxes:[{}],yAxes:[{}],scales:[{type:"ordinal"},{type:"linear",stackMode:"percent",stackDirection:"direct",minimumGap:0,maximumGap:0},{type:"ordinal"},{type:"ordinal"}],crosshair:{enabled:!1,displayMode:"float",xStroke:"#969EA5",yStroke:"#969EA5",zIndex:41,xLabels:[{enabled:null}],
yLabels:[{enabled:null}]},xScale:0,yScale:1,firstCategoriesScale:2,lastCategoriesScale:3,defaultAnnotationSettings:{},annotations:{annotationsList:[],zIndex:2E3},pointsPadding:0,barsPadding:0,barGroupsPadding:0},mosaic:{pointsPadding:5,defaultXAxisSettings:{stroke:0,ticks:{enabled:!1}},defaultYAxisSettings:{stroke:0,ticks:{enabled:!1},labels:{format:"{%Value}"}}},barmekko:{scales:[{type:"ordinal"},{type:"linear",stackMode:"value",softMinimum:0},{type:"ordinal"},{type:"ordinal"}],defaultSeriesSettings:{mekko:{normal:{fill:function(){var a=
1<this.chart.getSeriesCount()?this.sourceColor:this.chart.palette().itemAt(this.iterator.ka());a=a?a:this.sourceColor;return $.Ck(a,.85,!0)},stroke:function(){var a=1<this.chart.getSeriesCount()?this.sourceColor:this.chart.palette().itemAt(this.iterator.ka());a=a?a:this.sourceColor;return $.Lk(a,1)},labels:{format:"{%Value}{decimalsCount:2}",anchor:"auto",position:"value",fontColor:"#7c868e"},markers:{position:"value",positionFormatter:$.MJ}},hovered:{fill:function(){var a=1<this.chart.getSeriesCount()?
this.sourceColor:this.chart.palette().itemAt(this.iterator.ka());a=a?a:this.sourceColor;return $.Ck(a,.65,!0)}}}},defaultYAxisSettings:{labels:{format:"{%Value}"}},normal:{labels:{enabled:!1}}}});}).call(this,$)}
if(!_.theme_pareto){_.theme_pareto=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{pareto:{defaultSeriesType:"column",tooltip:{displayMode:"union"},interactivity:{hoverMode:"by-x"},yAxes:[{orientation:"left"},{orientation:"right",labels:{format:"{%Value}%"}}]}});}).call(this,$)}
if(!_.theme_pert){_.theme_pert=1;(function($){var qP=function(){return $.Lk(this.sourceColor,1.5)};
$.ra($.fa.anychart.themes.defaultTheme,{pert:{tooltip:{enabled:!1},horizontalSpacing:"15%",verticalSpacing:"25%",expectedTimeCalculator:function(){return void 0===this.duration?Math.round((this.optimistic+4*this.mostLikely+this.pessimistic)/6*100)/100:Number(this.duration)},background:{zIndex:0},milestones:{shape:"circle",size:"5%",normal:{labels:{enabled:!0,anchor:"left-top",vAlign:"middle",hAlign:"center",fontColor:"#fff",disablePointerEvents:!0,format:function(){return this.creator?this.index:
this.isStart?"S":"F"}},fill:$.TJ,stroke:"none"},hovered:{labels:{enabled:null,fontColor:"#fff",fontOpacity:1},fill:$.VJ,stroke:qP},selected:{labels:{enabled:null,fontWeight:"bold"},fill:"#333 0.85",stroke:"#333 0.85"},color:"#64b5f6",tooltip:{title:{enabled:!0},separator:{enabled:!0},titleFormat:function(){return this.creator?"Milestone - "+this.index:"Milestone - "+(this.isStart?"Start":"Finish")},format:function(){var a="",b;if(this.successors&&this.successors.length){a+="Successors:";for(b=0;b<
this.successors.length;b++)a+="\n - "+this.successors[b].get("name");this.predecessors&&this.predecessors.length&&(a+="\n\n")}if(this.predecessors&&this.predecessors.length)for(a+="Predecessors:",b=0;b<this.predecessors.length;b++)a+="\n - "+this.predecessors[b].get("name");return a}}},tasks:{color:"#64b5f6",normal:{fill:$.TJ,stroke:$.TJ,dummyFill:$.TJ,dummyStroke:function(){return{color:this.sourceColor,dash:"6 4"}},upperLabels:{enabled:!0,anchor:"center-bottom",vAlign:"bottom",hAlign:"center",fontSize:10,
contColor:"#333",padding:{top:1,right:10,bottom:1,left:10},format:function(){return this.name}},lowerLabels:{enabled:!0,anchor:"center-top",vAlign:"top",hAlign:"center",fontSize:9,fontOpacity:.5,contColor:"#333",padding:{top:1,right:5,bottom:1,left:5},format:function(){return"t: "+$.LJ(this.duration)}}},hovered:{fill:$.VJ,stroke:qP,upperLabels:{fontWeight:"bold"},lowerLabels:{fontWeight:"bold"}},selected:{fill:"#333 0.85",stroke:"#333 0.85",upperLabels:{fontWeight:"bold"},lowerLabels:{fontWeight:"bold"}},
tooltip:{title:{enabled:!0},separator:{enabled:!0},titleFormat:function(){return this.name},format:function(){var a="Earliest start: "+$.LJ(this.earliestStart)+"\nEarliest finish: "+$.LJ(this.earliestFinish)+"\nLatest start: "+$.LJ(this.latestStart)+"\nLatest finish: "+$.LJ(this.latestFinish)+"\nDuration: "+$.LJ(this.duration)+"\nSlack: "+$.LJ(this.slack);(0,window.isNaN)(this.variance)||(a+="\nStandard deviation: "+Math.round(100*this.variance)/100);return a}}},criticalPath:{tasks:{tooltip:{title:{background:null}},
color:"#e06666",normal:{lowerLabels:{},upperLabels:{}}},milestones:{tooltip:{title:{background:null}}}}}});}).call(this,$)}
if(!_.theme_pie){_.theme_pie=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{pie:{sliceDrawer:function(){$.zC.vector.primitives.donut(this.path,this.centerX+this.explodeX,this.centerY+this.explodeY,this.outerRadius,this.innerRadius,this.startAngle,this.sweepAngle)},interactivity:{multiSelectOnClick:!0,unselectOnClickOutOfPoint:!1},animation:{duration:2E3},title:{text:"Pie Chart"},group:!1,sort:"none",radius:"45%",innerRadius:0,startAngle:0,outsideLabelsCriticalAngle:60,insideLabelsOffset:"50%",center:{fill:"none",stroke:"none"},normal:{labels:{format:"{%PercentValue}{decimalsCount:1,zeroFillDecimals:true}%"},
explode:0,outline:{enabled:!0,width:0,offset:0,fill:$.WJ,stroke:"none"}},hovered:{explode:0,outline:{enabled:null,width:10,offset:0,fill:$.PJ,stroke:"none"}},selected:{explode:"5%",fill:$.PJ,stroke:"none",outline:{enabled:null,width:10,offset:0,fill:$.WJ,stroke:"none"}},a11y:{titleFormat:$.dK}},pie3d:{radius:"65%",mode3d:!0,selected:{explode:"5%"},aspect3d:.45,connectorLength:"15%",legendItem:{iconStroke:null}}});}).call(this,$)}
if(!_.theme_polar){_.theme_polar=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{polar:{defaultSeriesType:"marker",defaultSeriesSettings:{base:{closed:!0,clip:!1},area:{},line:{},marker:{},column:{},rangeColumn:{}},xAxis:{scale:0,zIndex:25,fill:"none",labels:{position:"outside",vAlign:"middle",hAlign:"middle",anchor:"auto",zIndex:25},minorLabels:{anchor:"auto",zIndex:25},ticks:{zIndex:25},minorTicks:{zIndex:25}},yAxis:{scale:1},startAngle:0,innerRadius:0,sortPointsByX:!1,xGrids:[{}],yGrids:[{}],minorGrids:[],scales:[{type:"linear"},{type:"linear"}],
xScale:0,yScale:1,barsPadding:0,barGroupsPadding:0,a11y:{titleFormat:$.fK}}});}).call(this,$)}
if(!_.theme_pyramid_funnel){_.theme_pyramid_funnel=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{funnel:{title:{text:"Funnel Chart"},neckWidth:"30%",neckHeight:"25%",reversed:!0,normal:{labels:{position:"outside-left-in-column"}}},pyramid:{title:{text:"Pyramid Chart"},legend:{inverted:!0},normal:{labels:{position:"outside-left-in-column"}},reversed:!1}});}).call(this,$)}
if(!_.theme_radar){_.theme_radar=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{radar:{defaultSeriesType:"line",defaultSeriesSettings:{base:{clip:!1},area:{},line:{},marker:{}},xAxis:{scale:0,zIndex:25,labels:{zIndex:25},minorLabels:{zIndex:25},ticks:{zIndex:25},minorTicks:{zIndex:25}},yAxis:{scale:1},startAngle:0,innerRadius:0,xGrids:[{}],yGrids:[{}],minorGrids:[],scales:[{type:"ordinal"},{type:"linear"}],xScale:0,yScale:1,a11y:{titleFormat:$.eK}}});}).call(this,$)}
if(!_.theme_resource){_.theme_resource=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{resource:{calendar:{},conflicts:{labels:{enabled:!0,anchor:"left-top",hAlign:"center",fontSize:"8pt",padding:0,fontColor:"#F4F4F4",format:"{%hours}{decimalsCount:1}h ({%percent}{decimalsCount:2}%)"},fill:"#dd2c00",stroke:"none",hatchFill:null,height:15,zIndex:100},overlay:{enabled:!1},activities:{normal:{labels:{enabled:!0,anchor:"left-top",fontColor:"#F4F4F4",format:"{%name} ({%hoursPerDayRounded}{decimalsCount:1}h)",position:"left-top"},fill:"#1976d2",stroke:null,
hatchFill:!1},hovered:{labels:{enabled:null},fill:$.VJ,stroke:$.PJ,hatchFill:null},selected:{labels:{enabled:null},fill:"#333",stroke:$.PJ,hatchFill:null}},resourceList:{oddFill:"none",evenFill:"none",enabled:!0,width:"100%",height:"100%",background:{enabled:!0,fill:"#F3F7FA",stroke:"none",cornerType:"none",corners:0},images:{borderRadius:10,opacity:1,align:"none",fittingMode:"meet",size:"25%",margin:{top:5,right:0,bottom:5,left:5}},baseSettings:{margin:{top:2,right:0,bottom:3,left:5},fontSize:15,
textOverflow:"...",fontFamily:'"Helvetica Neue","Helvetica",sans-serif'},names:{margin:{top:5,right:0,bottom:3,left:5},fontSize:17,fontWeight:"bold",fontColor:"#000"},types:{fontSize:10,fontColor:"#212121"},descriptions:{fontSize:12,fontColor:"#959CA0",fontWeight:"bold"},tags:{fontSize:9,fontColor:"#212121",background:{enabled:!0,fill:"#eee",stroke:"#ccc",cornerType:"round",corners:4},padding:5,margin:{top:2,right:0,bottom:3,left:5}},drawTopLine:!1,drawRightLine:!1,drawBottomLine:!0,drawLeftLine:!1,
stroke:"#ccc",zIndex:2,overlay:!0},logo:{enabled:!0,fill:"#E7ECF0",stroke:"none",bottomStroke:"#ccc",zIndex:2,overlay:!1},timeLine:{enabled:!0,background:{enabled:!1},overlay:{enabled:!1},zIndex:2,vAlign:"middle",hAlign:"center",textOverflow:"",fill:"none",stroke:"#ccc",padding:[2,10,2,10],fontSize:11,fontWeight:"bold",fontFamily:'"Helvetica Neue", Helvetica, sans-serif',drawTopLine:!1,drawRightLine:!1,drawBottomLine:!0,drawLeftLine:!1},grid:{overlay:{enabled:!1},background:{enabled:!1,fill:"#F3F7FA"},
oddFill:"#fff",evenFill:"#fff",oddHolidayFill:"#F4F4F4 .7",evenHolidayFill:"#F4F4F4 .7",oddHatchFill:null,evenHatchFill:null,oddHolidayHatchFill:null,evenHolidayHatchFill:null,horizontalStroke:"#ccc",verticalStroke:"#ccc",drawTopLine:!1,drawRightLine:!1,drawBottomLine:!0,drawLeftLine:!1,zIndex:2},xScale:{minimumGap:.01,maximumGap:.01},horizontalScrollBar:{enabled:!0,allowRangeChange:!1,autoHide:!0,orientation:"bottom",thumbs:!1,fill:null,zIndex:1010},verticalScrollBar:{enabled:!0,allowRangeChange:!1,
autoHide:!0,orientation:"right",thumbs:!1,fill:null,zIndex:1010,inverted:!0},zoomLevels:[{id:"days",levels:[{unit:"day",count:1,formats:["MMM\ndd  EEEE"],format:function(){return this.value.toUpperCase()},hAlign:"left"}],unit:"day",count:1,unitPixSize:220},{id:"weeks",levels:[{unit:"day",count:1,formats:["dd EEE","dd"],hAlign:"left",fill:"#fff",fontColor:"#ABB6BC",format:function(){return this.value.toUpperCase()},height:30},{unit:"week",count:1,formats:["w MMM"],fill:"#F0F5F8",format:function(){return this.value.toUpperCase()}}],
unit:"day",count:1,unitPixSize:100},{id:"months",levels:[{unit:"day",count:1,formats:["d EEE","d"],hAlign:"center",padding:[2,5,2,5],fill:"#fff",format:function(){return this.value.toUpperCase()},height:30},{unit:"week",count:1,formats:["w MMM"],fill:"#F0F5F8",format:function(){return this.value.toUpperCase()}}],unit:"day",count:1,unitPixSize:25}],zoomLevel:0,padding:0,margin:20,resourceListWidth:260,timeLineHeight:52,cellPadding:[2,2,2,2],minRowHeight:50,pixPerHour:25,defaultMinutesPerDay:60,splitterStroke:"#ccc",
timeTrackingMode:"activity-per-resource",background:{enabled:!0,stroke:"#ccc"},tooltip:{allowLeaveScreen:!1,allowLeaveChart:!0,displayMode:"single",positionMode:"float",title:{enabled:!0,fontSize:13},separator:{enabled:!0},titleFormat:"{%name}",format:function(){return"Starts: "+$.hr(this.start)+"\nEnds: "+$.hr(this.end)}}}});
$.ra($.fa.anychart.themes.defaultTheme.standalones,{resourceList:{width:"33%",height:"100%",background:{enabled:!0,fill:"#ccc",stroke:"#ccc",cornerType:"none",corners:0},rowHeight:null,minRowHeight:"20%",maxRowHeight:"50%",images:{borderRadius:10,opacity:1,align:"none",fittingMode:"meet",size:"25%",margin:{top:5,right:0,bottom:5,left:5}},baseSettings:{margin:{top:2,right:0,bottom:3,left:5},fontSize:15,textOverflow:"..."},names:{margin:{top:5,right:0,bottom:3,left:5}},types:{fontSize:10,fontColor:"#212121"},
descriptions:{fontSize:12,fontColor:"#545f69",fontStyle:"oblique"},tags:{fontSize:9,fontColor:"#212121",background:{enabled:!0,fill:"#eee",stroke:"#ccc",cornerType:"round",corners:4},padding:5,margin:{top:2,right:0,bottom:3,left:5}}}});}).call(this,$)}
if(!_.theme_scatter){_.theme_scatter=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{scatter:{defaultSeriesType:"marker",legend:{enabled:!1},defaultSeriesSettings:{base:{clip:!0,color:null,tooltip:{titleFormat:function(){return this.seriesName},format:function(){return"x: "+this.x+"\ny: "+this.valuePrefix+$.LJ(this.value)+this.valuePostfix}},xScale:null,yScale:null,a11y:{enabled:!1,titleFormat:"Series named {%SeriesName} with {%SeriesPointsCount} points. Min value is {%SeriesYMin}, max value is {%SeriesYMax}"}},bubble:{normal:{negativeFill:$.UJ,
negativeStroke:$.UJ,negativeHatchFill:null,labels:{anchor:"center"}},hovered:{negativeFill:$.UJ,negativeStroke:$.UJ,negativeHatchFill:void 0},displayNegative:!1,hatchFill:!1,tooltip:{format:function(){return"X: "+this.x+"\nY: "+this.valuePrefix+$.LJ(this.value)+this.valuePostfix+"\nSize: "+$.LJ(this.size)}}},line:{connectMissingPoints:!1},marker:{normal:{size:5},hovered:{size:7},selected:{size:7}}},defaultAnnotationSettings:{},defaultXAxisSettings:{orientation:"bottom",scale:0,title:{text:"X-Axis"}},
defaultYAxisSettings:{orientation:"left",scale:1,title:{text:"Y-Axis"}},series:[],xGrids:[],yGrids:[],xMinorGrids:[],yMinorGrids:[],xAxes:[{}],yAxes:[{}],lineAxesMarkers:[],rangeAxesMarkers:[],textAxesMarkers:[],scales:[{type:"linear"},{type:"linear"}],xScale:0,yScale:1,maxBubbleSize:"20%",minBubbleSize:"5%",crosshair:{enabled:!1,displayMode:"float",xStroke:"#969EA5",yStroke:"#969EA5",zIndex:41,xLabels:[{enabled:null}],yLabels:[{enabled:null}]},a11y:{titleFormat:$.fK},annotations:{annotationsList:[],
zIndex:2E3}},marker:{},bubble:{},quadrant:{scales:[{type:"linear",minimum:0,maximum:100},{type:"linear",minimum:0,maximum:100}],xScale:0,yScale:1,defaultXAxisSettings:{ticks:!1,labels:!1,title:{enabled:!1,align:"left"},stroke:"3 #bbdefb"},defaultYAxisSettings:{ticks:!1,labels:!1,title:{enabled:!1,align:"left"},stroke:"3 #bbdefb"},xAxes:[{},{orientation:"top"}],yAxes:[{},{orientation:"right"}],crossing:{stroke:"#bbdefb"},quarters:{rightTop:{enabled:!0},leftTop:{enabled:!0},leftBottom:{enabled:!0},
rightBottom:{enabled:!0}}}});}).call(this,$)}
if(!_.theme_sparkline){_.theme_sparkline=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{sparkline:{background:{enabled:!0},title:{enabled:!1,padding:0,margin:0,orientation:"right",rotation:0},margin:0,padding:0,hatchFill:null,markers:{},interactivity:{hoverMode:"by-x"},firstMarkers:{fill:"#64b5f6"},lastMarkers:{fill:"#64b5f6"},negativeMarkers:{fill:"#ef6c00"},minMarkers:{fill:"#455a64"},maxMarkers:{fill:"#dd2c00"},labels:{},firstLabels:{},lastLabels:{},negativeLabels:{},minLabels:{fontSize:9,padding:{top:3,right:0,bottom:3,left:0},fontColor:"#303f46"},
maxLabels:{fontSize:9,padding:{top:3,right:0,bottom:3,left:0},fontColor:"#9b1f00"},lineAxesMarkers:[],rangeAxesMarkers:[],textAxesMarkers:[],scales:[{type:"ordinal"},{type:"linear"}],xScale:0,yScale:1,clip:!0,seriesType:"line",connectMissingPoints:!1,pointWidth:"95%",tooltip:{title:!1,separator:!1,titleFormat:function(){return this.x},format:function(){return"x: "+this.x+"\ny: "+$.LJ(this.value)},allowLeaveChart:!0},defaultSeriesSettings:{base:{markers:{enabled:!1,position:"center",anchor:"center",
type:"circle",size:1.8,stroke:"none"},hoverMarkers:{enabled:!0},labels:{enabled:!1,fontSize:8,background:{enabled:!1},position:"center",anchor:"center-bottom"},minLabels:{position:"center-bottom",anchor:"center-bottom"},maxLabels:{position:"center-top",anchor:"center-top"},color:"#64b5f6"},area:{stroke:"#64b5f6",fill:"#64b5f6 0.5"},column:{markers:{position:"center-top"},labels:{position:"center-top",anchor:"center-bottom"},negativeMarkers:{position:"center-bottom"},negativeLabels:{position:"center-bottom",
anchor:"center-top"},fill:"#64b5f6",negativeFill:"#ef6c00"},line:{stroke:"#64b5f6"},winLoss:{markers:{position:"center-top",anchor:"center-top"},labels:{position:"center-top",anchor:"center-top"},negativeMarkers:{position:"center-bottom",anchor:"center-bottom"},negativeLabels:{position:"center-bottom",anchor:"center-bottom"},fill:"#64b5f6",negativeFill:"#ef6c00"}}}});}).call(this,$)}
if(!_.theme_stock){_.theme_stock=1;(function($){var wla=function(){var a=this.defaultDecimalDigitsCount||void 0;return this.seriesName+":\n  Open: "+$.LJ(this.open,a)+"\n  High: "+$.LJ(this.high,a)+"\n  Low: "+$.LJ(this.low,a)+"\n  Close: "+$.LJ(this.close,a)},p$=function(){return $.gr(this.x,$.er($.dr(this.dataIntervalUnit,void 0,"full")))},xla=function(){return $.gr(this.hoveredDate,$.er($.dr(this.dataIntervalUnit,void 0,"full")))};
$.ra($.fa.anychart.themes.defaultTheme,{defaultGroupingSettings:{enabled:!0,forced:!1,levels:[{unit:"millisecond",count:1},{unit:"millisecond",count:5},{unit:"millisecond",count:10},{unit:"millisecond",count:25},{unit:"millisecond",count:50},{unit:"millisecond",count:100},{unit:"millisecond",count:250},{unit:"millisecond",count:500},{unit:"second",count:1},{unit:"second",count:5},{unit:"second",count:10},{unit:"second",count:20},{unit:"second",count:30},{unit:"minute",count:1},{unit:"minute",count:5},
{unit:"minute",count:15},{unit:"minute",count:30},{unit:"hour",count:1},{unit:"hour",count:2},{unit:"hour",count:6},{unit:"hour",count:12},{unit:"day",count:1},{unit:"week",count:1},{unit:"month",count:1},{unit:"month",count:3},{unit:"month",count:6},{unit:"year",count:1}],maxVisiblePoints:500,minPixPerPoint:window.NaN},stock:{grouping:{},scrollerGrouping:{levels:[{unit:"millisecond",count:1},{unit:"millisecond",count:2},{unit:"millisecond",count:5},{unit:"millisecond",count:10},{unit:"millisecond",
count:25},{unit:"millisecond",count:50},{unit:"millisecond",count:100},{unit:"millisecond",count:250},{unit:"millisecond",count:500},{unit:"second",count:1},{unit:"second",count:2},{unit:"second",count:5},{unit:"second",count:10},{unit:"second",count:20},{unit:"second",count:30},{unit:"minute",count:1},{unit:"minute",count:2},{unit:"minute",count:5},{unit:"minute",count:10},{unit:"minute",count:20},{unit:"minute",count:30},{unit:"hour",count:1},{unit:"hour",count:2},{unit:"hour",count:3},{unit:"hour",
count:4},{unit:"hour",count:6},{unit:"hour",count:12},{unit:"day",count:1},{unit:"day",count:2},{unit:"day",count:4},{unit:"week",count:1},{unit:"week",count:2},{unit:"month",count:1},{unit:"month",count:2},{unit:"month",count:3},{unit:"month",count:6},{unit:"year",count:1}],maxVisiblePoints:window.NaN,minPixPerPoint:1},defaultAnnotationSettings:{},defaultPlotSettings:{defaultLineMarkerSettings:{zIndex:200.2},defaultTextMarkerSettings:{zIndex:200.3},annotations:{annotationsList:[],zIndex:2E3},background:{enabled:!1},
title:{text:"Plot Title",padding:[5,5,2,5],fontSize:12},defaultSeriesSettings:{base:{pointWidth:"75%",tooltip:{format:function(){var a=$.LJ(this.value,this.defaultDecimalDigitsCount||void 0);return this.seriesName+": "+this.valuePrefix+a+this.valuePostfix},titleFormat:xla},legendItem:{iconStroke:"none"},normal:{labels:{offsetY:10}}},areaLike:{normal:{labels:{format:p$}},hovered:{markers:{enabled:null}},selected:{markers:{enabled:null}}},lineLike:{normal:{labels:{format:p$}},hovered:{markers:{enabled:null}},
selected:{markers:{enabled:null}}},rangeLike:{normal:{labels:{format:p$}},tooltip:{format:function(){var a=this.defaultDecimalDigitsCount||void 0;return this.seriesName+":\n  High: "+$.LJ(this.high,a)+"\n  Low: "+$.LJ(this.low,a)}}},candlestick:{normal:{labels:{format:p$}},tooltip:{format:wla}},column:{normal:{labels:{format:p$},stroke:"none"}},rangeColumn:{normal:{labels:{format:p$},stroke:"none"}},ohlc:{normal:{labels:{format:p$}},tooltip:{format:wla}}},defaultGridSettings:{scale:0},defaultMinorGridSettings:{scale:0},
defaultYAxisSettings:{enabled:!0,orientation:"left",title:{enabled:!1,text:"Y-Axis"},staggerMode:!1,staggerLines:null,ticks:{enabled:!0},width:50,labels:{fontSize:"11px",padding:{top:0,right:5,bottom:0,left:5}},minorLabels:{fontSize:"11px",padding:{top:0,right:5,bottom:0,left:5}},scale:0},defaultPriceIndicatorSettings:{label:{enabled:!0,background:{enabled:!0,fill:"#000"},fontColor:"#fff",padding:[2,9],hAlign:"center",fontSize:"11px"},stroke:"black"},xAxis:{enabled:!0,orientation:"bottom",background:{stroke:"#cecece",
fill:"#F7F7F7"},height:25,showHelperLabel:!0,scale:0,ticks:{enabled:!1,position:"center"},labels:{enabled:!0,fontSize:"11px",padding:5,anchor:"center-top",format:function(){return $.gr(this.dataValue,$.er($.dr(this.majorIntervalUnit)))}},minorLabels:{enabled:!0,anchor:"center-top",fontSize:"11px",padding:{top:5,right:0,bottom:5,left:0},format:function(){return $.gr(this.dataValue,$.er($.dr(this.minorIntervalUnit,this.majorIntervalUnit)))}}},dateTimeHighlighter:"#B9B9B9",legend:{enabled:!0,vAlign:"bottom",
iconSize:13,position:"top",titleFormat:function(){return $.gr(this.value,$.er($.dr(this.dataIntervalUnit,void 0,"full")))},align:"left",padding:10,title:{enabled:!0,fontSize:12,text:"",background:{enabled:!1,fill:{keys:["#fff","#f3f3f3","#fff"],angle:"90"},stroke:{keys:["#ddd","#d0d0d0"],angle:"90"}},margin:{top:0,right:15,bottom:0,left:0},padding:0,orientation:"left",align:"left",hAlign:"left",rotation:0,wordBreak:"break-all"},titleSeparator:{enabled:!1,width:"100%",height:1,margin:{top:3,right:0,
bottom:3,left:0},orientation:"top",fill:["#000 0","#000","#000 0"],stroke:"none"}},scales:[{type:"linear"}],yScale:0,zIndex:10,yAxes:[{}],crosshair:{zIndex:201,xLabels:[{enabled:null}],yLabels:[{enabled:null}]},dataArea:{zIndex:10,background:{fill:"none"}},baseline:0},padding:[20,30,20,60],plots:[{}],eventMarkers:{stickToLeft:!0,normal:{type:"circle",width:22,height:22,fill:"#515151",stroke:"#515151",fontColor:"#fff",adjustFontSize:!0,minFontSize:6,maxFontSize:20,fontSize:null,format:"A",hAlign:"center",
vAlign:"middle",fontPadding:2,connector:{length:5,stroke:"#455a64"}},hovered:{fill:$.VJ},selected:{fill:"#dd2c00"},tooltip:{title:{fontColor:"#fff",enabled:!0},titleFormat:function(){var a=$.gr(this.date,$.er($.dr(this.dataIntervalUnit,void 0,"full")));return this.title?this.title+" ("+a+")":a},format:function(){return this.description||this.symbol},fontColor:"#fff",separator:!0},direction:"auto",position:"axis",seriesId:"0",fieldName:"value"},scroller:{defaultSeriesSettings:{base:{enabled:!0,normal:{fill:"#999 0.6",
stroke:"#999 0.6",lowStroke:"#999 0.6",highStroke:"#999 0.6"},selected:{fill:$.PJ,stroke:$.PJ,lowStroke:$.PJ,highStroke:$.PJ},pointWidth:"75%"},marker:{normal:{fill:"#999 0.6",stroke:"#999 0.6"},selected:{fill:$.PJ,stroke:$.PJ}},areaLike:{normal:{fill:"#999 0.6"}},barLike:{normal:{fill:"#999 0.6"}},candlestick:{normal:{risingFill:"#999 0.6",risingStroke:"#999 0.6",fallingFill:"#999 0.6",fallingStroke:"#999 0.6"},selected:{risingFill:"#64b5f6",risingStroke:"#64b5f6",fallingFill:"#ef6c00",fallingStroke:"#ef6c00"}},
ohlc:{normal:{risingStroke:"#999 0.6",fallingStroke:"#999 0.6"},selected:{risingStroke:"#64b5f6",fallingStroke:"#ef6c00"}},stick:{normal:{stroke:"#999 0.6"},selected:{stroke:$.YJ}},jumpLine:{normal:{stroke:"#999 0.6"},selected:{stroke:$.YJ}}},enabled:!0,fill:"none",selectedFill:"#1976d2 0.2",outlineStroke:"#cecece",height:40,minHeight:null,maxHeight:null,zIndex:40,xAxis:{background:{enabled:!1},labels:{enabled:!0,fontSize:"11px",padding:5,anchor:"left-top",format:function(){return $.gr(this.dataValue,
$.er($.dr(this.majorIntervalUnit)))}},minorLabels:{enabled:!0,anchor:"left-top",fontSize:"11px",padding:5,format:function(){return $.gr(this.dataValue,$.er($.dr(this.minorIntervalUnit,this.majorIntervalUnit)))}},ticks:{position:"center"},minorTicks:{enabled:!0,stroke:"#cecece",position:"center"},zIndex:75,showHelperLabel:!0}},tooltip:{allowLeaveScreen:!0,displayMode:"union",title:{fontSize:13},titleFormat:xla},a11y:{titleFormat:$.cK},zoomMarqueeFill:"#d3d3d3 0.4",zoomMarqueeStroke:"#d3d3d3",interactivity:{zoomOnMouseWheel:!1,
scrollOnMouseWheel:!1},crosshair:{enabled:!0,displayMode:"sticky",xLabels:[{enabled:null}],yLabels:[{enabled:null}],xStroke:"#969EA5",yStroke:"#969EA5"}}});}).call(this,$)}
if(!_.theme_surface){_.theme_surface=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{surface:{rotationZ:17,rotationY:35,box:null,stroke:{color:""},colorScale:{type:"linear-color"},colorRange:{marker:{enabled:!1,type:"triangle-down"},labels:{useHtml:!0}},xAxis:{enabled:!0,orientation:"right",stroke:"red",labels:{useHtml:!0},ticks:{stroke:"red"},minorLabels:{useHtml:!0},minorTicks:{stroke:$.xk("red")}},yAxis:{enabled:!0,orientation:"bottom",stroke:"green",labels:{useHtml:!0},minorLabels:{useHtml:!0},ticks:{stroke:"green"},minorTicks:{stroke:$.xk("green")}},
zAxis:{enabled:!0,orientation:"left",stroke:"blue",labels:{useHtml:!0},minorLabels:{useHtml:!0},ticks:{stroke:"blue"},minorTicks:{stroke:$.xk("blue")}},xGrid:{zIndex:35,enabled:!0},yGrid:{zIndex:35,enabled:!0},zGrid:{zIndex:35,enabled:!0}}});}).call(this,$)}
if(!_.theme_tag_cloud){_.theme_tag_cloud=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{tagCloud:{anglesCount:7,fromAngle:-90,toAngle:90,mode:"spiral",textSpacing:1,scale:{type:"linear"},colorRange:{},colorScale:null,normal:{fontFamily:"Verdana, Helvetica, Arial, sans-serif",fontOpacity:1,fontDecoration:"none",fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",fill:function(){return $.Ck(this.scaledColor||this.sourceColor,.85,!0)}},hovered:{fill:$.RJ},selected:{fill:"#333 0.85"},tooltip:{enabled:!0,title:{enabled:!0},separator:{enabled:!0},
titleFormat:function(){return this.name||this.x},format:function(){return"Frequency: "+$.LJ(this.value)+"\nPercent of total: "+(100*this.value/this.getStat("sum")).toFixed(1)+"%"}},legend:{enabled:!1,itemsSourceMode:"categories",tooltip:{contentInternal:{background:{disablePointerEvents:!1}}}}}});}).call(this,$)}
if(!_.theme_timeline){_.theme_timeline=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{timeline:{interactivity:{zoomOnMouseWheel:!0,scrollOnMouseWheel:!0},defaultRangeMarkerSettings:{zIndex:30.1,scaleRangeMode:"consider"},defaultLineMarkerSettings:{zIndex:30.2,scaleRangeMode:"consider"},defaultTextMarkerSettings:{zIndex:30.3,scaleRangeMode:"consider",align:"top"},legend:{enabled:!1},axis:{enabled:!0,zIndex:35,height:32,stroke:"#004e72",fill:"#004e72",ticks:{enabled:!0,stroke:"2 #60899b",zIndex:36},labels:{padding:7.5,fontSize:12,fontColor:"#d6f8ff",
textOverflow:!0,format:"{%Value}",selectable:!1}},defaultSeriesSettings:{base:{direction:"auto",clip:!1},moment:{direction:"odd-even",connector:{length:"4%"},normal:{stroke:function(){return{color:$.xk(this.sourceColor),thickness:1,dash:"2 2"}},markers:{enabled:!0},labels:{fontColor:"#212121",padding:5,enabled:!0,anchor:"left-center",width:120,background:{enabled:!0,fill:"#f2f8ff .7",corners:2,stroke:"#CECECE"},fontSize:11,offsetX:5}},zIndex:33,tooltip:{titleFormat:function(){return $.hr(this.x)}}},
range:{direction:"up",zIndex:34,height:25,normal:{labels:{enabled:!0,anchor:"left-center",format:"{%x}",fontColor:"#000"},fill:function(){return this.sourceColor+" 0.3"}},tooltip:{format:"Start: {%start}{type:date}\nEnd: {%end}{type:date}"}}}}});}).call(this,$)}
if(!_.theme_treemap){_.theme_treemap=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{treeMap:{sort:"desc",labelsDisplayMode:"clip",headersDisplayMode:"always-show",colorRange:{zIndex:50},colorScale:{type:"ordinal-color"},tooltip:{enabled:!0,titleFormat:$.NJ,format:$.MJ},legend:{itemsSourceMode:"categories"},maxDepth:1,hintDepth:0,hintOpacity:.4,maxHeadersHeight:"25",normal:{fill:function(){var a;this.colorScale?a=this.colorScale.valueToColor(this.value):a=$.Ck(this.sourceColor,.85,!0);return a},stroke:"#e0e0e0",hatchFill:!1,labels:{enabled:!0,
hAlign:"center",vAlign:"middle",position:"center",anchor:"center",fontColor:"#212121",format:function(){return(this.name||this.getData("id"))+"\n"+$.LJ(this.value)}},markers:{enabled:!1,position:"center",size:6,fill:"#dd2c00",type:"circle"},headers:{enabled:!0,hAlign:"center",vAlign:"middle",position:"center",anchor:"center",background:{enabled:!0,fill:"#F7F7F7",stroke:"#e0e0e0"},format:$.NJ}},hovered:{fill:$.VJ,stroke:$.UJ,hatchFill:!1,labels:{enabled:null,fontWeight:"bold"},markers:{enabled:null,
size:8},headers:{enabled:!0,fontColor:"#333 0.85",background:{fill:"#e0e0e0",stroke:"#e0e0e0"}}},selected:{fill:"#333 0.85",stroke:"1.5 #212121",hatchFill:!1,labels:{enabled:null,fontColor:"#fafafa"},markers:{enabled:null,size:8,fill:"#333 0.85",stroke:"1.5 #212121"}}}});}).call(this,$)}
if(!_.theme_venn){_.theme_venn=1;(function($){var CR={titleFormat:"{%Name}",format:"Value: {%Value}"};
$.ra($.fa.anychart.themes.defaultTheme,{venn:{dataSeparator:"&",background:{zIndex:0},padding:{top:15,right:5,bottom:15,left:5},a11y:{enabled:!0,titleFormat:$.cK,mode:"chart-elements"},color:"#64b5f6",normal:{fill:$.SJ,stroke:"none",hatchFill:!1,labels:{fontColor:"#f4f4f4",format:"{%Name}",enabled:!0,disablePointerEvents:!0,zIndex:100,fontWeight:"bold"},markers:{enabled:!1,zIndex:99,disablePointerEvents:!0,stroke:"none"}},hovered:{fill:$.WJ,stroke:"none",hatchFill:!1,labels:{enabled:null},markers:{enabled:null}},
selected:{fill:"#333 0.85",stroke:"none",hatchFill:!1,labels:{enabled:null},markers:{enabled:null}},tooltip:CR,intersections:{normal:{fill:"#fff 0.00001",stroke:"none",labels:{fontWeight:"normal",format:"{%Value}",enabled:null},markers:{enabled:null}},hovered:{fill:"#fff 0.5",stroke:"none",labels:{enabled:null},hoverMarkers:{enabled:null}},selected:{fill:"#333 0.85",stroke:"none",labels:{enabled:null},markers:{enabled:null}},tooltip:CR},legend:{enabled:!0,zIndex:0,tooltip:{enabled:!1},padding:{top:10,
right:10,bottom:0,left:10},position:"bottom"}}});}).call(this,$)}
if(!_.theme_waterfall){_.theme_waterfall=1;(function($){$.ra($.fa.anychart.themes.defaultTheme,{waterfall:{dataMode:"diff",connectorStroke:"#697474",defaultSeriesType:"waterfall",defaultSeriesSettings:{waterfall:{normal:{fill:"#96a6a6",stroke:"#697474",risingFill:"#64b5f6",fallingFill:"#ef6c00",risingStroke:"#467fac",fallingStroke:"#a74c00",risingHatchFill:!1,fallingHatchFill:!1,labels:{enabled:!0,format:function(){return $.LJ(this.isTotal?this.absolute:this.diff)}}},hovered:{risingFill:$.RJ,fallingFill:$.RJ,risingStroke:$.ZJ,fallingStroke:$.ZJ,risingHatchFill:null,
fallingHatchFill:null},selected:{risingFill:"#333 0.85",fallingFill:"#333 0.85",risingStroke:"#333 0.85",fallingStroke:"#333 0.85",risingHatchFill:null,fallingHatchFill:null},tooltip:{format:function(){return this.isTotal?"Absolute: "+$.LJ(this.absolute):"Absolute: "+$.LJ(this.absolute)+"\nDifference: "+$.LJ(this.diff)}}}},legend:{enabled:!0,itemsSourceMode:"categories"},scales:[{type:"ordinal"},{type:"linear",softMinimum:0,stackDirection:"reverse"}]}});}).call(this,$)}
$_=window.anychart;$_.$=$;$_._=_});