<?php
// Controles sobre añadir y edicion de "reservations" || Controls on adding and editing "reservations"
$return = true; // Valor default exit
$values['lastUserUpdated']= $_SESSION['login'];
$values['lastDateUpdated']= now();

$V_idmedia = $values['media_idmedia'];
$V_idavailability = $values['availability_idavailability'];
$V_idreservations = $keys['idreservations'];

//  Control de rango de fechas | Date Range Control
if ($values['startDate'] >= $values['endDate']){
		$error = GetCustomLabel("RESERVATIONS_ERROR1"); //  Rango mal definido |  Poorly defined range
		$message = $error;
		$return = false;
    return ;
}

// Acceso a los datos del Tipo de Media || Access to Media Type data
$strSQL = "
SELECT m.`idmedia`, m.`type_media_idtype_media`, t.`maxTimeReservation`,  t.`startTimeDay`, t.`endTimeDay`
FROM media m
join type_media t on (m.`type_media_idtype_media` = t.`idtype_media`)
where m.`idmedia` = $V_idmedia
";
$rsSQL = db_query($strSQL,$conn);
$data = db_fetch_array($rsSQL);
$V_maxTimeReservation = $data['maxTimeReservation'];
$V_startTimeDay = $data['startTimeDay'];
$V_endTimeDay = $data['endTimeDay'];

$V_startDate = $values[startDate];
$V_endDate = $values[endDate];
$date1 = new DateTime($V_startDate);
$date2 = new DateTime($V_endDate);
$diff = $date1->diff($date2);

//   [y] => 0 // year
//   [m] => 0 // month
//    [d] => 2 // days

if ($diff->y <> 0 || $diff->m <> 0 || $diff->d <> 0 || $V_startDate == $V_endDate ) { // Son más de 24 horas
		$error = GetCustomLabel("RESERVATIONS_ERROR2"); //  Rango mal definido |  Poorly defined range
		$message = $error;
		$return = false;
    return ;
}
$str_diff = str_pad($diff->h,2,"0",STR_PAD_LEFT).':'.str_pad($diff->i,2,"0",STR_PAD_LEFT).':'.str_pad($diff->s,2,"0",STR_PAD_LEFT); // Format hh:mm:ss
if ( $str_diff > $V_maxTimeReservation ) {
		$error = GetCustomLabel("RESERVATIONS_ERROR2"); //  Rango demasiado grande ||  Range too large
		$message = $error;
		$return = false;
    return ;
}
$V_startTime = substr($V_startDate,11,8); // hh:ii of start
$V_endTime = substr($V_endDate,11,8); // hh:ii of start

// Control de hora y final de los rangos || Time and end range control
if ($V_startTime < $V_startTimeDay || $V_startTime > $V_endTimeDay || $V_endTime > $V_endTimeDay || $V_endTime < $V_startTimeDay) {
		$error = GetCustomLabel("RESERVATIONS_ERROR3"); // horas fuera de rango de reservas ||  hours out of reserve range
		$message = $error;
		$return = false;
    return ;
}
// Control de disponibilidad del rango seleccionado

$strSQL = "SELECT idavailability, media_idmedia, startDate, endDate
FROM availability
where startDate <= '$V_startDate' and
      endDate >= '$V_endDate'
 and idavailability = $V_idavailability ";
$rsSQL = db_query($strSQL,$conn);
$SQL_cnt = $rsSQL->num_rows;

if ($SQL_cnt == 0){
		$error = GetCustomLabel("RESERVATIONS_ERROR4"); //  Rango tiempo fuera de los límites de disponibilidad || Time range outside availability limits
		$message = $error;
		$return = false;
    return ;
}

$strSQL = "SELECT availability_idavailability, endDate, startDate, idreservations
FROM reservations
where availability_idavailability = $V_idavailability and  not(
endDate <= '$V_startDate' or
startDate >= '$V_endDate' ) ";
if ( $V_idreservations <> ''){
	$strSQL .= " and idreservations <> $V_idreservations"; // This is edit record
}
$rsSQL = db_query($strSQL,$conn);
$SQL_cnt = $rsSQL->num_rows;

if ($SQL_cnt <> 0){
		$error = GetCustomLabel("RESERVATIONS_ERROR5"); // Rango tiempo ya está utilizado || Time range is already used
		$message = $error;
		$return = false;
    return ;
}

// Cálculo de fecha efectiva || Effective Date Calculation
$values['effectiveDate'] = $values['endDate'];
if ($V_endTime==$V_endTimeDay) {
		$date = new DateTime($V_endDate);
		//Incrementando 1 día
		$mod_date = strtotime($date->format('d-m-Y H:i:s')."+ 1 days");                
		$values['effectiveDate'] = date("Y-m-d",$mod_date).' '.$V_startTimeDay;
}